/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.meta;

import com.magmaguy.elitemobs.CrashFix;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.api.EliteMobEnterCombatEvent;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.config.customspawns.CustomSpawnConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.CustomSpawn;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEscapeMechanism;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.specialpowers.EnderCrystalLightningRod;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class CustomSummonPower
extends ElitePower
implements Listener {
    private final List<CustomBossReinforcement> customBossReinforcements = new ArrayList<CustomBossReinforcement>();
    private final CustomBossesConfigFields customBossesConfigFields;

    public CustomSummonPower(Object powerObject, CustomBossesConfigFields customBossesConfigFields) {
        super(PowersConfig.getPower("custom_summon.yml"));
        this.customBossesConfigFields = customBossesConfigFields;
        this.addEntry(powerObject, customBossesConfigFields.getFilename());
    }

    public static CustomBossEntity summonReinforcement(EliteEntity summoningEntity, Location spawnLocation, String reinforcementFilename, int duration) {
        CustomBossEntity summoner;
        CustomBossesConfigFields fields = CustomBossesConfig.getCustomBoss(reinforcementFilename);
        if (fields == null) {
            Logger.warn((String)("Attempted to summon reinforcement " + reinforcementFilename + " which is not a valid reinforcement!"));
            return null;
        }
        CustomBossEntity customBossEntity = new CustomBossEntity(fields);
        customBossEntity.setSummoningEntity(summoningEntity);
        if (summoningEntity instanceof CustomBossEntity && (summoner = (CustomBossEntity)summoningEntity).isNormalizedCombat()) {
            customBossEntity.setNormalizedCombat();
        }
        summoningEntity.addReinforcement(customBossEntity);
        if (duration > 0) {
            CustomBossEscapeMechanism.startEscapeTicks(duration, customBossEntity);
        }
        customBossEntity.spawn(spawnLocation, true);
        return customBossEntity;
    }

    public static BukkitTask summonGlobalReinforcement(final CustomBossReinforcement customBossReinforcement, final CustomBossEntity summoningEntity) {
        if (customBossReinforcement.customSpawn == null || customBossReinforcement.customSpawn.isEmpty()) {
            Logger.warn((String)("Reinforcement for boss " + summoningEntity.getCustomBossesConfigFields().getFilename() + " has an incorrectly configured global reinforcement for " + customBossReinforcement.bossFileName));
            return null;
        }
        return new BukkitRunnable(){

            public void run() {
                if (summoningEntity.getGlobalReinforcementsCount() > 30 * summoningEntity.getSpawnLocation().getWorld().getPlayers().size()) {
                    return;
                }
                for (int i = 0; i < customBossReinforcement.amount; ++i) {
                    CustomSpawn customSpawn;
                    CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity(customBossReinforcement.bossFileName);
                    if (customBossEntity == null) {
                        Logger.warn((String)("Failed to spawn reinforcement because boss " + customBossReinforcement.bossFileName + " was invalid! Does the file exist? Is it configured correctly?"));
                        return;
                    }
                    if (summoningEntity.isNormalizedCombat()) {
                        customBossEntity.setNormalizedCombat();
                    }
                    if ((customSpawn = new CustomSpawn(customBossReinforcement.customSpawn, customBossEntity)).getCustomSpawnConfigFields() == null) continue;
                    customSpawn.setWorld(summoningEntity.getSpawnLocation().getWorld());
                    customSpawn.queueSpawn();
                    summoningEntity.addGlobalReinforcement(customBossEntity);
                    customBossReinforcement.isSummoned = true;
                    customBossEntity.setSummoningEntity(summoningEntity);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 200L);
    }

    public List<CustomBossReinforcement> getCustomBossReinforcements() {
        return this.customBossReinforcements;
    }

    public void addEntry(Object powerEntry, String filename) {
        if (powerEntry instanceof String) {
            this.processOldFormats((String)powerEntry, filename);
        } else if (powerEntry instanceof Map) {
            Map map = (Map)powerEntry;
            this.processNewFormat(map, filename);
        }
    }

    private void processNewFormat(Map<String, ?> map, String configFilename) {
        CustomBossReinforcement customBossReinforcement;
        Enum summonType = null;
        String filename = null;
        Vector location = null;
        Double chance = 1.0;
        boolean lightningRod = false;
        boolean inheritAggro = false;
        boolean inheritLevel = false;
        String customSpawn = "";
        int amount = 1;
        boolean spawnNearby = false;
        block36: for (Map.Entry<String, ?> entry : map.entrySet()) {
            switch (entry.getKey().toLowerCase(Locale.ROOT)) {
                case "summonable": {
                    continue block36;
                }
                case "summontype": {
                    summonType = MapListInterpreter.parseEnum(entry.getKey(), entry.getValue(), SummonType.class, this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "filename": {
                    filename = MapListInterpreter.parseString(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "chance": {
                    chance = MapListInterpreter.parseDouble(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "location": {
                    String locationString = MapListInterpreter.parseString(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    try {
                        location = new Vector(Double.parseDouble(locationString.split(",")[0]), Double.parseDouble(locationString.split(",")[1]), Double.parseDouble(locationString.split(",")[2]));
                    }
                    catch (Exception ex) {
                        Logger.warn((String)("Failed to get location for string " + locationString + " in " + this.customBossesConfigFields.getFilename()));
                    }
                    continue block36;
                }
                case "lightningrod": {
                    lightningRod = MapListInterpreter.parseBoolean(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "inheritaggro": {
                    inheritAggro = MapListInterpreter.parseBoolean(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "amount": {
                    amount = MapListInterpreter.parseInteger(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "inheritlevel": {
                    inheritLevel = MapListInterpreter.parseBoolean(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "spawnnearby": {
                    spawnNearby = MapListInterpreter.parseBoolean(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
                case "customspawn": {
                    if (CustomSpawnConfig.getCustomEvent(MapListInterpreter.parseString(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename())) == null) {
                        Logger.warn((String)("Failed to determine Custom Spawn file for filename " + String.valueOf(entry.getValue())));
                        continue block36;
                    }
                    customSpawn = MapListInterpreter.parseString(entry.getKey(), entry.getValue(), this.customBossesConfigFields.getFilename());
                    continue block36;
                }
            }
            Logger.warn((String)"Invalid boss reinforcement!");
            Logger.warn((String)("Problematic entry: " + String.valueOf(entry.getValue())));
        }
        if (summonType == null) {
            Logger.warn((String)("No summon type detected in " + this.customBossesConfigFields.getFilename() + " ! This reinforcement will not work."));
            return;
        }
        switch (2.$SwitchMap$com$magmaguy$elitemobs$powers$meta$CustomSummonPower$SummonType[summonType.ordinal()]) {
            case 1: {
                customBossReinforcement = this.doOnce(filename);
                break;
            }
            case 2: {
                customBossReinforcement = this.doOnHit(filename, chance);
                break;
            }
            case 3: {
                customBossReinforcement = this.doOnDeath(filename);
                break;
            }
            case 4: {
                customBossReinforcement = this.doOnCombatEnter(filename);
                break;
            }
            case 5: {
                customBossReinforcement = this.doOnCombatEnterPlaceCrystal(location, lightningRod);
                break;
            }
            case 6: {
                customBossReinforcement = this.doGlobalSummonReinforcement(filename);
                break;
            }
            default: {
                customBossReinforcement = null;
                Logger.warn((String)("Failed to determine summon type for reinforcement in " + this.customBossesConfigFields.getFilename() + " ! Contact the developer with this error!"));
            }
        }
        if (summonType != SummonType.ON_COMBAT_ENTER_PLACE_CRYSTAL && (customBossReinforcement == null || customBossReinforcement.bossFileName == null || CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName) == null)) {
            Logger.warn((String)("Could not get filename for reinforcement in file " + configFilename));
            return;
        }
        if (customBossReinforcement == null) {
            return;
        }
        customBossReinforcement.inheritAggro = inheritAggro;
        customBossReinforcement.amount = amount;
        customBossReinforcement.inheritLevel = inheritLevel;
        customBossReinforcement.spawnNearby = spawnNearby;
        customBossReinforcement.customSpawn = customSpawn;
        customBossReinforcement.summonChance = chance;
        customBossReinforcement.setSpawnLocationOffset(location);
    }

    private void processOldFormats(String powerString, String configFilename) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (powerString.split(":")[0].equalsIgnoreCase("summon")) {
            if (powerString.split(":")[1].equalsIgnoreCase("once")) {
                newMap.put("summonType", "ONCE");
                this.parseOnce(powerString);
            } else if (powerString.split(":")[1].equalsIgnoreCase("onHit")) {
                newMap.put("summonType", "ON_HIT");
                this.parseOnHit(powerString);
            } else if (powerString.split(":")[1].equalsIgnoreCase("onCombatEnter")) {
                newMap.put("summonType", "ON_COMBAT_ENTER");
                this.parseOnCombatEnter(powerString);
            } else if (powerString.split(":")[1].equalsIgnoreCase("onCombatEnterPlaceCrystal")) {
                newMap.put("summonType", "ON_COMBAT_ENTER_PLACE_CRYSTAL");
                this.parseOnCombatEnterPlaceCrystal(powerString);
            }
            this.replaceOldFormat(powerString, newMap);
            return;
        }
        if (powerString.split(":")[0].equalsIgnoreCase("summonable")) {
            CustomBossReinforcement customBossReinforcement;
            Enum summonType = null;
            String filename = null;
            Vector location = null;
            Double chance = null;
            boolean lightningRod = false;
            boolean inheritAggro = false;
            boolean inheritLevel = false;
            String customSpawn = "";
            int amount = 1;
            boolean spawnNearby = false;
            block52: for (String substring : powerString.split(":")) {
                switch (substring.split("=")[0].toLowerCase(Locale.ROOT)) {
                    case "summonable": {
                        continue block52;
                    }
                    case "summontype": {
                        try {
                            summonType = SummonType.valueOf(this.getSubstringField(substring));
                            newMap.put("summonType", summonType.toString());
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine summon type from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "filename": {
                        try {
                            filename = this.getSubstringField(substring);
                            newMap.put("filename", filename);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine filename from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "chance": {
                        try {
                            chance = Double.parseDouble(this.getSubstringField(substring));
                            newMap.put("chance", chance);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine chance from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "location": {
                        try {
                            String locationString = this.getSubstringField(substring);
                            newMap.put("location", locationString);
                            location = new Vector(Double.parseDouble(locationString.split(",")[0]), Double.parseDouble(locationString.split(",")[1]), Double.parseDouble(locationString.split(",")[2]));
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine location from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "lightningrod": {
                        try {
                            lightningRod = Boolean.parseBoolean(this.getSubstringField(substring));
                            newMap.put("lightningRod", lightningRod);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine lightningRod from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "inheritaggro": {
                        try {
                            inheritAggro = Boolean.parseBoolean(this.getSubstringField(substring));
                            newMap.put("inheritAggro", inheritAggro);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine inheritAggro from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "amount": {
                        try {
                            amount = Integer.parseInt(this.getSubstringField(substring));
                            newMap.put("amount", amount);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine inheritAggro from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "inheritlevel": {
                        try {
                            inheritLevel = Boolean.parseBoolean(this.getSubstringField(substring));
                            newMap.put("inheritLevel", inheritLevel);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine inheritLevel from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "spawnnearby": {
                        try {
                            spawnNearby = Boolean.parseBoolean(this.getSubstringField(substring));
                            newMap.put("spawnNearby", spawnNearby);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to determine spawnNearby from " + this.getSubstringField(substring)));
                        }
                        continue block52;
                    }
                    case "customspawn": {
                        if (CustomSpawnConfig.getCustomEvent(this.getSubstringField(substring)) == null) {
                            Logger.warn((String)("Failed to determine Custom Spawn file for filename " + substring));
                            continue block52;
                        }
                        customSpawn = this.getSubstringField(substring);
                        newMap.put("customSpawn", customSpawn);
                        continue block52;
                    }
                    default: {
                        Logger.warn((String)("Invalid boss reinforcement string for line " + powerString + " !"));
                        Logger.warn((String)("Problematic entry: " + substring));
                    }
                }
            }
            this.replaceOldFormat(powerString, newMap);
            if (summonType == null) {
                Logger.warn((String)("No summon type detected in " + powerString + " ! This reinforcement will not work."));
                return;
            }
            switch (2.$SwitchMap$com$magmaguy$elitemobs$powers$meta$CustomSummonPower$SummonType[summonType.ordinal()]) {
                case 1: {
                    customBossReinforcement = this.doOnce(filename);
                    break;
                }
                case 2: {
                    customBossReinforcement = this.doOnHit(filename, chance);
                    break;
                }
                case 3: {
                    customBossReinforcement = this.doOnDeath(filename);
                    break;
                }
                case 4: {
                    customBossReinforcement = this.doOnCombatEnter(filename);
                    break;
                }
                case 5: {
                    customBossReinforcement = this.doOnCombatEnterPlaceCrystal(location, lightningRod);
                    break;
                }
                case 6: {
                    customBossReinforcement = this.doGlobalSummonReinforcement(filename);
                    break;
                }
                default: {
                    customBossReinforcement = null;
                    Logger.warn((String)("Failed to determine summon type for reinforcement " + powerString + " ! Contact the developer with this error!"));
                }
            }
            if (customBossReinforcement == null) {
                return;
            }
            customBossReinforcement.inheritAggro = inheritAggro;
            customBossReinforcement.amount = amount;
            customBossReinforcement.inheritLevel = inheritLevel;
            customBossReinforcement.spawnNearby = spawnNearby;
            customBossReinforcement.customSpawn = customSpawn;
            customBossReinforcement.summonChance = chance;
            customBossReinforcement.setSpawnLocationOffset(location);
            if (customBossReinforcement == null || customBossReinforcement.bossFileName == null || CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName) == null) {
                Logger.warn((String)("Could not get filename for reinforcement in file " + configFilename));
            }
        }
    }

    private void replaceOldFormat(String entry, Map<String, Object> replacement) {
        Iterator<Object> iterator = this.customBossesConfigFields.getPowers().iterator();
        while (iterator.hasNext()) {
            Object power = iterator.next();
            if (!power.equals(entry)) continue;
            iterator.remove();
            break;
        }
        this.customBossesConfigFields.getPowers().add(replacement);
        this.customBossesConfigFields.getFileConfiguration().set("powers", this.customBossesConfigFields.getPowers());
        this.customBossesConfigFields.saveFile();
    }

    private String getSubstringField(String string) {
        if (string.split("=").length < 2) {
            return "";
        }
        return string.split("=")[1];
    }

    private void parseOnce(String powerString) {
        String[] strings = powerString.split(":");
        this.doOnce(strings[2]);
    }

    private CustomBossReinforcement doOnce(String filename) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.ONCE, filename);
        if (CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName) == null) {
            Logger.warn((String)("Reinforcement mob " + customBossReinforcement.bossFileName + " is not valid! Filename: " + filename));
            return null;
        }
        this.customBossReinforcements.add(customBossReinforcement);
        return customBossReinforcement;
    }

    private void parseOnHit(String powerString) {
        String[] strings = powerString.split(":");
        this.doOnHit(strings[3], Double.parseDouble(strings[2]));
    }

    private CustomBossReinforcement doOnHit(String filename, double chance) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.ON_HIT, filename);
        customBossReinforcement.setSummonChance(chance);
        if (CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName) == null) {
            Logger.warn((String)("Reinforcement mob " + customBossReinforcement.bossFileName + " is not valid! Filename: " + filename));
            return customBossReinforcement;
        }
        this.customBossReinforcements.add(customBossReinforcement);
        return customBossReinforcement;
    }

    private CustomBossReinforcement doOnDeath(String filename) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.ON_DEATH, filename);
        if (CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName) == null) {
            Logger.warn((String)("Reinforcement mob " + customBossReinforcement.bossFileName + " is not valid! Filename: " + filename));
            return null;
        }
        this.customBossReinforcements.add(customBossReinforcement);
        return customBossReinforcement;
    }

    private void parseOnCombatEnter(String powerString) {
        String[] strings = powerString.split(":");
        this.doOnCombatEnter(strings[3], new Vector(Double.parseDouble(strings[2].split(",")[0]), Double.parseDouble(strings[2].split(",")[1]), Double.parseDouble(strings[2].split(",")[2])));
    }

    private CustomBossReinforcement doOnCombatEnter(String filename, Vector vector) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.ON_COMBAT_ENTER, filename);
        customBossReinforcement.setSpawnLocationOffset(vector);
        return this.doOnCombatEnter(filename);
    }

    private CustomBossReinforcement doOnCombatEnter(String filename) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.ON_COMBAT_ENTER, filename);
        if (CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName) == null) {
            Logger.warn((String)("Reinforcement mob " + customBossReinforcement.bossFileName + " is not valid! Filename: " + filename));
            return customBossReinforcement;
        }
        this.customBossReinforcements.add(customBossReinforcement);
        return customBossReinforcement;
    }

    private void parseOnCombatEnterPlaceCrystal(String powerString) {
        String[] strings = powerString.split(":");
        this.doOnCombatEnterPlaceCrystal(new Vector(Double.parseDouble(strings[2].split(",")[0]), Double.parseDouble(strings[2].split(",")[1]), Double.parseDouble(strings[2].split(",")[2])), Boolean.parseBoolean(strings[3]));
    }

    private CustomBossReinforcement doOnCombatEnterPlaceCrystal(Vector location, boolean lightningRod) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.ON_COMBAT_ENTER, EntityType.END_CRYSTAL, lightningRod);
        customBossReinforcement.setSpawnLocationOffset(location);
        this.customBossReinforcements.add(customBossReinforcement);
        return customBossReinforcement;
    }

    private CustomBossReinforcement doGlobalSummonReinforcement(String filename) {
        CustomBossReinforcement customBossReinforcement = new CustomBossReinforcement(SummonType.GLOBAL, filename);
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName);
        if (customBossesConfigFields == null) {
            Logger.warn((String)("Reinforcement mob " + customBossReinforcement.bossFileName + " is not valid! Filename: " + filename));
            return null;
        }
        customBossReinforcement.entityType = customBossesConfigFields.getEntityType();
        this.customBossReinforcements.add(customBossReinforcement);
        return customBossReinforcement;
    }

    private void onHitSummonReinforcement(EliteEntity spawningEntity) {
        for (CustomBossReinforcement customBossReinforcement : this.customBossReinforcements) {
            if (customBossReinforcement.summonType.equals((Object)SummonType.ONCE) && !customBossReinforcement.isSummoned) {
                this.summonReinforcement(spawningEntity, customBossReinforcement);
            }
            if (!customBossReinforcement.summonType.equals((Object)SummonType.ON_HIT)) continue;
            this.summonReinforcement(spawningEntity, customBossReinforcement);
        }
    }

    private void onCombatEnterSummonReinforcement(EliteEntity spawningEntity) {
        for (CustomBossReinforcement customBossReinforcement : this.customBossReinforcements) {
            if (!customBossReinforcement.summonType.equals((Object)SummonType.ON_COMBAT_ENTER)) continue;
            if (customBossReinforcement.bossFileName != null) {
                this.summonReinforcement(spawningEntity, customBossReinforcement);
                continue;
            }
            Location spawnLocation = this.getFinalSpawnLocation(spawningEntity, customBossReinforcement.spawnLocationOffset);
            Entity entity = spawnLocation.getWorld().spawnEntity(spawnLocation, customBossReinforcement.entityType);
            entity.getPersistentDataContainer().set(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "eliteCrystal"), PersistentDataType.STRING, (Object)"eliteCrystal");
            entity.setPersistent(false);
            CrashFix.persistentTracker(entity);
            if (entity instanceof Mob && !spawningEntity.getDamagers().isEmpty()) {
                Player target = null;
                double damageDealt = 0.0;
                for (Player player : spawningEntity.getDamagers().keySet()) {
                    if (spawningEntity.getDamagers().get(player) < damageDealt) continue;
                    target = player;
                    damageDealt = spawningEntity.getDamagers().get(player);
                }
                if (target != null) {
                    ((Mob)entity).setTarget(target);
                }
            }
            if (customBossReinforcement.isLightningRod) {
                new EnderCrystalLightningRod(spawningEntity, (EnderCrystal)entity);
            }
            customBossReinforcement.isSummoned = true;
            spawningEntity.addReinforcement(entity);
        }
    }

    private void onDeathSummonReinforcement(EliteEntity spawningEntity) {
        for (CustomBossReinforcement customBossReinforcement : this.customBossReinforcements) {
            if (!customBossReinforcement.summonType.equals((Object)SummonType.ON_DEATH)) continue;
            this.summonReinforcement(spawningEntity, customBossReinforcement);
        }
    }

    private void summonReinforcement(EliteEntity eliteEntity, CustomBossReinforcement customBossReinforcement) {
        if (customBossReinforcement.summonChance != null && ThreadLocalRandom.current().nextDouble() > customBossReinforcement.summonChance) {
            return;
        }
        for (int i = 0; i < customBossReinforcement.amount; ++i) {
            CustomBossEntity summoner;
            Location spawnLocation = eliteEntity.getLocation();
            if (customBossReinforcement.spawnLocationOffset != null) {
                spawnLocation = this.getFinalSpawnLocation(eliteEntity, customBossReinforcement.spawnLocationOffset);
            }
            if (customBossReinforcement.spawnNearby) {
                for (int loc = 0; loc < 30; ++loc) {
                    Location randomLocation = spawnLocation.clone().add(new Vector(ThreadLocalRandom.current().nextInt(-15, 15), 0, ThreadLocalRandom.current().nextInt(-15, 15)));
                    randomLocation.setY((double)CustomSpawn.getHighestValidBlock(randomLocation, 256));
                    if (randomLocation.getY() == -100.0) continue;
                    spawnLocation = randomLocation;
                    break;
                }
            }
            if (CustomBossesConfig.getCustomBoss(customBossReinforcement.bossFileName).isRegionalBoss()) {
                RegionalBossEntity regionalBossEntity = RegionalBossEntity.createTemporaryRegionalBossEntity(customBossReinforcement.bossFileName, spawnLocation);
                if (regionalBossEntity == null) {
                    Logger.warn((String)("Failed to spawn reinforcement for " + eliteEntity.getName() + " because boss " + customBossReinforcement.bossFileName + " was invalid! Does the file exist? Is it configured correctly?"));
                    return;
                }
                if (eliteEntity instanceof CustomBossEntity && (summoner = (CustomBossEntity)eliteEntity).isNormalizedCombat()) {
                    regionalBossEntity.setNormalizedCombat();
                }
                if (customBossReinforcement.inheritLevel) {
                    regionalBossEntity.setLevel(eliteEntity.getLevel());
                }
                if (!customBossReinforcement.summonType.equals((Object)SummonType.ON_DEATH)) {
                    eliteEntity.addReinforcement(regionalBossEntity);
                }
                customBossReinforcement.isSummoned = true;
                regionalBossEntity.setSummoningEntity(eliteEntity);
                regionalBossEntity.initialize();
                continue;
            }
            CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity(customBossReinforcement.bossFileName);
            if (customBossEntity == null) {
                Logger.warn((String)("Failed to spawn reinforcement for " + eliteEntity.getName() + " because boss " + customBossReinforcement.bossFileName + " was invalid! Does the file exist? Is it configured correctly?"));
                return;
            }
            if (eliteEntity instanceof CustomBossEntity && (summoner = (CustomBossEntity)eliteEntity).isNormalizedCombat()) {
                customBossEntity.setNormalizedCombat();
            }
            customBossEntity.setSpawnLocation(spawnLocation);
            customBossEntity.setBypassesProtections(eliteEntity.getBypassesProtections());
            if (customBossReinforcement.inheritLevel) {
                customBossEntity.setLevel(eliteEntity.getLevel());
            }
            customBossEntity.spawn(false);
            if (customBossEntity.getLivingEntity() != null) {
                customBossEntity.getLivingEntity().setVelocity(new Vector(ThreadLocalRandom.current().nextDouble(0.2), 0.2, ThreadLocalRandom.current().nextDouble(0.2)));
            }
            if (!customBossReinforcement.summonType.equals((Object)SummonType.ON_DEATH)) {
                eliteEntity.addReinforcement(customBossEntity);
            }
            customBossReinforcement.isSummoned = true;
            customBossEntity.setSummoningEntity(eliteEntity);
        }
    }

    private Location getFinalSpawnLocation(EliteEntity summoningEntity, Vector spawnLocationOffset) {
        Location finalSpawnLocation = summoningEntity instanceof RegionalBossEntity ? summoningEntity.getSpawnLocation().add(spawnLocationOffset) : (summoningEntity == null ? null : summoningEntity.getLocation().add(spawnLocationOffset));
        return finalSpawnLocation;
    }

    public class CustomBossReinforcement {
        public final SummonType summonType;
        public Double summonChance;
        public String bossFileName = null;
        public Vector spawnLocationOffset;
        public EntityType entityType;
        public boolean isLightningRod;
        public boolean inheritAggro = false;
        public int amount = 1;
        public boolean inheritLevel = false;
        public boolean spawnNearby = false;
        public String customSpawn;
        private boolean isSummoned = false;

        public CustomBossReinforcement(SummonType summonType, String bossFileName) {
            this.summonType = summonType;
            this.bossFileName = bossFileName;
        }

        public CustomBossReinforcement(SummonType summonType, EntityType entityType, boolean isLightningRod) {
            this.summonType = summonType;
            this.entityType = entityType;
            this.isLightningRod = isLightningRod;
        }

        public void setSummonChance(double summonChance) {
            this.summonChance = summonChance;
        }

        public void setSpawnLocationOffset(Vector vector) {
            this.spawnLocationOffset = vector;
        }
    }

    public static enum SummonType {
        ONCE,
        ON_HIT,
        ON_COMBAT_ENTER,
        ON_DEATH,
        ON_COMBAT_ENTER_PLACE_CRYSTAL,
        GLOBAL;

    }

    public static class CustomSummonPowerEvent
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onHit(EliteMobDamagedByPlayerEvent event) {
            CustomSummonPower customSummonPower = (CustomSummonPower)event.getEliteMobEntity().getPower("custom_summon.yml");
            if (customSummonPower == null) {
                return;
            }
            if (!ElitePower.eventIsValid(event, customSummonPower, true)) {
                return;
            }
            if (event.getDamage() < 3.0) {
                return;
            }
            customSummonPower.onHitSummonReinforcement(event.getEliteMobEntity());
        }

        @EventHandler(ignoreCancelled=true)
        public void onCombatEnter(EliteMobEnterCombatEvent event) {
            CustomSummonPower customSummonPower = (CustomSummonPower)event.getEliteMobEntity().getPower("custom_summon.yml");
            if (customSummonPower == null) {
                return;
            }
            customSummonPower.onCombatEnterSummonReinforcement(event.getEliteMobEntity());
        }

        @EventHandler
        public void onDeath(EliteMobDeathEvent event) {
            CustomSummonPower customSummonPower = (CustomSummonPower)event.getEliteEntity().getPower("custom_summon.yml");
            if (customSummonPower == null) {
                return;
            }
            customSummonPower.onDeathSummonReinforcement(event.getEliteEntity());
        }
    }
}

