/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.collateralminecraftchanges.LightningSpawnBypass;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Thunderstorm
extends BossPower
implements Listener {
    public Thunderstorm() {
        super(PowersConfig.getPower("thunderstorm.yml"));
    }

    public static void doThunderstorm(final EliteEntity eliteEntity) {
        if (eliteEntity == null || !eliteEntity.getLivingEntity().isValid()) {
            return;
        }
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > 100 || eliteEntity.getLivingEntity() == null || !eliteEntity.getLivingEntity().isValid()) {
                    this.cancel();
                    if (eliteEntity.getLivingEntity() != null) {
                        eliteEntity.getLivingEntity().setAI(true);
                    }
                    return;
                }
                if (this.counter % 2 == 0) {
                    Location randomLocation = eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(ThreadLocalRandom.current().nextInt(-20, 20), 0, ThreadLocalRandom.current().nextInt(-20, 20)));
                    Thunderstorm.lightningTask(randomLocation);
                }
                if (this.counter % 20 == 0) {
                    for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
                        if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
                        Thunderstorm.lightningTask(entity.getLocation());
                    }
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    public static void lightningTask(final Location location) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > 60) {
                    LightningSpawnBypass.bypass();
                    location.getWorld().strikeLightning(location);
                    this.cancel();
                    return;
                }
                location.getWorld().spawnParticle(Particle.CRIT, location, 10, 0.5, 1.5, 0.5, 0.3);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    @EventHandler
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        Thunderstorm thunderstorm = (Thunderstorm)event.getEliteMobEntity().getPower(this);
        if (thunderstorm == null) {
            return;
        }
        if (!Thunderstorm.eventIsValid(event, (ElitePower)thunderstorm)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        thunderstorm.doGlobalCooldown(400, event.getEliteMobEntity());
        Thunderstorm.doThunderstorm(event.getEliteMobEntity());
    }
}

