/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.combatsystem.antiexploit.PreventMountExploit;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SpiritWalk
extends BossPower
implements Listener {
    private int hitCounter = 0;

    public SpiritWalk() {
        super(PowersConfig.getPower("spirit_walk.yml"));
    }

    public static void spiritWalkAnimation(final EliteEntity eliteEntity, Location entityLocation, final Location finalLocation) {
        eliteEntity.getLivingEntity().setAI(false);
        eliteEntity.getLivingEntity().setInvulnerable(true);
        eliteEntity.getLivingEntity().addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 200, 1));
        final Vector toDestination = finalLocation.clone().subtract(entityLocation.clone()).toVector().normalize().divide(new Vector(2, 2, 2));
        eliteEntity.setCombatGracePeriod(400);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (eliteEntity.getLivingEntity().getLocation().clone().distance(finalLocation) < 2.0 || this.counter > 200) {
                    eliteEntity.getLivingEntity().teleport(finalLocation);
                    eliteEntity.getLivingEntity().setAI(true);
                    eliteEntity.getLivingEntity().setInvulnerable(false);
                    eliteEntity.getLivingEntity().removePotionEffect(PotionEffectType.GLOWING);
                    this.cancel();
                }
                eliteEntity.getLivingEntity().teleport(eliteEntity.getLivingEntity().getLocation().clone().add(toDestination.clone()));
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    public static void spiritWalkRegionalBossAnimation(final EliteEntity eliteEntity, Location entityLocation, final Location finalLocation) {
        Bukkit.getScheduler().runTask((Plugin)MetadataHandler.PLUGIN, bukkitTask -> {
            if (eliteEntity.getLivingEntity() == null) {
                return;
            }
            eliteEntity.getLivingEntity().setAI(false);
            eliteEntity.getLivingEntity().setInvulnerable(true);
            final Vector toDestination = finalLocation.clone().subtract(entityLocation.clone()).toVector().normalize().divide(new Vector(2, 2, 2));
            Entity vehicle = null;
            if (eliteEntity.getLivingEntity().isInsideVehicle()) {
                vehicle = eliteEntity.getLivingEntity().getVehicle();
                if (vehicle instanceof LivingEntity) {
                    ((LivingEntity)vehicle).setAI(false);
                }
                vehicle.setInvulnerable(true);
                if (((CustomBossEntity)eliteEntity).getPhaseBossEntity() != null) {
                    vehicle.remove();
                }
            }
            new BukkitRunnable(){
                final Entity vehicle;
                int counter;
                {
                    this.vehicle = eliteEntity.getLivingEntity().getVehicle();
                    this.counter = 0;
                }

                public void run() {
                    if (!eliteEntity.isValid()) {
                        this.cancel();
                        return;
                    }
                    if (eliteEntity.getLivingEntity().isInsideVehicle()) {
                        eliteEntity.getLivingEntity().leaveVehicle();
                    }
                    if (eliteEntity.getLivingEntity().getLocation().clone().distance(finalLocation) < 2.0 || this.counter > 200) {
                        eliteEntity.getLivingEntity().setAI(true);
                        eliteEntity.getLivingEntity().setInvulnerable(false);
                        if (this.vehicle != null && !this.vehicle.isDead()) {
                            this.vehicle.teleport(finalLocation);
                        }
                        eliteEntity.getLivingEntity().teleport(finalLocation);
                        if (this.vehicle != null && !this.vehicle.isDead()) {
                            if (this.vehicle instanceof LivingEntity) {
                                ((LivingEntity)this.vehicle).setAI(true);
                                EliteEntity vehicleBoss = EntityTracker.getEliteMobEntity(this.vehicle);
                                if (vehicleBoss != null) {
                                    Bukkit.getServer().getPluginManager().callEvent((Event)new EliteMobExitCombatEvent(vehicleBoss, EliteMobExitCombatEvent.EliteMobExitCombatReason.SPIRIT_WALK));
                                }
                            }
                            this.vehicle.setInvulnerable(false);
                            new BukkitRunnable(){

                                public void run() {
                                    PreventMountExploit.bypass = true;
                                    vehicle.addPassenger((Entity)eliteEntity.getLivingEntity());
                                }
                            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                        }
                        this.cancel();
                        Bukkit.getServer().getPluginManager().callEvent((Event)new EliteMobExitCombatEvent(eliteEntity, EliteMobExitCombatEvent.EliteMobExitCombatReason.SPIRIT_WALK));
                        if (eliteEntity.getLivingEntity() instanceof Mob && ((Mob)eliteEntity.getLivingEntity()).getTarget() == null && eliteEntity instanceof RegionalBossEntity) {
                            RegionalBossEntity regionalBossEntity = (RegionalBossEntity)eliteEntity;
                            CustomBossEntity.CustomBossEntityEvents.slowRegionalBoss(regionalBossEntity);
                        }
                    }
                    if (this.vehicle != null && !this.vehicle.isDead()) {
                        this.vehicle.teleport(eliteEntity.getLivingEntity().getLocation().clone().add(toDestination.clone()));
                    }
                    eliteEntity.getLivingEntity().teleport(eliteEntity.getLivingEntity().getLocation().clone().add(toDestination.clone()));
                    ++this.counter;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        });
    }

    private void incrementHitCounter() {
        ++this.hitCounter;
    }

    private void resetHitsCounter() {
        this.hitCounter = 0;
    }

    private int getHitsCounter() {
        return this.hitCounter;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBossMobGotHit(EliteMobDamagedEvent event) {
        SpiritWalk spiritWalk = (SpiritWalk)event.getEliteEntity().getPower(this);
        if (spiritWalk == null) {
            return;
        }
        switch (event.getEntityDamageEvent().getCause()) {
            case FIRE: 
            case FIRE_TICK: 
            case POISON: 
            case WITHER: 
            case THORNS: 
            case ENTITY_SWEEP_ATTACK: {
                return;
            }
        }
        if (event.getEntityDamageEvent().getCause().equals((Object)EntityDamageEvent.DamageCause.DROWNING) || event.getEntityDamageEvent().getCause().equals((Object)EntityDamageEvent.DamageCause.SUFFOCATION)) {
            this.initializeSpiritWalk(event.getEliteEntity());
        }
        spiritWalk.incrementHitCounter();
        if (spiritWalk.getHitsCounter() < 9) {
            return;
        }
        spiritWalk.resetHitsCounter();
        this.initializeSpiritWalk(event.getEliteEntity());
    }

    public void initializeSpiritWalk(final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 1;

            public void run() {
                if (this.counter > 3 || !eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                Location bossLocation = eliteEntity.getLocation().clone();
                for (int i = 0; i < 20; ++i) {
                    double randomizedZ;
                    double randomizedY;
                    double randomizedX = (ThreadLocalRandom.current().nextDouble() - 0.5) * 5.0;
                    Vector normalizedVector = new Vector(randomizedX, randomizedY = ThreadLocalRandom.current().nextDouble() * 5.0, randomizedZ = (ThreadLocalRandom.current().nextDouble() - 0.5) * 5.0).normalize().multiply(7).multiply(this.counter);
                    Location newSimulatedLocation = bossLocation.add(normalizedVector).clone();
                    Location newValidLocation = SpiritWalk.this.scanVertically(newSimulatedLocation);
                    if (newValidLocation == null) continue;
                    SpiritWalk.spiritWalkAnimation(eliteEntity, eliteEntity.getLivingEntity().getLocation(), newValidLocation.add(new Vector(0.5, 1.0, 0.5)));
                    this.cancel();
                    break;
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private Location scanVertically(Location simulatedLocation) {
        int counter = 0;
        do {
            Location newLocation;
            if (!this.locationValid(newLocation = simulatedLocation.clone().subtract(new Vector(0, counter, 0)))) continue;
            return newLocation;
        } while (++counter <= 8);
        return null;
    }

    private boolean locationValid(Location feetLocation) {
        Location groundLocation = feetLocation.clone().add(new Vector(0, -1, 0));
        Location headLocation = feetLocation.clone().add(new Vector(0, 1, 0));
        return this.isNonVoidAir(feetLocation.getBlock().getType()) && this.isNonVoidAir(headLocation.getBlock().getType()) && groundLocation.getBlock().getType().isSolid();
    }

    private boolean isNonVoidAir(Material material) {
        return material.equals((Object)Material.AIR) || material.equals((Object)Material.CAVE_AIR);
    }
}

