/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobEnterCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.collateralminecraftchanges.LightningSpawnBypass;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EnderDragonEmpoweredLightning
extends MajorPower {
    private boolean isActive = false;
    private BukkitTask bukkitTask = null;

    public EnderDragonEmpoweredLightning() {
        super(PowersConfig.getPower("ender_dragon_empowered_lightning.yml"));
    }

    public static void lightningTask(final Location location) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > 60) {
                    LightningSpawnBypass.bypass();
                    location.getWorld().strikeLightning(location);
                    Fireball fireball = (Fireball)location.getWorld().spawnEntity(location, EntityType.FIREBALL);
                    EntityTracker.registerProjectileEntity((Projectile)fireball);
                    fireball.setDirection(new Vector(0, -3, 0));
                    fireball.setVelocity(new Vector(0, -3, 0));
                    fireball.setYield(5.0f);
                    EliteProjectile.signExplosiveWithPower((Projectile)fireball, "ender_dragon_empowered_lightning.yml");
                    this.cancel();
                    return;
                }
                location.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, location, 10, 0.5, 1.5, 0.5, 0.3);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void activate(final EliteEntity eliteEntity) {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (EnderDragonEmpoweredLightning.this.isInCooldown(eliteEntity)) {
                    return;
                }
                EnderDragonEmpoweredLightning.this.fireLightning(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
    }

    private void deactivate() {
        this.isActive = false;
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
        }
    }

    public void fireLightning(EliteEntity eliteEntity) {
        this.doCooldown(eliteEntity);
        for (Entity entity : eliteEntity.getLivingEntity().getLocation().getWorld().getNearbyEntities(eliteEntity.getLivingEntity().getLocation(), 150.0, 150.0, 150.0)) {
            if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
            EnderDragonEmpoweredLightning.lightningTask(entity.getLocation().clone());
        }
        for (int i = 0; i < 50; ++i) {
            final Location randomLocation = this.locationRandomizer(eliteEntity.getLivingEntity().getLocation(), 0);
            if (randomLocation == null) continue;
            new BukkitRunnable(){

                public void run() {
                    EnderDragonEmpoweredLightning.lightningTask(randomLocation);
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)ThreadLocalRandom.current().nextInt(100));
        }
    }

    private Location locationRandomizer(Location location, int counter) {
        if (counter > 5) {
            return null;
        }
        Location randomLocation = location.clone().add(new Vector(ThreadLocalRandom.current().nextInt(-150, 150), 0, ThreadLocalRandom.current().nextInt(-150, 150)));
        randomLocation.setY((double)randomLocation.getWorld().getHighestBlockAt(randomLocation).getY());
        if (randomLocation.getY() == -1.0) {
            this.locationRandomizer(location, counter + 1);
        }
        return randomLocation;
    }

    public static class EnderDragonEmpoweredLightningEvents
    implements Listener {
        @EventHandler
        public void onCombatEnter(EliteMobEnterCombatEvent event) {
            EnderDragonEmpoweredLightning empoweredLightning = (EnderDragonEmpoweredLightning)event.getEliteMobEntity().getPower("ender_dragon_empowered_lightning.yml");
            if (empoweredLightning == null) {
                return;
            }
            empoweredLightning.activate(event.getEliteMobEntity());
        }

        @EventHandler
        public void onCombatLeave(EliteMobExitCombatEvent event) {
            EnderDragonEmpoweredLightning empoweredLightning = (EnderDragonEmpoweredLightning)event.getEliteMobEntity().getPower("ender_dragon_empowered_lightning.yml");
            if (empoweredLightning == null) {
                return;
            }
            empoweredLightning.deactivate();
        }
    }
}

