/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobTargetPlayerEvent;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.powers.meta.MinorPower;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class AttackFireball
extends MinorPower
implements Listener {
    public AttackFireball() {
        super(PowersConfig.getPower("attack_fireball.yml"));
    }

    public static Fireball shootFireball(Entity entity, Player player) {
        Location entityLoc = entity.getLocation();
        Location playerLoc = player.getLocation();
        if (entityLoc == null || playerLoc == null) {
            return null;
        }
        Vector direction = playerLoc.toVector().subtract(entityLoc.toVector());
        if (direction.lengthSquared() < 1.0E-4) {
            direction = new Vector(0, 1, 0);
        } else {
            direction.normalize();
        }
        direction.multiply(0.01);
        Fireball repeatingFireball = (Fireball)EliteProjectile.create(EntityType.FIREBALL, entity, (Entity)player, direction, true);
        if (repeatingFireball != null) {
            repeatingFireball.setYield(3.0f);
            repeatingFireball.setIsIncendiary(true);
            repeatingFireball.setShooter((ProjectileSource)entity);
        }
        return repeatingFireball;
    }

    @EventHandler
    public void targetEvent(EliteMobTargetPlayerEvent event) {
        if (!(event.getEliteMobEntity().getLivingEntity() instanceof Monster)) {
            return;
        }
        AttackFireball attackFireball = (AttackFireball)event.getEliteMobEntity().getPower(this);
        if (attackFireball == null) {
            return;
        }
        if (attackFireball.isFiring()) {
            return;
        }
        attackFireball.setFiring(true);
        this.repeatingFireballTask((Monster)event.getEntity(), attackFireball);
    }

    private void repeatingFireballTask(final Monster monster, final AttackFireball attackFireball) {
        new BukkitRunnable(){

            public void run() {
                if (!monster.isValid() || monster.getTarget() == null) {
                    attackFireball.setFiring(false);
                    this.cancel();
                    return;
                }
                for (Entity nearbyEntity : monster.getNearbyEntities(20.0, 20.0, 20.0)) {
                    Fireball fireball;
                    Player targetPlayer;
                    if (!(nearbyEntity instanceof Player) || !(targetPlayer = (Player)nearbyEntity).getGameMode().equals((Object)GameMode.ADVENTURE) && !targetPlayer.getGameMode().equals((Object)GameMode.SURVIVAL) || (fireball = AttackFireball.shootFireball((Entity)monster, targetPlayer)) != null) continue;
                    MetadataHandler.PLUGIN.getLogger().warning("Failed to create fireball for entity at " + String.valueOf(monster.getLocation()));
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 160L);
    }
}

