/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobTargetPlayerEvent;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.MinorPower;
import org.bukkit.GameMode;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AttackArrow
extends MinorPower
implements Listener {
    public AttackArrow() {
        super(PowersConfig.getPower("attack_arrow.yml"));
    }

    public static Arrow shootArrow(Entity entity, Player player) {
        return (Arrow)EliteProjectile.create(EntityType.ARROW, entity, player, true);
    }

    @EventHandler
    public void targetEvent(EliteMobTargetPlayerEvent event) {
        if (!(event.getEliteMobEntity().getLivingEntity() instanceof Monster)) {
            return;
        }
        AttackArrow attackArrow = (AttackArrow)event.getEliteMobEntity().getPower(this);
        if (attackArrow == null) {
            return;
        }
        if (attackArrow.isFiring()) {
            return;
        }
        attackArrow.setFiring(true);
        this.repeatingArrowTask(attackArrow, event.getEliteMobEntity());
    }

    private void repeatingArrowTask(final AttackArrow attackArrow, final EliteEntity eliteEntity) {
        new BukkitRunnable(){

            public void run() {
                if (!eliteEntity.isValid() || ((Monster)eliteEntity.getLivingEntity()).getTarget() == null) {
                    attackArrow.setFiring(false);
                    this.cancel();
                    return;
                }
                for (Entity nearbyEntity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
                    Player player;
                    if (!(nearbyEntity instanceof Player) || (player = (Player)nearbyEntity).isDead() || !player.getGameMode().equals((Object)GameMode.ADVENTURE) && !player.getGameMode().equals((Object)GameMode.SURVIVAL)) continue;
                    AttackArrow.shootArrow((Entity)eliteEntity.getLivingEntity(), (Player)nearbyEntity);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 160L);
    }
}

