/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.MeteorShower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.meta.MinorPower;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ArrowRain
extends MinorPower
implements Listener {
    public ArrowRain() {
        super(PowersConfig.getPower("arrow_rain.yml"));
    }

    public static void doArrowRain(final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            final Location initialLocation;
            int counter;
            {
                this.initialLocation = eliteEntity.getLivingEntity().getLocation().clone();
                this.counter = 0;
            }

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (this.counter > 200) {
                    this.cancel();
                    eliteEntity.getLivingEntity().teleport(this.initialLocation);
                    return;
                }
                ++this.counter;
                MeteorShower.doCloudEffect(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)));
                if (this.counter > 20) {
                    ArrowRain.doArrows(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)), eliteEntity);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void doArrows(Location location, EliteEntity eliteEntity) {
        for (int i = 0; i < 1; ++i) {
            int randX = ThreadLocalRandom.current().nextInt(30) - 15;
            int randY = ThreadLocalRandom.current().nextInt(2);
            int randZ = ThreadLocalRandom.current().nextInt(30) - 15;
            Location newLocation = location.clone().add(new Vector(randX, randY, randZ));
            newLocation = newLocation.setDirection(new Vector(ThreadLocalRandom.current().nextDouble() - 0.5, -0.5, ThreadLocalRandom.current().nextDouble() - 0.5));
            Arrow arrow = (Arrow)Objects.requireNonNull(location.getWorld()).spawnEntity(newLocation, EntityType.ARROW);
            arrow.setShooter((ProjectileSource)eliteEntity.getLivingEntity());
        }
    }

    @EventHandler
    public void onEliteDamaged(EliteMobDamagedByPlayerEvent event) {
        ArrowRain arrowRain = (ArrowRain)event.getEliteMobEntity().getPower(this);
        if (arrowRain == null) {
            return;
        }
        if (!ArrowRain.eventIsValid(event, (ElitePower)arrowRain)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.15) {
            return;
        }
        arrowRain.doGlobalCooldown(300, event.getEliteMobEntity());
        ArrowRain.doArrowRain(event.getEliteMobEntity());
    }
}

