/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.statusscreen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.AdventurersGuildConfig;
import com.magmaguy.elitemobs.config.menus.premade.PlayerStatusMenuConfig;
import com.magmaguy.elitemobs.dungeons.CombatContent;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.magmacore.dialog.DialogManager;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashSet;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerStatusScreenDialog {
    private static final int DIALOG_WIDTH = 300;

    private PlayerStatusScreenDialog() {
    }

    public static void showPlayerStatusDialog(Player player) {
        DialogManager.DialogListDialogBuilder listBuilder = new DialogManager.DialogListDialogBuilder();
        listBuilder.title("Player Status Menu");
        if (PlayerStatusMenuConfig.isDoStatsPage()) {
            listBuilder.addDialog(DialogManager.DialogReference.inline((DialogManager.DialogBuilder)PlayerStatusScreenDialog.buildStatsDialog(player)));
        }
        if (PlayerStatusMenuConfig.isDoGearPage()) {
            listBuilder.addDialog(DialogManager.DialogReference.inline((DialogManager.DialogBuilder)PlayerStatusScreenDialog.buildGearDialog(player)));
        }
        if (PlayerStatusMenuConfig.isDoTeleportsPage()) {
            listBuilder.addDialog(DialogManager.DialogReference.inline((DialogManager.DialogBuilder)PlayerStatusScreenDialog.buildTeleportsDialog(player)));
        }
        if (PlayerStatusMenuConfig.isDoCommandsPage()) {
            listBuilder.addDialog(DialogManager.DialogReference.inline((DialogManager.DialogBuilder)PlayerStatusScreenDialog.buildCommandsDialog(player)));
        }
        if (PlayerStatusMenuConfig.isDoQuestTrackingPage()) {
            listBuilder.addDialog(DialogManager.DialogReference.inline((DialogManager.DialogBuilder)PlayerStatusScreenDialog.buildQuestsDialog(player)));
        }
        if (PlayerStatusMenuConfig.isDoBossTrackingPage()) {
            listBuilder.addDialog(DialogManager.DialogReference.inline((DialogManager.DialogBuilder)PlayerStatusScreenDialog.buildBossTrackingDialog(player)));
        }
        listBuilder.columns(1);
        listBuilder.buttonWidth(300);
        DialogManager.sendDialog((Player)player, (DialogManager.DialogBuilder)listBuilder);
    }

    private static DialogManager.MultiActionDialogBuilder buildStatsDialog(Player player) {
        int i;
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        builder.title("Stats");
        StringBuilder statsText = new StringBuilder();
        for (i = 0; i < 13; ++i) {
            if (PlayerStatusMenuConfig.getStatsTextLines()[i] == null) continue;
            String line = PlayerStatusMenuConfig.getStatsTextLines()[i].replace("$money", "" + EconomyHandler.checkCurrency(player.getUniqueId())).replace("$guildtier", PlayerStatusScreenDialog.processText(AdventurersGuildConfig.getShortenedRankName(GuildRank.getGuildPrestigeRank(player), GuildRank.getActiveGuildRank(player)))).replace("$kills", "" + PlayerData.getKills(player.getUniqueId())).replace("$highestkill", "" + PlayerData.getHighestLevelKilled(player.getUniqueId())).replace("$deaths", "" + PlayerData.getDeaths(player.getUniqueId())).replace("$quests", "" + PlayerData.getQuestsCompleted(player.getUniqueId())).replace("$score", "" + PlayerData.getScore(player.getUniqueId()));
            statsText.append(PlayerStatusScreenDialog.processText(line)).append("\n");
        }
        if (statsText.length() > 0) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)statsText.toString().trim()).width(300));
        }
        for (i = 0; i < 13; ++i) {
            String buttonLabel;
            if (PlayerStatusMenuConfig.getStatsCommandLines() == null || PlayerStatusMenuConfig.getStatsCommandLines()[i] == null || PlayerStatusMenuConfig.getStatsCommandLines()[i].isEmpty() || (buttonLabel = PlayerStatusMenuConfig.getStatsTextLines()[i]) == null || buttonLabel.isEmpty()) continue;
            builder.addAction(DialogManager.ActionButton.of((String)PlayerStatusScreenDialog.processText(buttonLabel), (DialogManager.Action)new DialogManager.RunCommandAction(PlayerStatusMenuConfig.getStatsCommandLines()[i])).width(300));
        }
        PlayerStatusScreenDialog.addBackButton(builder);
        return builder;
    }

    private static DialogManager.MultiActionDialogBuilder buildGearDialog(Player player) {
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        builder.title("Gear");
        StringBuilder gearText = new StringBuilder();
        for (int i = 0; i < 13; ++i) {
            if (PlayerStatusMenuConfig.getGearTextLines()[i] == null) continue;
            String line = PlayerStatusScreenDialog.parseGearPlaceholders(PlayerStatusMenuConfig.getGearTextLines()[i], player);
            gearText.append(PlayerStatusScreenDialog.processText(line)).append("\n");
        }
        if (gearText.length() > 0) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)gearText.toString().trim()).width(300));
        }
        PlayerStatusScreenDialog.addEquippedItems(builder, player);
        PlayerStatusScreenDialog.addBackButton(builder);
        return builder;
    }

    private static DialogManager.MultiActionDialogBuilder buildTeleportsDialog(Player player) {
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        builder.title("Teleports");
        StringBuilder teleportText = new StringBuilder();
        for (String line : PlayerStatusMenuConfig.getTeleportTextLines()) {
            if (line == null || line.equals("null")) continue;
            teleportText.append(PlayerStatusScreenDialog.processText(line)).append("\n");
        }
        if (teleportText.length() > 0) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)teleportText.toString().trim()).width(300));
        }
        for (EMPackage emPackage : EMPackage.getEmPackages().values()) {
            if (!emPackage.isInstalled() || !(emPackage instanceof CombatContent) || emPackage.getContentPackagesConfigFields().isEnchantmentChallenge() || !emPackage.getContentPackagesConfigFields().isListedInTeleports()) continue;
            String dungeonName = PlayerStatusScreenDialog.processText(emPackage.getContentPackagesConfigFields().getName());
            String hoverInfo = ChatColorConverter.convert((String)(PlayerStatusMenuConfig.getOnTeleportHover() + "\n" + emPackage.getContentPackagesConfigFields().getPlayerInfo().replace("$bossCount", "" + emPackage.getCustomBossEntityList().size()).replace("$lowestTier", "" + ((CombatContent)((Object)emPackage)).getLowestLevel()).replace("$highestTier", "" + ((CombatContent)((Object)emPackage)).getHighestLevel())));
            DialogManager.ActionButton button = DialogManager.ActionButton.of((String)dungeonName, (DialogManager.Action)new DialogManager.RunCommandAction("/elitemobs dungeontp " + emPackage.getContentPackagesConfigFields().getFilename())).width(300);
            if (hoverInfo != null && !hoverInfo.isEmpty()) {
                button.tooltip(PlayerStatusScreenDialog.processText(hoverInfo));
            }
            builder.columns(1);
            builder.addAction(button);
        }
        builder.columns(1);
        PlayerStatusScreenDialog.addBackButton(builder);
        return builder;
    }

    private static DialogManager.MultiActionDialogBuilder buildCommandsDialog(Player player) {
        int i;
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        builder.title("Commands");
        StringBuilder commandsText = new StringBuilder();
        for (i = 0; i < 13; ++i) {
            if (PlayerStatusMenuConfig.getCommandsTextLines()[i] == null) continue;
            String line = PlayerStatusMenuConfig.getCommandsTextLines()[i];
            commandsText.append(PlayerStatusScreenDialog.processText(line)).append("\n");
        }
        if (commandsText.length() > 0) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)commandsText.toString().trim()).width(300));
        }
        for (i = 0; i < 13; ++i) {
            String buttonLabel;
            if (PlayerStatusMenuConfig.getCommandsCommandLines()[i] == null || PlayerStatusMenuConfig.getCommandsCommandLines()[i].isEmpty() || (buttonLabel = PlayerStatusMenuConfig.getCommandsTextLines()[i]) == null || buttonLabel.isEmpty()) continue;
            DialogManager.ActionButton button = DialogManager.ActionButton.of((String)PlayerStatusScreenDialog.processText(buttonLabel), (DialogManager.Action)new DialogManager.RunCommandAction(PlayerStatusMenuConfig.getCommandsCommandLines()[i])).width(300);
            if (PlayerStatusMenuConfig.getCommandsHoverLines()[i] != null && !PlayerStatusMenuConfig.getCommandsHoverLines()[i].isEmpty()) {
                button.tooltip(PlayerStatusScreenDialog.processText(PlayerStatusMenuConfig.getCommandsHoverLines()[i]));
            }
            builder.columns(1);
            builder.addAction(button);
        }
        builder.columns(1);
        PlayerStatusScreenDialog.addBackButton(builder);
        return builder;
    }

    private static DialogManager.MultiActionDialogBuilder buildQuestsDialog(Player player) {
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        builder.title("Quests");
        List<Quest> quests = PlayerData.getQuests(player.getUniqueId());
        if (quests == null || quests.isEmpty()) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)"No active quests").width(300));
        } else {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)("You have " + quests.size() + " active quest(s).")).width(300));
            builder.columns(1);
            for (Quest quest : quests) {
                Object questName = quest.getQuestName() != null ? PlayerStatusScreenDialog.processText(quest.getQuestName()) : "Quest " + String.valueOf(quest.getQuestID());
                builder.addAction(DialogManager.ActionButton.of((String)questName, (DialogManager.Action)new DialogManager.RunCommandAction("/elitemobs quest check " + String.valueOf(quest.getQuestID()))).width(300));
            }
        }
        builder.columns(1);
        PlayerStatusScreenDialog.addBackButton(builder);
        return builder;
    }

    private static DialogManager.MultiActionDialogBuilder buildBossTrackingDialog(Player player) {
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        builder.title("Boss Tracking");
        StringBuilder trackingText = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (PlayerStatusMenuConfig.getBossTrackerTextLines()[i] == null) continue;
            trackingText.append(PlayerStatusScreenDialog.processText(PlayerStatusMenuConfig.getBossTrackerTextLines()[i])).append("\n");
        }
        if (trackingText.length() > 0) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)trackingText.toString().trim()).width(300));
        }
        HashSet<CustomBossEntity> tempSet = new HashSet<CustomBossEntity>(CustomBossEntity.getTrackableCustomBosses());
        tempSet.forEach(customBossEntity -> {
            if (!customBossEntity.exists()) {
                CustomBossEntity.getTrackableCustomBosses().remove(customBossEntity);
            }
        });
        for (CustomBossEntity customBossEntity2 : CustomBossEntity.getTrackableCustomBosses()) {
            try {
                String bossName = customBossEntity2.getBossTrackingBar().bossBarMessage(player, customBossEntity2.getCustomBossesConfigFields().getLocationMessage());
                DialogManager.ActionButton button = DialogManager.ActionButton.of((String)PlayerStatusScreenDialog.processText(bossName), (DialogManager.Action)new DialogManager.RunCommandAction("/elitemobs track boss " + String.valueOf(customBossEntity2.getEliteUUID()))).width(300);
                if (PlayerStatusMenuConfig.getOnBossTrackHover() != null && !PlayerStatusMenuConfig.getOnBossTrackHover().isEmpty()) {
                    button.tooltip(PlayerStatusScreenDialog.processText(PlayerStatusMenuConfig.getOnBossTrackHover()));
                }
                builder.addAction(button);
            }
            catch (Exception exception) {}
        }
        PlayerStatusScreenDialog.addBackButton(builder);
        return builder;
    }

    private static void addEquippedItems(DialogManager.MultiActionDialogBuilder builder, Player player) {
        ItemStack offHand;
        ItemStack mainHand;
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet = player.getInventory().getHelmet();
        if (helmet != null && EliteItemManager.isEliteMobsItem(helmet)) {
            PlayerStatusScreenDialog.addItemBody(builder, helmet, "Helmet");
        }
        if ((chestplate = player.getInventory().getChestplate()) != null && EliteItemManager.isEliteMobsItem(chestplate)) {
            PlayerStatusScreenDialog.addItemBody(builder, chestplate, "Chestplate");
        }
        if ((leggings = player.getInventory().getLeggings()) != null && EliteItemManager.isEliteMobsItem(leggings)) {
            PlayerStatusScreenDialog.addItemBody(builder, leggings, "Leggings");
        }
        if ((boots = player.getInventory().getBoots()) != null && EliteItemManager.isEliteMobsItem(boots)) {
            PlayerStatusScreenDialog.addItemBody(builder, boots, "Boots");
        }
        if ((mainHand = player.getInventory().getItemInMainHand()) != null && EliteItemManager.isEliteMobsItem(mainHand)) {
            PlayerStatusScreenDialog.addItemBody(builder, mainHand, "Main Hand");
        }
        if ((offHand = player.getInventory().getItemInOffHand()) != null && EliteItemManager.isEliteMobsItem(offHand)) {
            PlayerStatusScreenDialog.addItemBody(builder, offHand, "Off Hand");
        }
    }

    private static void addItemBody(DialogManager.MultiActionDialogBuilder builder, ItemStack item, String label) {
        String itemId = item.getType().getKey().toString();
        DialogManager.ItemBody itemBody = DialogManager.ItemBody.of((String)itemId, (int)item.getAmount()).showTooltip(true).showDecoration(true).description(label);
        JsonObject components = DialogManager.serializeItemComponents((ItemStack)item);
        if (components != null && !components.entrySet().isEmpty()) {
            PlayerStatusScreenDialog.fixCustomModelDataFormat(components);
            itemBody.components(components);
        }
        builder.addBody((DialogManager.BodyElement)itemBody);
    }

    private static void fixCustomModelDataFormat(JsonObject components) {
        JsonElement element;
        String key = "minecraft:custom_model_data";
        if (components.has(key) && (element = components.get(key)).isJsonPrimitive()) {
            double value = element.getAsDouble();
            JsonObject newFormat = new JsonObject();
            JsonArray floats = new JsonArray();
            floats.add((Number)value);
            newFormat.add("floats", (JsonElement)floats);
            components.add(key, (JsonElement)newFormat);
        }
    }

    private static String parseGearPlaceholders(String string, Player player) {
        ElitePlayerInventory inventory = ElitePlayerInventory.playerInventories.get(player.getUniqueId());
        if (inventory == null) {
            return string;
        }
        return string.replace("$helmettier", "" + inventory.helmet.getTier(player.getInventory().getHelmet(), true)).replace("$chestplatetier", "" + inventory.chestplate.getTier(player.getInventory().getChestplate(), true)).replace("$leggingstier", "" + inventory.leggings.getTier(player.getInventory().getLeggings(), true)).replace("$bootstier", "" + inventory.boots.getTier(player.getInventory().getBoots(), true)).replace("$mainhandtier", "" + inventory.mainhand.getTier(player.getInventory().getItemInMainHand(), true)).replace("$offhandtier", "" + inventory.offhand.getTier(player.getInventory().getItemInOffHand(), true)).replace("$damage", "" + inventory.baseDamage()).replace("$armor", "" + inventory.getEliteDefense(false)).replace("$threat", "" + inventory.getNaturalMobSpawnLevel(true));
    }

    private static void addBackButton(DialogManager.MultiActionDialogBuilder builder) {
        builder.addAction(DialogManager.ActionButton.of((String)"\u2190 Back to Menu", (DialogManager.Action)new DialogManager.RunCommandAction("/elitemobs")).width(300));
    }

    private static String processText(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\u00a70", "\u00a7f").replace("&0", "&f");
    }
}

