/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CriticalStrikesEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.EarthquakeEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.HunterEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.LoudStrikesEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.PlasmaBootsEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.utils.BossBarUtil;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.Plugin;

public class PlayerItem {
    public EquipmentSlot equipmentSlot;
    public Player player;
    public ItemStack itemStack = null;
    public int itemTier = 0;
    public ArrayList<ElitePotionEffect> continuousPotionEffects = new ArrayList();
    public ArrayList<ElitePotionEffect> onHitPotionEffects = new ArrayList();
    public int damageArthropodsLevel = 0;
    public int damageUndeadLevel = 0;
    public int thornsLevel = 0;
    private double plasmaBootsLevel = 0.0;
    private double critChance = 0.0;
    private double hunterChance = 0.0;
    private double lightningChance = 0.0;
    private double earthquakeLevel = 0.0;
    private double eliteDamageReduction = 0.0;
    private double protectionProjectile = 0.0;
    private double eliteDamage = 0.0;
    private double blastProtection = 0.0;
    private double loudStrikesBonus = 0.0;
    private boolean displayingAsBroken = false;

    public PlayerItem(ItemStack itemStack, EquipmentSlot equipmentSlot, Player player) {
        this.equipmentSlot = equipmentSlot;
        this.player = player;
        this.fullUpdate(itemStack);
    }

    private boolean isOnLastDamage(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        if (!ItemTagger.isEliteItem(itemStack)) {
            return false;
        }
        if (!(itemStack.getItemMeta() instanceof Damageable)) {
            return false;
        }
        if (itemStack.getType().getMaxDurability() == 0) {
            return false;
        }
        return ((Damageable)itemStack.getItemMeta()).getDamage() + 1 >= itemStack.getType().getMaxDurability();
    }

    private boolean fullUpdate(ItemStack itemStack) {
        DungeonInstance dungeonInstance;
        MatchInstance matchInstance;
        if (itemStack == null && this.itemStack == null) {
            return false;
        }
        if (itemStack == null) {
            if (this.displayingAsBroken) {
                BossBarUtil.HideBrokenItemBossBar(this.equipmentSlot, this.player);
                this.displayingAsBroken = false;
            }
            return this.fillNullItem();
        }
        if (this.isOnLastDamage(itemStack)) {
            if (!this.displayingAsBroken) {
                BossBarUtil.DisplayBrokenItemBossBar(this.equipmentSlot, this.player, ChatColorConverter.convert((String)ItemSettingsConfig.getNoItemDurabilityMessage().replace("$item", !itemStack.getItemMeta().hasDisplayName() ? itemStack.getType().toString() : itemStack.getItemMeta().getDisplayName())));
                this.displayingAsBroken = true;
            }
            return this.fillNullItem();
        }
        if (this.displayingAsBroken) {
            BossBarUtil.HideBrokenItemBossBar(this.equipmentSlot, this.player);
            this.displayingAsBroken = false;
        }
        if (EnchantmentsConfig.getEnchantment(SoulbindEnchantment.key + ".yml").isEnabled() && !SoulbindEnchantment.isValidSoulbindUser(itemStack.getItemMeta(), this.player)) {
            this.player.getWorld().dropItem(this.player.getLocation(), itemStack);
            itemStack.setAmount(0);
            itemStack = new ItemStack(Material.AIR);
        }
        this.eliteDamage = 0.0;
        this.itemStack = itemStack;
        if (this.equipmentSlot.equals((Object)EquipmentSlot.MAINHAND)) {
            this.itemTier = (int)Math.round(EliteItemManager.getWeaponLevel(itemStack));
            this.eliteDamage = EliteItemManager.getEliteDamageFromEliteAttributes(itemStack);
        } else {
            this.itemTier = (int)Math.round(EliteItemManager.getArmorLevel(itemStack));
        }
        if (PlayerData.getMatchInstance(this.player) != null && (matchInstance = PlayerData.getMatchInstance(this.player)) instanceof DungeonInstance && (dungeonInstance = (DungeonInstance)matchInstance).getLevelSync() > 0 && this.itemTier > dungeonInstance.getLevelSync()) {
            this.itemTier = dungeonInstance.getLevelSync();
            if (this.equipmentSlot.equals((Object)EquipmentSlot.MAINHAND)) {
                this.eliteDamage = EliteItemManager.calculateEliteBonus(itemStack, this.itemTier);
            }
        }
        this.continuousPotionEffects = ItemTagger.getPotionEffects(itemStack.getItemMeta(), ItemTagger.continuousPotionEffectKey);
        this.onHitPotionEffects = ItemTagger.getPotionEffects(itemStack.getItemMeta(), ItemTagger.onHitPotionEffectKey);
        this.eliteDamageReduction = EliteItemManager.getEliteDefense(itemStack) + EliteItemManager.getBonusEliteDefense(itemStack);
        this.protectionProjectile = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.PROJECTILE_PROTECTION.getKey());
        this.blastProtection = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.BLAST_PROTECTION.getKey());
        this.damageArthropodsLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.BANE_OF_ARTHROPODS.getKey());
        this.damageUndeadLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.SMITE.getKey());
        this.critChance = (double)ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, CriticalStrikesEnchantment.key)) / 10.0;
        this.lightningChance = Math.pow(ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "lightning")), 2.0) / 1000.0;
        this.plasmaBootsLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, PlasmaBootsEnchantment.key));
        this.hunterChance = (double)ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, HunterEnchantment.key)) * EnchantmentsConfig.getEnchantment("hunter.yml").getFileConfiguration().getDouble("hunterSpawnBonus");
        this.earthquakeLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, EarthquakeEnchantment.key));
        this.thornsLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.THORNS.getKey());
        this.loudStrikesBonus = (double)ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, LoudStrikesEnchantment.key)) / 3.0;
        this.eliteDamage += EliteItemManager.getEliteDamageFromEnchantments(itemStack);
        return true;
    }

    private boolean fillNullItem() {
        this.itemStack = null;
        this.itemTier = 0;
        this.continuousPotionEffects = new ArrayList();
        this.onHitPotionEffects = new ArrayList();
        this.damageArthropodsLevel = 0;
        this.damageUndeadLevel = 0;
        this.thornsLevel = 0;
        this.plasmaBootsLevel = 0.0;
        this.critChance = 0.0;
        this.hunterChance = 0.0;
        this.lightningChance = 0.0;
        this.earthquakeLevel = 0.0;
        this.eliteDamageReduction = 0.0;
        this.protectionProjectile = 0.0;
        this.eliteDamage = 0.0;
        this.blastProtection = 0.0;
        this.loudStrikesBonus = 0.0;
        return true;
    }

    public int getTier(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.itemTier;
    }

    public double getEliteDamage(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.eliteDamage;
    }

    public double getEliteDefense(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.eliteDamageReduction;
    }

    public double getProtectionProjectile(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.protectionProjectile;
    }

    public double getBlastProtection(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.blastProtection;
    }

    public ArrayList<ElitePotionEffect> getContinuousPotionEffects(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.continuousPotionEffects;
    }

    public ArrayList<ElitePotionEffect> getOnHitPotionEffects(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.onHitPotionEffects;
    }

    public int getDamageArthropodsLevel(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.damageArthropodsLevel;
    }

    public int getDamageUndeadLevel(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.damageUndeadLevel;
    }

    public double getCritChance(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.critChance;
    }

    public double getHunterChance(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.hunterChance;
    }

    public double getLightningChance(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.lightningChance;
    }

    public double getPlasmaBootsLevel(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.plasmaBootsLevel;
    }

    public double getEarthquakeLevel(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.earthquakeLevel;
    }

    public double getLoudStrikesBonus(ItemStack itemStack, boolean update) {
        if (update) {
            this.fullUpdate(itemStack);
        }
        return this.loudStrikesBonus;
    }

    public static enum EquipmentSlot {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS,
        MAINHAND,
        OFFHAND;

    }
}

