/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.npcs.chatter;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.npcs.NPCInteractions;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.DynamicQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class NPCProximitySensor
implements Listener {
    private static final Set<UUID> nearbyPlayers = new HashSet<UUID>();
    private static BukkitTask proximityScanTask = null;

    public NPCProximitySensor() {
        proximityScanTask = new BukkitRunnable(){

            public void run() {
                HashSet<UUID> unseenPlayerList = new HashSet<UUID>(nearbyPlayers);
                for (NPCEntity npcEntity : EntityTracker.getNpcEntities().values()) {
                    if (!npcEntity.isValid()) continue;
                    for (Entity entity : npcEntity.getVillager().getNearbyEntities(npcEntity.getNPCsConfigFields().getActivationRadius(), npcEntity.getNPCsConfigFields().getActivationRadius(), npcEntity.getNPCsConfigFields().getActivationRadius())) {
                        if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
                        Player player = (Player)entity;
                        UUID playerUUID = player.getUniqueId();
                        Location rotatedLocation = npcEntity.getVillager().getLocation().setDirection(entity.getLocation().subtract(npcEntity.getVillager().getLocation()).toVector());
                        npcEntity.getVillager().teleport(rotatedLocation);
                        if (unseenPlayerList.contains(playerUUID)) {
                            if (!npcEntity.getNPCsConfigFields().getInteractionType().equals((Object)NPCInteractions.NPCInteractionType.CHAT)) {
                                npcEntity.sayDialog(player);
                            }
                            unseenPlayerList.remove(playerUUID);
                            continue;
                        }
                        npcEntity.sayGreeting(player);
                        nearbyPlayers.add(playerUUID);
                        NPCProximitySensor.this.startQuestIndicator(npcEntity, player);
                    }
                }
                nearbyPlayers.removeAll(unseenPlayerList);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 100L);
    }

    public static void shutdown() {
        if (proximityScanTask != null && !proximityScanTask.isCancelled()) {
            proximityScanTask.cancel();
            proximityScanTask = null;
        }
        nearbyPlayers.clear();
    }

    private void startQuestIndicator(NPCEntity npcEntity, Player player) {
        if (!npcEntity.getNPCsConfigFields().getInteractionType().equals((Object)NPCInteractions.NPCInteractionType.QUEST_GIVER) && !npcEntity.getNPCsConfigFields().getInteractionType().equals((Object)NPCInteractions.NPCInteractionType.CUSTOM_QUEST_GIVER)) {
            return;
        }
        this.findQuestState(npcEntity, player);
    }

    private void findQuestState(NPCEntity npcEntity, Player player) {
        if (npcEntity.getNPCsConfigFields().getQuestFilenames() == null) {
            return;
        }
        if (npcEntity.getNPCsConfigFields().getInteractionType().equals((Object)NPCInteractions.NPCInteractionType.CUSTOM_QUEST_GIVER)) {
            if (!PlayerData.getQuests(player.getUniqueId()).isEmpty()) {
                for (String questString : npcEntity.getNPCsConfigFields().getQuestFilenames()) {
                    for (Quest quest : PlayerData.getQuests(player.getUniqueId())) {
                        if (!(quest instanceof CustomQuest) || !questString.equals(((CustomQuest)quest).getCustomQuestsConfigFields().getFilename())) continue;
                        if (!quest.isAccepted()) {
                            if (!((CustomQuest)quest).hasPermissionForQuest(player)) {
                                return;
                            }
                            this.unacceptedQuestIndicator(npcEntity, player);
                            return;
                        }
                        if (!quest.getQuestObjectives().isOver()) {
                            this.acceptedQuestIndicator(npcEntity, player);
                            return;
                        }
                        this.completedQuestIndicator(npcEntity, player);
                        return;
                    }
                }
            }
        } else if (npcEntity.getNPCsConfigFields().getInteractionType().equals((Object)NPCInteractions.NPCInteractionType.QUEST_GIVER)) {
            for (Quest quest : PlayerData.getQuests(player.getUniqueId())) {
                if (!(quest instanceof DynamicQuest)) continue;
                if (!quest.isAccepted()) {
                    this.unacceptedQuestIndicator(npcEntity, player);
                    return;
                }
                if (!quest.getQuestObjectives().isOver()) {
                    this.acceptedQuestIndicator(npcEntity, player);
                    return;
                }
                this.completedQuestIndicator(npcEntity, player);
                return;
            }
        }
        this.unacceptedQuestIndicator(npcEntity, player);
    }

    private void unacceptedQuestIndicator(NPCEntity npcEntity, Player player) {
        this.generateIndicator(npcEntity, player, String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "!", String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "!");
    }

    private void acceptedQuestIndicator(NPCEntity npcEntity, Player player) {
        this.generateIndicator(npcEntity, player, String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "?", String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "?");
    }

    private void completedQuestIndicator(NPCEntity npcEntity, Player player) {
        this.generateIndicator(npcEntity, player, String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "?", String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "?");
    }

    private void generateIndicator(NPCEntity npcEntity, Player player, String messageUp, String messageDown) {
        Location newLocation = npcEntity.getVillager().getEyeLocation().clone().add(player.getLocation().clone().subtract(npcEntity.getVillager().getLocation()).toVector().normalize().multiply(0.5)).add(new Vector(0.0, -0.1, 0.0));
        TextDisplay visualArmorStand = VisualDisplay.generateTemporaryTextDisplay(newLocation, messageUp);
        AtomicInteger counter = new AtomicInteger();
        AtomicBoolean up = new AtomicBoolean(true);
        Bukkit.getScheduler().runTaskTimer((Plugin)MetadataHandler.PLUGIN, task -> {
            if (!player.isValid() || npcEntity.getVillager() == null || !npcEntity.getVillager().isValid() || !npcEntity.getVillager().getWorld().equals(player.getWorld()) || npcEntity.getVillager().getLocation().distance(player.getLocation()) > npcEntity.getNPCsConfigFields().getActivationRadius()) {
                task.cancel();
                EntityTracker.unregister((Entity)visualArmorStand, RemovalReason.EFFECT_TIMEOUT);
                return;
            }
            counter.getAndIncrement();
            if (counter.get() % 20 == 0) {
                up.getAndSet(!up.get());
                if (up.get()) {
                    visualArmorStand.setCustomName(messageUp);
                } else {
                    visualArmorStand.setCustomName(messageDown);
                }
            }
            visualArmorStand.teleport(visualArmorStand.getLocation().clone().add(new Vector(0.0, up.get() ? 0.01 : -0.01, 0.0)));
        }, 0L, 1L);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTitle().length() > 0) {
            for (Entity entity : event.getPlayer().getNearbyEntities(5.0, 5.0, 5.0)) {
                if (!EntityTracker.isNPCEntity(entity)) continue;
                EntityTracker.getNPCEntity(entity).sayFarewell((Player)event.getPlayer());
            }
        }
    }
}

