/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses.transitiveblocks;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.mobconstructor.custombosses.PhaseBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.transitiveblocks.TransitiveBlock;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;

public class TransitiveBlockCommand {
    public static HashMap<UUID, TransitiveBlockCommand> activePlayers = new HashMap();
    private final Player player;
    private final CustomBossesConfigFields customBossesConfigFields;
    private final TransitiveBlockType transitiveBlockType;
    private List<TransitiveBlock> transitiveBlockList = new ArrayList<TransitiveBlock>();
    private RegionalBossEntity regionalBossEntity;
    private boolean regionalSelection = false;
    private Location corner1;
    private Location corner2;

    public TransitiveBlockCommand(Player player, CustomBossesConfigFields customBossesConfigFields, TransitiveBlockType transitiveBlockType, boolean edit) {
        this.player = player;
        this.customBossesConfigFields = customBossesConfigFields;
        this.transitiveBlockType = transitiveBlockType;
        List<RegionalBossEntity> regionalBossEntities = RegionalBossEntity.getRegionalBossEntities(customBossesConfigFields);
        if (regionalBossEntities.isEmpty()) {
            block4: for (RegionalBossEntity iteratedRegionalBossEntity : RegionalBossEntity.getRegionalBossEntitySet()) {
                if (iteratedRegionalBossEntity.getPhaseBossEntity() == null) continue;
                for (PhaseBossEntity.BossPhase bossPhase : iteratedRegionalBossEntity.getPhaseBossEntity().getBossPhases()) {
                    if (bossPhase.customBossesConfigFields == null) {
                        String message = "Could not find valid custom boss config fields for phase boss! This is probably a configuration issue. Check why your phase boss isn't valid on console logs on /em reload and make sure to test the phases in-game!";
                        Logger.warn((String)message);
                        player.sendMessage(message);
                    }
                    if (!((Object)((Object)bossPhase.customBossesConfigFields)).equals((Object)customBossesConfigFields)) continue;
                    this.regionalBossEntity = iteratedRegionalBossEntity;
                    continue block4;
                }
            }
            if (this.regionalBossEntity == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[EliteMobs] Transitive blocks require one Regional Boss from the configuration files to be placed in order to add transitive blocks relative to the spawn coordinates of that boss.");
                player.sendMessage(String.valueOf(ChatColor.RED) + "[EliteMobs] Cancelling block registration!");
                return;
            }
        }
        if (this.regionalBossEntity == null) {
            if (regionalBossEntities.size() > 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[EliteMobs] Transitive blocks require having ONLY one Regional Boss from the configuration files to be placed in order to add transitive blocks relative to the spawn coordinates of that boss. If there is more than one boss, the plugin can't determine which boss specifically should be getting the transitive blocks");
                player.sendMessage(String.valueOf(ChatColor.RED) + "[EliteMobs] If want multiple bosses to have transitive blocks, you will need one configuration file per boss that has them!");
                player.sendMessage(String.valueOf(ChatColor.RED) + "[EliteMobs] Cancelling block registration!");
                return;
            }
            this.regionalBossEntity = regionalBossEntities.get(0);
        }
        if (edit) {
            switch (transitiveBlockType) {
                case ON_SPAWN: {
                    this.transitiveBlockList = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnSpawnBlockStates(), customBossesConfigFields.getFilename());
                    break;
                }
                case ON_REMOVE: {
                    this.transitiveBlockList = TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnRemoveBlockStates(), customBossesConfigFields.getFilename());
                }
            }
        }
        activePlayers.put(player.getUniqueId(), this);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "[EliteMobs] Now registering " + transitiveBlockType.toString() + " blocks! " + String.valueOf(ChatColor.DARK_GREEN) + "Punch blocks to register air at that location, or right click blocks to register the block you right clicked!");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "[EliteMobs] Run the same command to stop registering blocks and save!");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "[EliteMobs] Or run the command /em cancelblocks  to cancel the registration!");
    }

    public static void shutdown() {
        activePlayers.clear();
    }

    public static TransitiveBlockCommand processCommand(Player player, String filename, String transitiveBlockType, boolean edit, boolean regionalSelection) {
        TransitiveBlockCommand transitiveBlockCommand = TransitiveBlockCommand.processCommand(player, filename, transitiveBlockType, edit);
        if (transitiveBlockCommand != null) {
            transitiveBlockCommand.setRegionalSelection(regionalSelection);
        }
        if (transitiveBlockCommand != null) {
            player.sendMessage("[EliteMobs] Now registering large selection for transitive blocks! Left click to set corner 1, right click to set corner 2! Run the same command again to stop registering blocks and run /em cancelblocks to cancel!");
        }
        return transitiveBlockCommand;
    }

    public static TransitiveBlockCommand processCommand(Player player, String filename, String transitiveBlockType, boolean edit) {
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(filename);
        if (customBossesConfigFields == null) {
            player.sendMessage("Boss file isn't valid! Try again with a valid filename for your custom boss.");
            return null;
        }
        if (!customBossesConfigFields.isRegionalBoss()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Boss file isn't for a regional boss! This feature only works for regional bosses.");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Ignore this warning if you are setting blocks for a phase boss whose first phase is a regional boss!");
        }
        TransitiveBlockType tbt = null;
        try {
            tbt = TransitiveBlockType.valueOf(transitiveBlockType);
        }
        catch (Exception ex) {
            player.sendMessage("Not a valid transitive block type, use ON_SPAWN or ON_REMOVE !");
            return null;
        }
        UUID playerUUID = player.getUniqueId();
        if (activePlayers.containsKey(playerUUID)) {
            activePlayers.get(playerUUID).commitLocations();
            return null;
        }
        return new TransitiveBlockCommand(player, customBossesConfigFields, tbt, edit);
    }

    public static void processCommand(Player player) {
        activePlayers.remove(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.RED) + "[EliteMobs] Block registration successfully cancelled!");
    }

    public void setCorner(boolean leftClick, Location location) {
        int blockCount;
        if (leftClick) {
            this.corner1 = location;
            this.player.sendMessage("Set corner 1!");
        } else {
            this.corner2 = location;
            this.player.sendMessage("Set corner 2!");
        }
        if (this.corner1 != null && this.corner2 != null && this.corner1.getWorld() == this.corner2.getWorld() && (blockCount = (int)((Math.abs(this.corner1.getX() - this.corner2.getX()) + 1.0) * (Math.abs(this.corner1.getY() - this.corner2.getY()) + 1.0) * (Math.abs(this.corner1.getZ() - this.corner2.getZ()) + 1.0))) > DefaultConfig.getDefaultTransitiveBlockLimiter()) {
            this.player.sendMessage("[EliteMobs] Current selection has " + blockCount + " blocks selected. For performance reasons, it is recommended you don't go over " + DefaultConfig.getDefaultTransitiveBlockLimiter() + " blocks!");
        }
    }

    private Vector getRelativeCoordinate(Location location) {
        return new Vector(location.getX() - this.regionalBossEntity.getSpawnLocation().getX(), location.getY() - this.regionalBossEntity.getSpawnLocation().getY(), location.getZ() - this.regionalBossEntity.getSpawnLocation().getZ());
    }

    public void registerBlock(Block block) {
        if (this.doubleEntryCheck(block, false)) {
            return;
        }
        this.transitiveBlockList.add(new TransitiveBlock(block.getBlockData(), this.getRelativeCoordinate(block.getLocation())));
        this.player.sendMessage("Registered " + String.valueOf(block.getType()) + " block!");
    }

    public void registerAir(Block block) {
        if (this.doubleEntryCheck(block, true)) {
            return;
        }
        this.transitiveBlockList.add(new TransitiveBlock(Material.AIR.createBlockData(), this.getRelativeCoordinate(block.getLocation())));
        this.player.sendMessage("Registered air block!");
    }

    private boolean doubleEntryCheck(Block block, boolean isAir) {
        TransitiveBlock transitiveBlock = null;
        for (TransitiveBlock element : this.transitiveBlockList) {
            if (!element.getRelativeLocation().equals((Object)this.getRelativeCoordinate(block.getLocation())) || (!element.isAir() || isAir) && (element.isAir() || !isAir)) continue;
            transitiveBlock = element;
            break;
        }
        if (transitiveBlock == null) {
            return false;
        }
        this.transitiveBlockList.remove(transitiveBlock);
        this.player.sendMessage("Unregistered block!");
        return true;
    }

    public void commitLocations() {
        activePlayers.remove(this.player.getUniqueId());
        this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "[EliteMobs] Now saving " + this.transitiveBlockType.toString() + " blocks!");
        ArrayList<String> deserializedData = new ArrayList<String>();
        if (this.regionalSelection) {
            int blockCount = (int)((Math.abs(this.corner1.getX() - this.corner2.getX()) + 1.0) * (Math.abs(this.corner1.getY() - this.corner2.getY()) + 1.0) * (Math.abs(this.corner1.getZ() - this.corner2.getZ()) + 1.0));
            if (blockCount > DefaultConfig.getDefaultTransitiveBlockLimiter()) {
                this.player.sendMessage("[EliteMobs] You registered more than " + DefaultConfig.getDefaultTransitiveBlockLimiter() + " blocks at once. For performance reasons, it is recommended you keep the selections low. Avoid things like selecting a lot of unnecessary air blocks!");
            }
            int lowestX = (int)Math.min(this.corner1.getX(), this.corner2.getX());
            int highestX = (int)Math.max(this.corner1.getX(), this.corner2.getX());
            int lowestY = (int)Math.min(this.corner1.getY(), this.corner2.getY());
            int highestY = (int)Math.max(this.corner1.getY(), this.corner2.getY());
            int lowestZ = (int)Math.min(this.corner1.getZ(), this.corner2.getZ());
            int highestZ = (int)Math.max(this.corner1.getZ(), this.corner2.getZ());
            for (int x = lowestX; x < highestX + 1; ++x) {
                for (int y = lowestY; y < highestY + 1; ++y) {
                    for (int z = lowestZ; z < highestZ + 1; ++z) {
                        Location blockLocation = new Location(this.player.getWorld(), (double)x, (double)y, (double)z);
                        this.transitiveBlockList.add(new TransitiveBlock(blockLocation.getBlock().getBlockData(), this.getRelativeCoordinate(blockLocation)));
                    }
                }
            }
            this.player.sendMessage("Successfully registered " + this.transitiveBlockList.size() + " blocks between your corners!");
        }
        for (TransitiveBlock transitiveBlock : this.transitiveBlockList) {
            String deserializedString = transitiveBlock.getRelativeLocation().getX() + "," + transitiveBlock.getRelativeLocation().getY() + "," + transitiveBlock.getRelativeLocation().getZ() + "/" + transitiveBlock.getBlockData().getAsString();
            deserializedData.add(deserializedString);
        }
        switch (this.transitiveBlockType) {
            case ON_SPAWN: {
                this.customBossesConfigFields.setOnSpawnBlockStates(deserializedData);
                if (this.regionalBossEntity.getCustomBossesConfigFields().getFilename().equals(this.customBossesConfigFields.getFilename())) {
                    this.regionalBossEntity.setOnSpawnTransitiveBlocks(TransitiveBlock.serializeTransitiveBlocks(deserializedData, this.customBossesConfigFields.getFilename()));
                }
                this.player.sendMessage("Locations registered correctly!");
                break;
            }
            case ON_REMOVE: {
                this.customBossesConfigFields.setOnRemoveBlockStates(deserializedData);
                if (this.regionalBossEntity.getCustomBossesConfigFields().getFilename().equals(this.customBossesConfigFields.getFilename())) {
                    this.regionalBossEntity.setOnRemoveTransitiveBlocks(TransitiveBlock.serializeTransitiveBlocks(deserializedData, this.customBossesConfigFields.getFilename()));
                }
                this.player.sendMessage("Locations registered correctly!");
                break;
            }
            default: {
                this.player.sendMessage("Failed to commit locations!");
            }
        }
    }

    @Generated
    public boolean isRegionalSelection() {
        return this.regionalSelection;
    }

    @Generated
    public void setRegionalSelection(boolean regionalSelection) {
        this.regionalSelection = regionalSelection;
    }

    public static enum TransitiveBlockType {
        ON_SPAWN,
        ON_REMOVE;

    }

    public static class TemporaryBossBlockCommandEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onPlayerInteractBlockEvent(PlayerInteractEvent event) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            if (!activePlayers.containsKey(playerUUID)) {
                return;
            }
            if (event.getHand() != EquipmentSlot.HAND) {
                return;
            }
            if (event.getClickedBlock() == null) {
                return;
            }
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                if (event.getClickedBlock().getType().isAir()) {
                    return;
                }
                if (activePlayers.get(playerUUID).isRegionalSelection()) {
                    activePlayers.get(playerUUID).setCorner(false, event.getClickedBlock().getLocation());
                } else {
                    activePlayers.get(playerUUID).registerBlock(event.getClickedBlock());
                }
                event.setCancelled(true);
            } else if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                if (activePlayers.get(playerUUID).isRegionalSelection()) {
                    activePlayers.get(playerUUID).setCorner(true, event.getClickedBlock().getLocation());
                } else {
                    activePlayers.get(playerUUID).registerAir(event.getClickedBlock());
                }
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            activePlayers.remove(event.getPlayer().getUniqueId());
        }
    }
}

