/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.google.common.collect.ArrayListMultimap;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DynamicDungeonInstance;
import com.magmaguy.elitemobs.mobconstructor.PersistentMovingEntity;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.ElitePowerParser;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.magmacore.instance.MatchInstance;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class InstancedBossEntity
extends RegionalBossEntity
implements PersistentObject,
PersistentMovingEntity {
    private static final ArrayListMultimap<String, InstancedBossContainer> instancedBossEntities = ArrayListMultimap.create();
    private DungeonInstance dungeonInstance = null;
    private MatchInstance matchInstance;
    private Set<Player> lockoutPlayers = new HashSet<Player>();

    public InstancedBossEntity(CustomBossesConfigFields customBossesConfigFields, Location location, DungeonInstance dungeonInstance) {
        super(customBossesConfigFields, location, false, true);
        this.dungeonInstance = dungeonInstance;
        this.elitePowers = ElitePowerParser.parsePowers(customBossesConfigFields, this);
        if (this.level == -1) {
            if (dungeonInstance instanceof DynamicDungeonInstance) {
                DynamicDungeonInstance dynamicDungeonInstance = (DynamicDungeonInstance)dungeonInstance;
                this.level = dynamicDungeonInstance.getSelectedLevel();
            } else if (dungeonInstance.getPlayers().isEmpty()) {
                Logger.warn((String)"Failed to get players for new instance when assigning dynamic level! The bosses will default to level 1.");
            } else {
                this.level = ElitePlayerInventory.getPlayer((Player)dungeonInstance.getPlayers().stream().findFirst().get()).getNaturalMobSpawnLevel(true);
            }
        }
    }

    public InstancedBossEntity(CustomBossesConfigFields customBossesConfigFields, Location location, MatchInstance matchInstance, int level) {
        super(customBossesConfigFields, location, false, true);
        this.level = level;
        this.matchInstance = matchInstance;
        this.elitePowers = ElitePowerParser.parsePowers(customBossesConfigFields, this);
    }

    public static CustomBossEntity createInstancedBossEntity(String filename, Location location, MatchInstance matchInstance, int level) {
        CustomBossesConfigFields configFields = CustomBossesConfig.getCustomBoss(filename);
        if (configFields == null) {
            Logger.warn((String)("Failed to spawn instanced boss entity " + filename + " via API!"));
            return null;
        }
        return new InstancedBossEntity(configFields, location, matchInstance, level);
    }

    public static void shutdown() {
        instancedBossEntities.clear();
    }

    public static void add(String stringLocation, CustomBossesConfigFields customBossesConfigFields) {
        String blueprintWorldName = stringLocation.split(",")[0];
        if (blueprintWorldName == null || blueprintWorldName.isEmpty()) {
            Logger.warn((String)("Failed to get blueprint world location for custom boss " + customBossesConfigFields.getFilename() + " !"));
            return;
        }
        instancedBossEntities.put((Object)blueprintWorldName, (Object)new InstancedBossContainer(ConfigurationLocation.serialize(stringLocation, true), customBossesConfigFields));
    }

    public static List<InstancedBossEntity> initializeInstancedBosses(String blueprintWorldName, World newWorld, int playerCount, DungeonInstance dungeonInstance) {
        ArrayList<InstancedBossEntity> newDungeonList = new ArrayList<InstancedBossEntity>();
        List rawBosses = instancedBossEntities.get((Object)blueprintWorldName);
        for (InstancedBossContainer containers : rawBosses) {
            Location newLocation = containers.getLocation().clone();
            newLocation.setWorld(newWorld);
            InstancedBossEntity newEntity = new InstancedBossEntity(containers.getCustomBossesConfigFields(), newLocation, dungeonInstance);
            newEntity.spawn(false);
            newDungeonList.add(newEntity);
        }
        return newDungeonList;
    }

    public void setNormalizedMaxHealth(int playerCount) {
        double normalizedDungeonMaxHealth;
        super.setNormalizedMaxHealth();
        if (this.dungeonInstance == null) {
            return;
        }
        if (playerCount < 2) {
            return;
        }
        this.maxHealth = normalizedDungeonMaxHealth = super.getMaxHealth() * 0.75 * (double)playerCount;
        this.health = this.maxHealth;
        if (this.livingEntity != null) {
            AttributeManager.setAttribute((LivingEntity)this.livingEntity, (String)"generic_max_health", (double)this.maxHealth);
            this.livingEntity.setHealth(this.maxHealth);
        }
    }

    @Override
    public void setMaxHealth() {
        double normalizedDungeonMaxHealth;
        super.setNormalizedMaxHealth();
        if (this.dungeonInstance == null) {
            return;
        }
        if (this.dungeonInstance.getPlayers().size() < 2) {
            return;
        }
        this.maxHealth = normalizedDungeonMaxHealth = super.getMaxHealth() * 0.75 * (double)this.dungeonInstance.getPlayers().size();
        if (this.health == null) {
            if (this.livingEntity != null) {
                this.livingEntity.setHealth(this.maxHealth);
            }
            this.health = this.maxHealth;
        } else if (this.livingEntity != null) {
            this.livingEntity.setHealth(Math.min(this.health, AttributeManager.getAttributeBaseValue((LivingEntity)this.livingEntity, (String)"generic_max_health")));
        }
    }

    public void setEntityLevel(int level) {
        this.level = level;
        this.setMaxHealth();
    }

    @Override
    public void remove(RemovalReason removalReason) {
        super.remove(removalReason);
        if (removalReason.equals((Object)RemovalReason.WORLD_UNLOAD) && this.persistentObjectHandler != null) {
            this.persistentObjectHandler.remove();
            this.persistentObjectHandler = null;
        }
    }

    @Generated
    public DungeonInstance getDungeonInstance() {
        return this.dungeonInstance;
    }

    @Generated
    public MatchInstance getMatchInstance() {
        return this.matchInstance;
    }

    @Generated
    public Set<Player> getLockoutPlayers() {
        return this.lockoutPlayers;
    }

    @Generated
    public void setLockoutPlayers(Set<Player> lockoutPlayers) {
        this.lockoutPlayers = lockoutPlayers;
    }

    private static class InstancedBossContainer {
        private final Location location;
        private final CustomBossesConfigFields customBossesConfigFields;

        public InstancedBossContainer(Location location, CustomBossesConfigFields customBossesConfigFields) {
            this.location = location;
            this.customBossesConfigFields = customBossesConfigFields;
        }

        @Generated
        public Location getLocation() {
            return this.location;
        }

        @Generated
        public CustomBossesConfigFields getCustomBossesConfigFields() {
            return this.customBossesConfigFields;
        }
    }
}

