/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfigFields;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.powers.BonusCoins;
import com.magmaguy.elitemobs.powers.meta.CustomSummonPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ElitePowerParser {
    public static HashSet<ElitePower> parsePowers(CustomBossesConfigFields customBossesConfigFields, CustomBossEntity customBossEntity) {
        HashSet<ElitePower> elitePowers = new HashSet<ElitePower>(EliteScript.generateBossScripts(customBossesConfigFields.getEliteScript(), customBossEntity));
        if (customBossesConfigFields.getPowers() == null) {
            return elitePowers;
        }
        CustomSummonPower customSummonPower = null;
        ArrayList<Object> powers = new ArrayList<Object>(customBossesConfigFields.getPowers());
        if (powers == null) {
            return elitePowers;
        }
        for (Object e : powers) {
            if (e instanceof String) {
                String powerName = (String)e;
                if (powerName.split(":")[0].equalsIgnoreCase("summon") || powerName.split(":")[0].equalsIgnoreCase("summonable")) {
                    if (customSummonPower == null) {
                        customSummonPower = new CustomSummonPower(powerName, customBossesConfigFields);
                        elitePowers.add(customSummonPower);
                        continue;
                    }
                    customSummonPower.addEntry(powerName, customBossesConfigFields.getFilename());
                    continue;
                }
                String[] parsedPowerName = powerName.split(":");
                ElitePower elitePower = ElitePowerParser.addPower(parsedPowerName[0], elitePowers, customBossesConfigFields, customBossEntity);
                if (elitePower == null || !elitePower.getPowersConfigFields().getFilename().equals("bonus_coins.yml") || parsedPowerName.length <= 1) continue;
                try {
                    ((BonusCoins)elitePower).setCoinMultiplier(Double.parseDouble(parsedPowerName[1]));
                }
                catch (Exception ex) {
                    Logger.warn((String)("Multiplier " + parsedPowerName[1] + " for Bonus Coins power is not a valid multiplier!"));
                }
                continue;
            }
            if (!(e instanceof Map)) continue;
            Map map = (Map)e;
            boolean isReinforcementsConfig = false;
            for (Object key : map.keySet()) {
                if (!((String)key).equalsIgnoreCase("summontype")) continue;
                isReinforcementsConfig = true;
                break;
            }
            if (customBossEntity instanceof InstancedBossEntity) {
                InstancedBossEntity instancedBossEntity = (InstancedBossEntity)customBossEntity;
                List<Object> difficulties = new ArrayList();
                for (Map.Entry entry : map.entrySet()) {
                    if (!((String)entry.getKey()).equalsIgnoreCase("difficultyID")) continue;
                    difficulties = MapListInterpreter.parseStringList((String)entry.getKey(), entry.getValue(), customBossesConfigFields.getFilename());
                    break;
                }
                if (!difficulties.isEmpty() && instancedBossEntity.getDungeonInstance() != null && !difficulties.contains(instancedBossEntity.getDungeonInstance().getDifficultyID())) continue;
            }
            if (isReinforcementsConfig) {
                if (customSummonPower == null) {
                    customSummonPower = new CustomSummonPower(e, customBossesConfigFields);
                    elitePowers.add(customSummonPower);
                    continue;
                }
                customSummonPower.addEntry(e, customBossesConfigFields.getFilename());
                continue;
            }
            String string = MapListInterpreter.parseString("filename", map.get("filename"), customBossesConfigFields.getFilename());
            if (string != null && !string.isEmpty()) {
                PowersConfigFields powersConfigFields = PowersConfig.getPower(string);
                if (powersConfigFields == null) {
                    Logger.warn((String)("Invalid power name " + string + " in file " + customBossesConfigFields.getFilename()));
                    continue;
                }
                ElitePowerParser.addPower(string, elitePowers, customBossesConfigFields, customBossEntity);
                continue;
            }
            Logger.warn((String)("No valid power name in boss config " + customBossesConfigFields.getFilename()));
        }
        return elitePowers;
    }

    private static ElitePower addPower(String powerName, HashSet<ElitePower> elitePowers, CustomBossesConfigFields customBossesConfigFields, EliteEntity eliteEntity) {
        PowersConfigFields powersConfigFields = PowersConfig.getPower(powerName);
        if (powersConfigFields != null) {
            if (!powersConfigFields.getEliteScriptBlueprints().isEmpty()) {
                elitePowers.addAll(EliteScript.generateBossScripts(powersConfigFields.getEliteScriptBlueprints(), eliteEntity));
                return null;
            }
            try {
                ElitePower elitePower = powersConfigFields.getElitePowerClass().newInstance();
                elitePowers.add(elitePower);
                return elitePower;
            }
            catch (Exception ex) {
                Logger.warn((String)("Could not process power " + powerName));
                return null;
            }
        }
        Logger.warn((String)("Warning: power name " + powerName + " for boss " + customBossesConfigFields.getFilename() + " is not registered! Skipping it for custom mob construction..."));
        return null;
    }
}

