/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobEnterCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobRemoveEvent;
import com.magmaguy.elitemobs.api.EliteMobSpawnEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.EventsConfig;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.CustomSpawn;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.PersistentMovingEntity;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.PersistentObjectHandler;
import com.magmaguy.elitemobs.mobconstructor.custombosses.BossTrackingBar;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEscapeMechanism;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossMegaConsumer;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossMount;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossTrail;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomMusic;
import com.magmaguy.elitemobs.mobconstructor.custombosses.ElitePowerParser;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.PhaseBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.transitiveblocks.TransitiveBlock;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.powers.meta.CustomSummonPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.thirdparty.custommodels.CustomModel;
import com.magmaguy.elitemobs.thirdparty.discordsrv.DiscordSRVAnnouncement;
import com.magmaguy.elitemobs.thirdparty.libsdisguises.DisguiseEntity;
import com.magmaguy.elitemobs.utils.CommandRunner;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ChunkLocationChecker;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CustomBossEntity
extends EliteEntity
implements Listener,
PersistentObject,
PersistentMovingEntity {
    public static Set<CustomBossEntity> dynamicLevelBossEntities = new HashSet<CustomBossEntity>();
    protected static HashSet<CustomBossEntity> trackableCustomBosses = new HashSet();
    private static BukkitTask dynamicLevelUpdater = null;
    private final List<BukkitTask> globalReinforcements = new ArrayList<BukkitTask>();
    protected CustomBossesConfigFields customBossesConfigFields;
    protected CustomBossEntity customBossMount = null;
    protected LivingEntity livingEntityMount = null;
    protected CustomBossEntity mount;
    protected PersistentObjectHandler persistentObjectHandler = null;
    protected Location persistentLocation;
    protected CustomBossTrail customBossTrail;
    protected BossTrackingBar bossTrackingBar;
    protected Integer escapeMechanism;
    protected PhaseBossEntity phaseBossEntity = null;
    protected String worldName;
    private long lastTick = 0L;
    private int attemptsCounter = 1;
    private Location respawnOverrideLocation = null;
    private EMPackage emPackage = null;
    private CustomSpawn customSpawn = null;
    private int existsFailureCount = 0;
    private boolean isMount = false;
    private CustomModel customModel = null;
    private boolean normalizedCombat;
    private CustomMusic bossMusic = null;
    private double followDistance;
    private double movementSpeedAttribute;
    private boolean dynamicLevel = false;

    public CustomBossEntity(CustomBossesConfigFields customBossesConfigFields) {
        if (customBossesConfigFields.getSong() != null) {
            this.bossMusic = new CustomMusic(customBossesConfigFields.getSong(), this);
        }
        this.setCustomBossesConfigFields(customBossesConfigFields);
        super.setPersistent(customBossesConfigFields.isPersistent());
        if (customBossesConfigFields.getPhases() != null) {
            this.phaseBossEntity = new PhaseBossEntity(this);
        }
        if (this instanceof RegionalBossEntity) {
            this.bypassesProtections = true;
        }
        this.emPackage = EMPackage.getContent(customBossesConfigFields.getFilename());
        this.followDistance = customBossesConfigFields.getFollowDistance().intValue();
        this.movementSpeedAttribute = customBossesConfigFields.getMovementSpeedAttribute() == null ? 0.0 : customBossesConfigFields.getMovementSpeedAttribute();
    }

    @Nullable
    public static CustomBossEntity createCustomBossEntity(String filename) {
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss(filename);
        if (customBossesConfigFields == null) {
            return null;
        }
        return new CustomBossEntity(customBossesConfigFields);
    }

    public static void addToUpdatingDynamicLevels(CustomBossEntity customBossEntity) {
        if (!customBossEntity.dynamicLevel) {
            return;
        }
        dynamicLevelBossEntities.add(customBossEntity);
    }

    public static void startUpdatingDynamicLevels() {
        dynamicLevelUpdater = new BukkitRunnable(){

            public void run() {
                Iterator<CustomBossEntity> iterator = dynamicLevelBossEntities.iterator();
                while (iterator.hasNext()) {
                    CustomBossEntity customBossEntity = iterator.next();
                    if (!customBossEntity.isValid()) {
                        iterator.remove();
                        continue;
                    }
                    int currentLevel = customBossEntity.getLevel();
                    customBossEntity.getDynamicLevel(customBossEntity.getLocation());
                    int newLevel = customBossEntity.getLevel();
                    if (currentLevel == newLevel) continue;
                    customBossEntity.setMaxHealth();
                    customBossEntity.setNormalizedHealth();
                    CustomBossMegaConsumer.setName(customBossEntity.getLivingEntity(), customBossEntity, customBossEntity.level);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 100L, 100L);
    }

    public static void shutdown() {
        if (dynamicLevelUpdater != null) {
            dynamicLevelUpdater.cancel();
        }
        dynamicLevelBossEntities.clear();
        trackableCustomBosses.clear();
    }

    @Override
    public void setSummoningEntity(EliteEntity summoningEntity) {
        this.summoningEntity = summoningEntity;
        if (summoningEntity instanceof CustomBossEntity) {
            this.emPackage = ((CustomBossEntity)summoningEntity).emPackage;
        }
    }

    public void setCustomBossesConfigFields(CustomBossesConfigFields customBossesConfigFields) {
        this.customBossesConfigFields = customBossesConfigFields;
        this.normalizedCombat = customBossesConfigFields.isNormalizedCombat();
        if (this.phaseBossEntity != null) {
            this.normalizedCombat = this.phaseBossEntity.getPhase1Config().isNormalizedCombat();
        }
        if (MobCombatSettingsConfig.isNormalizeRegionalBosses() && this instanceof RegionalBossEntity) {
            this.normalizedCombat = true;
        }
        super.setDamageMultiplier(customBossesConfigFields.getDamageMultiplier());
        super.setHealthMultiplier(customBossesConfigFields.getHealthMultiplier());
        super.setEliteLoot(customBossesConfigFields.isDropsEliteMobsLoot());
        super.setRandomLoot(customBossesConfigFields.isDropsRandomLoot());
        super.setVanillaLoot(customBossesConfigFields.isDropsVanillaLoot());
        super.setLevel(customBossesConfigFields.getLevel());
        this.setPluginName();
        this.elitePowers = ElitePowerParser.parsePowers(customBossesConfigFields, this);
        if (this instanceof RegionalBossEntity) {
            ((RegionalBossEntity)this).setOnSpawnTransitiveBlocks(TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnSpawnBlockStates(), customBossesConfigFields.getFilename()));
            ((RegionalBossEntity)this).setOnRemoveTransitiveBlocks(TransitiveBlock.serializeTransitiveBlocks(customBossesConfigFields.getOnRemoveBlockStates(), customBossesConfigFields.getFilename()));
        }
    }

    public void spawn(Location spawnLocation, int level, boolean silent) {
        this.level = level;
        this.spawnLocation = spawnLocation;
        this.spawn(spawnLocation, silent);
    }

    public void spawn(Location spawnLocation, boolean silent) {
        this.attemptsCounter = spawnLocation != null && spawnLocation.getWorld() != null && this.lastTick == spawnLocation.getWorld().getFullTime() ? ++this.attemptsCounter : 1;
        if (spawnLocation != null && spawnLocation.getWorld() != null) {
            this.lastTick = spawnLocation.getWorld().getFullTime();
        }
        if (this.exists()) {
            Logger.warn((String)("Warning: " + this.customBossesConfigFields.getFilename() + " attempted to double spawn " + this.attemptsCounter + " times!"), (boolean)true);
            return;
        }
        this.spawnLocation = spawnLocation;
        this.persistentLocation = spawnLocation;
        this.spawn(silent);
    }

    public void spawn(boolean silent) {
        if (this.livingEntity != null && this.livingEntity.isValid()) {
            return;
        }
        if (this.isPersistent.booleanValue() && this.persistentObjectHandler == null) {
            this.persistentObjectHandler = new PersistentObjectHandler(this);
        } else if (this.isPersistent.booleanValue()) {
            this.persistentObjectHandler.updatePersistentLocation(this.spawnLocation);
        }
        if (this.spawnLocation == null) {
            Logger.warn((String)("Boss " + this.customBossesConfigFields.getFilename() + " has a null location! This is probably due to an incorrectly configured regional location!"));
            return;
        }
        if (this.customBossesConfigFields.getLevel() == -1 && this.level == -1) {
            this.dynamicLevel = true;
            this.getDynamicLevel(this.spawnLocation);
        }
        if (ChunkLocationChecker.chunkAtLocationIsLoaded((Location)this.spawnLocation) || this.isMount) {
            this.livingEntity = new CustomBossMegaConsumer(this).spawn();
            this.setNormalizedHealth();
            if (this.livingEntity == null) {
                Logger.warn((String)"Something just prevented EliteMobs from spawning a Custom Boss! More info up next.");
            }
        }
        if (!this.exists()) {
            ++this.existsFailureCount;
            if (this.livingEntity != null) {
                this.livingEntity.remove();
                this.livingEntity = null;
            }
            if (this.existsFailureCount > 10) {
                if (this.existsFailureCount == 11) {
                    Logger.warn((String)("EliteMobs tried and failed to spawn " + this.customBossesConfigFields.getFilename() + " " + this.existsFailureCount + "times, probably due to regional protections or third party plugin incompatibilities."));
                    Logger.warn((String)"To avoid cluttering up console, these warnings will now only appear once 6000 attempts for this boss. ");
                }
                if (this.existsFailureCount % 6000 == 0) {
                    Logger.warn((String)("EliteMobs tried and failed to spawn " + this.customBossesConfigFields.getFilename() + " " + this.existsFailureCount + "times, probably due to regional protections or third party plugin incompatibilities."));
                    Logger.warn((String)"To avoid cluttering up console, these warnings will now only appear once 6000 attempts for this boss. ");
                }
                return;
            }
            if (this.existsFailureCount > 1) {
                Logger.warn((String)("EliteMobs tried and failed to spawn " + this.customBossesConfigFields.getFilename() + " " + this.existsFailureCount + "times, probably due to regional protections."));
                return;
            }
            Logger.warn((String)("EliteMobs tried and failed to spawn " + this.customBossesConfigFields.getFilename() + " . Possible reasons for this:"));
            Logger.warn((String)"- The region was protected by a plugin (most likely)");
            Logger.warn((String)"- The spawn was interfered with by some incompatible third party plugin");
            Logger.warn((String)"Debug data: ");
            Logger.warn((String)("Chunk is loaded: " + ChunkLocationChecker.chunkAtLocationIsLoaded((Location)this.spawnLocation)));
            Logger.warn((String)("Attempted spawn location: " + this.spawnLocation.toString()), (boolean)true);
            return;
        }
        if (this.livingEntity != null) {
            if (this.bossMusic != null) {
                this.bossMusic.start(this);
            }
            this.startBossTrails();
            this.mountEntity();
            this.getLivingEntity().setRemoveWhenFarAway(false);
        } else {
            this.persistentLocation = this.spawnLocation;
        }
        if (!silent) {
            this.announceSpawn();
        }
        if (this.summoningEntity != null) {
            this.summoningEntity.addReinforcement(this);
        }
        if (this.spawnLocation.getWorld() != null) {
            for (ElitePower elitePower : this.elitePowers) {
                if (!(elitePower instanceof CustomSummonPower)) continue;
                ((CustomSummonPower)elitePower).getCustomBossReinforcements().forEach(customBossReinforcement -> {
                    if (customBossReinforcement.summonType.equals((Object)CustomSummonPower.SummonType.GLOBAL)) {
                        this.globalReinforcements.add(CustomSummonPower.summonGlobalReinforcement(customBossReinforcement, this));
                    }
                });
            }
        }
        CommandRunner.runCommandFromList(this.customBossesConfigFields.getOnSpawnCommands(), new ArrayList<CommandRunner.ConfigPlaceholder>());
    }

    private void setNormalizedHealth() {
        if (this.normalizedCombat) {
            this.setNormalizedMaxHealth();
        }
    }

    public void setNormalizedCombat() {
        this.normalizedCombat = true;
        if (this.livingEntity != null) {
            this.setNormalizedMaxHealth();
        }
    }

    private void setPluginName() {
        if (this.customBossesConfigFields.getName() == null) {
            return;
        }
        if (this.level == -1) {
            this.setName(ChatColorConverter.convert((String)this.customBossesConfigFields.getName().replace("$level", "?").replace("$normalLevel", ChatColorConverter.convert((String)"&2[&a?&2]&f")).replace("$minibossLevel", ChatColorConverter.convert((String)"&6\u3016&e?&6\u3017&f")).replace("$bossLevel", ChatColorConverter.convert((String)"&4\u300e&c?&4\u300f&f")).replace("$reinforcementLevel", ChatColorConverter.convert((String)"&8\u3014&7") + "?&8\u3015&f").replace("$eventBossLevel", ChatColorConverter.convert((String)"&4\u300c&c?&4\u300d&f"))), false);
        } else {
            this.setName(ChatColorConverter.convert((String)this.customBossesConfigFields.getName().replace("$level", "" + this.level).replace("$normalLevel", ChatColorConverter.convert((String)("&2[&a" + this.level + "&2]&f"))).replace("$minibossLevel", ChatColorConverter.convert((String)("&6\u3016&e" + this.level + "&6\u3017&f"))).replace("$bossLevel", ChatColorConverter.convert((String)("&4\u300e&c" + this.level + "&4\u300f&f"))).replace("$reinforcementLevel", ChatColorConverter.convert((String)"&8\u3014&7") + this.level + "&8\u3015&f").replace("$eventBossLevel", ChatColorConverter.convert((String)("&4\u300c&c" + this.level + "&4\u300d&f")))), false);
        }
    }

    @Override
    public void setName(String name, boolean applyToLivingEntity) {
        super.setName(name, applyToLivingEntity);
        if (this.isValid() && this.customModel != null) {
            this.customModel.setName(name, true);
        }
    }

    @Override
    public void setName(EliteMobProperties eliteMobProperties) {
        super.setName(eliteMobProperties);
        if (this.isValid() && this.customModel != null) {
            this.customModel.setName(this.name, DefaultConfig.isAlwaysShowNametags());
        }
    }

    @Override
    public void setNameVisible(boolean isVisible) {
        if (this.livingEntity == null) {
            return;
        }
        super.setNameVisible(isVisible);
        if (Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
            DisguiseEntity.setDisguiseNameVisibility(isVisible, (Entity)this.livingEntity, this.name);
        }
        if (this.customModel != null && this.isValid()) {
            this.customModel.setNameVisible(isVisible);
        }
    }

    public void announceSpawn() {
        this.setTracking();
        this.spawnMessage();
        this.startEscapeMechanismDelay();
    }

    private void setTracking() {
        if (this.customBossesConfigFields.getAnnouncementPriority() < 1 || !MobCombatSettingsConfig.isShowCustomBossLocation() || this.customBossesConfigFields.getLocationMessage() == null) {
            return;
        }
        trackableCustomBosses.add(this);
        this.bossTrackingBar = new BossTrackingBar(this);
    }

    private void spawnMessage() {
        if (this.customBossesConfigFields.getSpawnMessage() == null) {
            return;
        }
        if (this.customBossesConfigFields.getAnnouncementPriority() < 1) {
            return;
        }
        if (this.getLocation() == null) {
            return;
        }
        if (this.getLocation().getWorld() == null) {
            return;
        }
        if (!EventsConfig.isAnnouncementBroadcastWorldOnly()) {
            Bukkit.broadcastMessage((String)ChatColorConverter.convert((String)this.customBossesConfigFields.getSpawnMessage()));
        } else {
            for (Player player : this.getLocation().getWorld().getPlayers()) {
                player.sendMessage(ChatColorConverter.convert((String)this.customBossesConfigFields.getSpawnMessage()));
            }
        }
        if (this.customBossesConfigFields.getAnnouncementPriority() < 3) {
            return;
        }
        new DiscordSRVAnnouncement(ChatColorConverter.convert((String)this.customBossesConfigFields.getSpawnMessage()));
    }

    public void getDynamicLevel(Location bossLocation) {
        int bossLevel = 1;
        if (bossLocation.getWorld() != null) {
            List players = bossLocation.getWorld().getPlayers();
            for (Player player : players) {
                int level;
                ElitePlayerInventory playerInventory;
                if (!(player.getLocation().distanceSquared(bossLocation) <= Math.pow(16.0 * ((double)Bukkit.getViewDistance() + 2.0), 2.0)) || (playerInventory = ElitePlayerInventory.getPlayer(player)) == null || (level = playerInventory.getNaturalMobSpawnLevel(false)) < bossLevel) continue;
                bossLevel = level;
            }
        }
        this.startUpdatingDynamicLevel();
        super.setLevel(bossLevel);
    }

    private void startUpdatingDynamicLevel() {
        if (dynamicLevelUpdater != null) {
            return;
        }
        dynamicLevelBossEntities.add(this);
    }

    private void startBossTrails() {
        this.customBossTrail = new CustomBossTrail(this);
    }

    private void mountEntity() {
        this.mount = CustomBossMount.generateMount(this);
    }

    private void startEscapeMechanismDelay() {
        this.escapeMechanism = CustomBossEscapeMechanism.startEscape(this.customBossesConfigFields.getTimeout(), this);
    }

    private void cullReinforcements(boolean cullGlobal) {
        if (cullGlobal) {
            this.globalReinforcementEntities.forEach(customBossEntity -> customBossEntity.remove(RemovalReason.REINFORCEMENT_CULL));
        }
        for (CustomBossEntity customBossEntity2 : this.eliteReinforcementEntities) {
            if (customBossEntity2 == null) continue;
            customBossEntity2.remove(RemovalReason.REINFORCEMENT_CULL);
        }
        for (Entity entity : this.nonEliteReinforcementEntities) {
            if (entity == null) continue;
            entity.remove();
        }
        if (cullGlobal) {
            this.globalReinforcements.clear();
        }
        this.eliteReinforcementEntities.clear();
        this.nonEliteReinforcementEntities.clear();
    }

    @Override
    public Location getLocation() {
        if (this.getLivingEntity() != null) {
            return this.getLivingEntity().getLocation();
        }
        return this.persistentLocation;
    }

    @Override
    public Location getPersistentLocation() {
        if (this.persistentLocation == null && this.getLocation() != null) {
            this.persistentLocation = this.getLocation();
        }
        if (this.persistentLocation == null && this.spawnLocation != null) {
            this.persistentLocation = this.spawnLocation;
        }
        return this.persistentLocation;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    public double getDamageModifier(Material material) {
        return this.customBossesConfigFields.getDamageModifier(material);
    }

    public void resetLivingEntity(LivingEntity livingEntity, CreatureSpawnEvent.SpawnReason spawnReason) {
        super.setLivingEntity(livingEntity, spawnReason);
        new CustomBossMegaConsumer(this).applyBossFeatures(livingEntity);
    }

    @Override
    public boolean exists() {
        return super.exists() || this.persistentObjectHandler != null;
    }

    @Override
    public void fullHeal() {
        if (this instanceof InstancedBossEntity) {
            return;
        }
        if (this.phaseBossEntity == null || this.phaseBossEntity.isInFirstPhase()) {
            super.fullHeal();
            return;
        }
        this.phaseBossEntity.resetToFirstPhase();
        this.damagers.clear();
    }

    @Override
    public void remove(RemovalReason removalReason) {
        boolean bossInstanceEnd;
        dynamicLevelBossEntities.remove(this);
        if (this.livingEntity != null) {
            this.persistentLocation = this.livingEntity.getLocation();
        }
        super.remove(removalReason);
        if (this.customBossTrail != null) {
            this.customBossTrail.terminateTrails();
        }
        if (this.livingEntityMount != null) {
            this.livingEntityMount.remove();
        }
        if (this.customBossMount != null) {
            this.customBossMount.remove(RemovalReason.REINFORCEMENT_CULL);
        }
        if (this.customBossesConfigFields.isCullReinforcements() || removalReason.equals((Object)RemovalReason.PHASE_BOSS_RESET)) {
            this.cullReinforcements(false);
        }
        if (removalReason.equals((Object)RemovalReason.PHASE_BOSS_PHASE_END) && this.inCombat) {
            new EventCaller(new EliteMobExitCombatEvent(this, EliteMobExitCombatEvent.EliteMobExitCombatReason.PHASE_SWITCH));
        }
        boolean bl = bossInstanceEnd = removalReason.equals((Object)RemovalReason.KILL_COMMAND) || removalReason.equals((Object)RemovalReason.DEATH) || removalReason.equals((Object)RemovalReason.BOSS_TIMEOUT) || removalReason.equals((Object)RemovalReason.SHUTDOWN) || removalReason.equals((Object)RemovalReason.ARENA_RESET) || removalReason.equals((Object)RemovalReason.REMOVE_COMMAND) || removalReason.equals((Object)RemovalReason.WORLD_UNLOAD) && this instanceof InstancedBossEntity;
        if (!this.isPersistent.booleanValue()) {
            bossInstanceEnd = true;
        }
        if (bossInstanceEnd) {
            if (!(this instanceof RegionalBossEntity) || this instanceof InstancedBossEntity) {
                EntityTracker.getEliteMobEntities().remove(this.eliteUUID);
            }
            new EventCaller(new EliteMobRemoveEvent(this, removalReason));
            if (this.escapeMechanism != null) {
                Bukkit.getScheduler().cancelTask(this.escapeMechanism.intValue());
            }
            trackableCustomBosses.remove(this);
            if (this.persistentObjectHandler != null) {
                this.persistentObjectHandler.remove();
                this.persistentObjectHandler = null;
            }
            if (this.bossTrackingBar != null) {
                this.bossTrackingBar.remove();
            }
            if (!(removalReason.equals((Object)RemovalReason.SHUTDOWN) || removalReason.equals((Object)RemovalReason.DEATH) || removalReason.equals((Object)RemovalReason.ARENA_RESET) || this.phaseBossEntity == null)) {
                this.phaseBossEntity.silentReset();
            }
            this.globalReinforcements.forEach(bukkitTask -> {
                if (bukkitTask != null) {
                    bukkitTask.cancel();
                }
            });
            this.globalReinforcements.clear();
            if (!removalReason.equals((Object)RemovalReason.REINFORCEMENT_CULL)) {
                if (this.summoningEntity != null) {
                    this.summoningEntity.removeReinforcement(this);
                }
                if (this.customSpawn != null) {
                    this.customSpawn.setKeepTrying(false);
                }
            }
            if (this.customBossesConfigFields.isCullReinforcements()) {
                this.cullReinforcements(true);
            }
        } else if ((removalReason.equals((Object)RemovalReason.CHUNK_UNLOAD) || removalReason.equals((Object)RemovalReason.WORLD_UNLOAD)) && this.persistentObjectHandler != null) {
            this.persistentObjectHandler.updatePersistentLocation(this.getPersistentLocation());
        }
        if (!removalReason.equals((Object)RemovalReason.PHASE_BOSS_PHASE_END) && this.bossMusic != null) {
            this.bossMusic.stop();
        }
    }

    @Override
    public void chunkLoad() {
        this.respawnOverrideLocation = this.persistentLocation;
        this.spawn(true);
    }

    @Override
    public void chunkUnload() {
        this.remove(RemovalReason.CHUNK_UNLOAD);
    }

    @Override
    public void worldLoad(World world) {
        if (this.spawnLocation != null) {
            this.spawnLocation.setWorld(world);
        }
    }

    @Override
    public void worldUnload() {
        this.remove(RemovalReason.WORLD_UNLOAD);
    }

    @Generated
    public static HashSet<CustomBossEntity> getTrackableCustomBosses() {
        return trackableCustomBosses;
    }

    @Generated
    public CustomBossesConfigFields getCustomBossesConfigFields() {
        return this.customBossesConfigFields;
    }

    @Generated
    public void setPersistentLocation(Location persistentLocation) {
        this.persistentLocation = persistentLocation;
    }

    @Generated
    public BossTrackingBar getBossTrackingBar() {
        return this.bossTrackingBar;
    }

    @Generated
    public PhaseBossEntity getPhaseBossEntity() {
        return this.phaseBossEntity;
    }

    @Generated
    public Location getRespawnOverrideLocation() {
        return this.respawnOverrideLocation;
    }

    @Generated
    public void setRespawnOverrideLocation(Location respawnOverrideLocation) {
        this.respawnOverrideLocation = respawnOverrideLocation;
    }

    @Generated
    public EMPackage getEmPackage() {
        return this.emPackage;
    }

    @Generated
    public void setEmPackage(EMPackage emPackage) {
        this.emPackage = emPackage;
    }

    @Generated
    public void setCustomSpawn(CustomSpawn customSpawn) {
        this.customSpawn = customSpawn;
    }

    @Generated
    public boolean isMount() {
        return this.isMount;
    }

    @Generated
    public void setMount(boolean isMount) {
        this.isMount = isMount;
    }

    @Generated
    public CustomModel getCustomModel() {
        return this.customModel;
    }

    @Generated
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    @Generated
    public boolean isNormalizedCombat() {
        return this.normalizedCombat;
    }

    @Generated
    public CustomMusic getBossMusic() {
        return this.bossMusic;
    }

    @Generated
    public void setBossMusic(CustomMusic bossMusic) {
        this.bossMusic = bossMusic;
    }

    @Generated
    public double getFollowDistance() {
        return this.followDistance;
    }

    @Generated
    public void setFollowDistance(double followDistance) {
        this.followDistance = followDistance;
    }

    @Generated
    public double getMovementSpeedAttribute() {
        return this.movementSpeedAttribute;
    }

    @Generated
    public void setMovementSpeedAttribute(double movementSpeedAttribute) {
        this.movementSpeedAttribute = movementSpeedAttribute;
    }

    @Generated
    public boolean isDynamicLevel() {
        return this.dynamicLevel;
    }

    @Generated
    public void setDynamicLevel(boolean dynamicLevel) {
        this.dynamicLevel = dynamicLevel;
    }

    public static class CustomBossEntityEvents
    implements Listener {
        public static void slowRegionalBoss(RegionalBossEntity regionalBossEntity) {
            if (regionalBossEntity.getCustomBossesConfigFields().isAlert()) {
                return;
            }
            if (regionalBossEntity.getLivingEntity() == null) {
                return;
            }
            if (regionalBossEntity.getMovementSpeedAttribute() > 0.12) {
                AttributeManager.setAttribute((LivingEntity)regionalBossEntity.getLivingEntity(), (String)"generic_movement_speed", (double)0.12);
            }
            AttributeManager.setAttribute((LivingEntity)regionalBossEntity.getLivingEntity(), (String)"generic_follow_range", (double)(AttributeManager.getAttributeBaseValue((LivingEntity)regionalBossEntity.getLivingEntity(), (String)"generic_follow_range") / 3.0));
        }

        @EventHandler
        public void slowAndBlindRegionalBossesOutOfCombat(EliteMobExitCombatEvent event) {
            RegionalBossEntity regionalBossEntity;
            EliteEntity eliteEntity = event.getEliteMobEntity();
            if (eliteEntity instanceof RegionalBossEntity && (regionalBossEntity = (RegionalBossEntity)eliteEntity).exists()) {
                CustomBossEntityEvents.slowRegionalBoss(regionalBossEntity);
            }
        }

        @EventHandler
        public void slowAndBlindRegionalBossesOnSpawn(EliteMobSpawnEvent event) {
            EliteEntity eliteEntity = event.getEliteMobEntity();
            if (eliteEntity instanceof RegionalBossEntity) {
                RegionalBossEntity regionalBossEntity = (RegionalBossEntity)eliteEntity;
                CustomBossEntityEvents.slowRegionalBoss(regionalBossEntity);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void removeSlowEvent(EliteMobEnterCombatEvent eliteMobEnterCombatEvent) {
            EliteEntity eliteEntity = eliteMobEnterCombatEvent.getEliteMobEntity();
            if (!(eliteEntity instanceof RegionalBossEntity)) {
                return;
            }
            RegionalBossEntity regionalBossEntity = (RegionalBossEntity)eliteEntity;
            regionalBossEntity.removeSlow();
        }

        @EventHandler(ignoreCancelled=true)
        public void onExitCombat(EliteMobExitCombatEvent event) {
            if (!(event.getEliteMobEntity() instanceof CustomBossEntity)) {
                return;
            }
            if (!((CustomBossEntity)event.getEliteMobEntity()).customBossesConfigFields.isCullReinforcements()) {
                return;
            }
            ((CustomBossEntity)event.getEliteMobEntity()).cullReinforcements(false);
        }

        @EventHandler
        public void onEliteSpawnEvent(EliteMobSpawnEvent event) {
            EliteEntity eliteEntity = event.getEliteMobEntity();
            if (eliteEntity instanceof CustomBossEntity) {
                CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
                CustomBossEntity.addToUpdatingDynamicLevels(customBossEntity);
            }
        }
    }
}

