/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.items.customloottable.SharedLootTable;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class LootMenu
extends EliteMenu {
    private static final HashMap<UUID, LootMenu> playerLoot = new HashMap();
    private static final List<Integer> glassSlots = List.of(Integer.valueOf(4), Integer.valueOf(13), Integer.valueOf(22), Integer.valueOf(31), Integer.valueOf(40), Integer.valueOf(49));
    private static final int greedInfo = 2;
    private static final int needInfo = 6;
    private static final List<Integer> greedSlots = List.of(9, 10, 11, 12, 18, 19, 20, 21, 27, 28, 29, 30, 36, 37, 38, 39, 45, 46, 47, 48);
    private static final List<Integer> needSlots = List.of(14, 15, 16, 17, 23, 24, 25, 26, 32, 33, 34, 35, 41, 42, 43, 44, 50, 51, 52, 53);
    private final SharedLootTable sharedLootTable;
    private final SharedLootTable.PlayerTable playerTable;
    private final Inventory inventory;
    private final Player player;

    public LootMenu(Player player, SharedLootTable sharedLootTable, SharedLootTable.PlayerTable playerTable) {
        this.inventory = Bukkit.createInventory((InventoryHolder)player, (int)54);
        this.sharedLootTable = sharedLootTable;
        this.playerTable = playerTable;
        this.player = player;
        for (int i : glassSlots) {
            this.inventory.setItem(i, new ItemStack(Material.GRAY_STAINED_GLASS_PANE));
        }
        this.inventory.setItem(2, ItemStackGenerator.generateItemStack((Material)Material.ORANGE_STAINED_GLASS_PANE, (String)ChatColorConverter.convert((String)"&2Greed Item List"), List.of("Click to move to the Need item list!", "Items in the greed list will only", "be rolled for if no one needs them!")));
        this.inventory.setItem(6, ItemStackGenerator.generateItemStack((Material)Material.GREEN_STAINED_GLASS_PANE, (String)ChatColorConverter.convert((String)"&2Need Item List"), List.of("Click to move to the Greed item list!", "Items in the need list will only", "be rolled for people who needed them!")));
        playerLoot.put(player.getUniqueId(), this);
    }

    public static void shutdown() {
        playerLoot.clear();
    }

    public static void openMenu(Player player) {
        LootMenu lootMenu = playerLoot.get(player.getUniqueId());
        if (lootMenu == null) {
            player.sendMessage(ChatColorConverter.convert((String)"&4[EliteMobs] &6You don't currently have any group loot to vote on!"));
            return;
        }
        player.openInventory(lootMenu.renderMenu());
    }

    private Inventory renderMenu() {
        greedSlots.forEach(slot -> this.inventory.setItem(slot.intValue(), null));
        needSlots.forEach(slot -> this.inventory.setItem(slot.intValue(), null));
        int greedIndex = 0;
        ArrayList<ItemStack> greedItems = new ArrayList<ItemStack>(this.sharedLootTable.getLoot());
        greedItems.removeAll(this.playerTable.getNeedItems());
        for (ItemStack greedItem : greedItems) {
            if (greedIndex >= greedSlots.size()) break;
            this.inventory.setItem(greedSlots.get(greedIndex).intValue(), greedItem);
            ++greedIndex;
        }
        int needIndex = 0;
        for (ItemStack needItem : this.playerTable.getNeedItems()) {
            if (needIndex >= needSlots.size()) break;
            this.inventory.setItem(needSlots.get(needIndex).intValue(), needItem);
            ++needIndex;
        }
        return this.inventory;
    }

    public void removeMenu() {
        LootMenu lootMenu = playerLoot.get(this.player.getUniqueId());
        if (lootMenu == this) {
            if (this.player.isOnline() && this.player.getOpenInventory().getTopInventory().equals(lootMenu.getInventory())) {
                this.player.closeInventory();
            }
            playerLoot.remove(this.player.getUniqueId());
        }
    }

    @Generated
    public static HashMap<UUID, LootMenu> getPlayerLoot() {
        return playerLoot;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    public static class LootMenuEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onInventoryInteract(InventoryClickEvent event) {
            Player player = ((Player)event.getWhoClicked()).getPlayer();
            LootMenu lootMenu = playerLoot.get(player.getUniqueId());
            if (lootMenu == null) {
                return;
            }
            if (!lootMenu.inventory.equals(event.getInventory())) {
                return;
            }
            event.setCancelled(true);
            if (EliteMenu.isBottomMenu(event)) {
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getType().equals((Object)Material.AIR)) {
                return;
            }
            lootMenu.renderMenu();
            int slot = event.getSlot();
            if (greedSlots.contains(slot)) {
                lootMenu.playerTable.addNeed(event.getCurrentItem());
                LootMenu.openMenu(player);
            } else if (needSlots.contains(slot)) {
                lootMenu.playerTable.removeNeed(event.getCurrentItem());
                LootMenu.openMenu(player);
            }
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            playerLoot.remove(event.getPlayer().getUniqueId());
        }
    }
}

