/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.potioneffects;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import com.magmaguy.elitemobs.items.potioneffects.custom.Harm;
import com.magmaguy.elitemobs.items.potioneffects.custom.Heal;
import com.magmaguy.elitemobs.items.potioneffects.custom.Saturation;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.utils.EntityFinder;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerPotionEffects
implements Listener {
    public PlayerPotionEffects() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (ElitePlayerInventory.playerInventories.get(player.getUniqueId()) == null || PlayerData.getPlayerData(player.getUniqueId()) == null) continue;
                    for (ElitePotionEffect elitePotionEffect : ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getContinuousPotionEffects(true)) {
                        PlayerPotionEffects.this.doContinuousPotionEffect(elitePotionEffect, player);
                    }
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 20L, 20L);
    }

    public static void addOnHitCooldown(final Set<UUID> cooldownList, Player player, long delay) {
        final UUID playerUUID = player.getUniqueId();
        cooldownList.add(playerUUID);
        new BukkitRunnable(){

            public void run() {
                cooldownList.remove(playerUUID);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, delay);
    }

    private void doContinuousPotionEffect(ElitePotionEffect elitePotionEffect, Player player) {
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.ABSORPTION)) {
            return;
        }
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.HEALTH_BOOST)) {
            return;
        }
        if (player.hasPotionEffect(elitePotionEffect.getPotionEffect().getType()) && player.getPotionEffect(elitePotionEffect.getPotionEffect().getType()).getAmplifier() > elitePotionEffect.getPotionEffect().getAmplifier()) {
            return;
        }
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.INSTANT_HEALTH)) {
            Heal.doHeal(player, elitePotionEffect);
            return;
        }
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.SATURATION)) {
            Saturation.doSaturation(player, elitePotionEffect);
            return;
        }
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.INSTANT_DAMAGE)) {
            Harm.doHarm(player, elitePotionEffect);
            return;
        }
        if (player.hasPotionEffect(elitePotionEffect.getPotionEffect().getType())) {
            player.removePotionEffect(elitePotionEffect.getPotionEffect().getType());
        }
        player.addPotionEffect(elitePotionEffect.getPotionEffect());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerHitWithPotionEffect(EntityDamageByEntityEvent event) {
        LivingEntity damager = EntityFinder.getRealDamager(event);
        if (damager == null || !damager.getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Player player = (Player)damager;
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (ElitePlayerInventory.playerInventories.get(player.getUniqueId()) == null) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity damagee = (LivingEntity)event.getEntity();
        for (ElitePotionEffect elitePotionEffect : ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getOnHitPotionEffects(true)) {
            this.doOnHitPotionEffect(elitePotionEffect, player, damagee);
        }
    }

    private void doOnHitPotionEffect(ElitePotionEffect elitePotionEffect, Player player, LivingEntity damagee) {
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.ABSORPTION)) {
            return;
        }
        if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.HEALTH_BOOST)) {
            return;
        }
        switch (elitePotionEffect.getTarget()) {
            case SELF: {
                if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.INSTANT_HEALTH)) {
                    Heal.doHeal(player, elitePotionEffect);
                    break;
                }
                if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.SATURATION)) {
                    Saturation.doSaturation(player, elitePotionEffect);
                    break;
                }
                if (elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.INSTANT_DAMAGE)) {
                    Harm.doHarm(player, elitePotionEffect);
                    return;
                }
                player.addPotionEffect(elitePotionEffect.getPotionEffect());
                break;
            }
            case TARGET: {
                EliteEntity eliteEntity;
                if ((elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.LEVITATION) || elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.SLOWNESS) || elitePotionEffect.getPotionEffect().getType().equals(PotionEffectType.BLINDNESS)) && (eliteEntity = EntityTracker.getEliteMobEntity((Entity)damagee)) != null && eliteEntity.getHealthMultiplier() > 1.0) {
                    return;
                }
                damagee.addPotionEffect(elitePotionEffect.getPotionEffect());
            }
        }
    }
}

