/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.potioneffects;

import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ElitePotionEffectContainer {
    public ElitePotionEffectContainer(ItemMeta itemMeta, List<String> potionEffects) {
        if (potionEffects.isEmpty()) {
            return;
        }
        StringBuilder onHit = new StringBuilder();
        StringBuilder continuous = new StringBuilder();
        block3: for (String substring : potionEffects) {
            ElitePotionEffect elitePotionEffect = new ElitePotionEffect(substring);
            switch (elitePotionEffect.getApplicationMethod()) {
                case ONHIT: {
                    onHit.append(substring).append(":");
                    continue block3;
                }
            }
            continuous.append(substring).append(":");
        }
        if (onHit.length() > 0) {
            itemMeta.getPersistentDataContainer().set(ItemTagger.onHitPotionEffectKey, PersistentDataType.STRING, (Object)onHit.toString());
        }
        if (continuous.length() > 0) {
            itemMeta.getPersistentDataContainer().set(ItemTagger.continuousPotionEffectKey, PersistentDataType.STRING, (Object)continuous.toString());
        }
    }

    public static ArrayList<ElitePotionEffect> getElitePotionEffectContainer(ItemMeta itemMeta, NamespacedKey namespacedKey) {
        if (itemMeta == null) {
            return new ArrayList<ElitePotionEffect>();
        }
        if (!itemMeta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.STRING)) {
            return new ArrayList<ElitePotionEffect>();
        }
        ArrayList<ElitePotionEffect> elitePotionEffects = new ArrayList<ElitePotionEffect>();
        for (String string : ((String)itemMeta.getPersistentDataContainer().get(namespacedKey, PersistentDataType.STRING)).split(":")) {
            if (string.length() <= 0) continue;
            elitePotionEffects.add(new ElitePotionEffect(string));
        }
        return elitePotionEffects;
    }
}

