/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.itemconstructor;

import com.magmaguy.elitemobs.combatsystem.CombatSystem;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.ProceduralItemGenerationSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfigFields;
import com.magmaguy.elitemobs.items.EliteEnchantments;
import com.magmaguy.elitemobs.items.customenchantments.CriticalStrikesEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.HunterEnchantment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentGenerator {
    public static ItemMeta generateEnchantments(ItemMeta itemMeta, HashMap<Enchantment, Integer> enchantmentMap) {
        for (Map.Entry<Enchantment, Integer> entry : enchantmentMap.entrySet()) {
            EnchantmentsConfigFields enchantmentsConfigFields;
            if (entry == null || (enchantmentsConfigFields = EnchantmentsConfig.getEnchantment(entry.getKey().getKey().getKey().toLowerCase(Locale.ROOT) + ".yml")) == null || !enchantmentsConfigFields.isEnabled()) continue;
            if (enchantmentMap.get(entry.getKey()) > entry.getKey().getMaxLevel()) {
                if (EliteEnchantments.isPotentialEliteEnchantment(entry.getKey())) {
                    if (enchantmentMap.get(entry.getKey()) > entry.getKey().getMaxLevel()) {
                        itemMeta.addEnchant(entry.getKey(), entry.getKey().getMaxLevel(), true);
                        continue;
                    }
                    itemMeta.addEnchant(entry.getKey(), enchantmentMap.get(entry.getKey()).intValue(), true);
                    continue;
                }
                itemMeta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
                continue;
            }
            itemMeta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
        }
        return itemMeta;
    }

    public static HashMap<Enchantment, Integer> generateEnchantments(double itemTier, Material material, ItemMeta itemMeta) {
        HashMap<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();
        if ((itemTier -= (double)CombatSystem.getMaterialTier(material)) < 1.0) {
            return enchantmentMap;
        }
        HashMap<Enchantment, Integer> validEnchantments = new HashMap<Enchantment, Integer>();
        switch (material) {
            case TRIDENT: {
                if (ThreadLocalRandom.current().nextDouble() < 0.5) {
                    validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("LOYALTY"));
                } else {
                    validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("CHANNELING"));
                }
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("RIPTIDE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("IMPALING"));
            }
            case DIAMOND_SWORD: 
            case GOLDEN_SWORD: 
            case IRON_SWORD: 
            case STONE_SWORD: 
            case WOODEN_SWORD: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SHARPNESS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BANE_OF_ARTHROPODS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SMITE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FIRE_ASPECT"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("KNOCKBACK"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("LOOTING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SWEEPING_EDGE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                break;
            }
            case BOW: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("POWER"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FLAME"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("INFINITY"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PUNCH"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                break;
            }
            case CROSSBOW: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("POWER"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("QUICK_CHARGE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MULTISHOT"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PIERCING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                break;
            }
            case DIAMOND_PICKAXE: 
            case GOLDEN_PICKAXE: 
            case IRON_PICKAXE: 
            case STONE_PICKAXE: 
            case WOODEN_PICKAXE: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("EFFICIENCY"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                if (ThreadLocalRandom.current().nextDouble() < 0.5) {
                    validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FORTUNE"));
                    break;
                }
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SILK_TOUCH"));
                break;
            }
            case DIAMOND_SHOVEL: 
            case GOLDEN_SHOVEL: 
            case IRON_SHOVEL: 
            case STONE_SHOVEL: 
            case WOODEN_SHOVEL: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("EFFICIENCY"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                if (ThreadLocalRandom.current().nextDouble() < 0.5) {
                    validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FORTUNE"));
                    break;
                }
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SILK_TOUCH"));
                break;
            }
            case DIAMOND_HOE: 
            case GOLDEN_HOE: 
            case IRON_HOE: 
            case STONE_HOE: 
            case WOODEN_HOE: {
                if (ItemSettingsConfig.isUseHoesAsWeapons()) {
                    validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SHARPNESS"));
                }
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("EFFICIENCY"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                if (ThreadLocalRandom.current().nextDouble() < 0.5) {
                    validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FORTUNE"));
                    break;
                }
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SILK_TOUCH"));
                break;
            }
            case SHIELD: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                break;
            }
            case DIAMOND_AXE: 
            case GOLDEN_AXE: 
            case IRON_AXE: 
            case STONE_AXE: 
            case WOODEN_AXE: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SHARPNESS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BANE_OF_ARTHROPODS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SMITE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("EFFICIENCY"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FORTUNE"));
                break;
            }
            case CHAINMAIL_HELMET: 
            case DIAMOND_HELMET: 
            case GOLDEN_HELMET: 
            case IRON_HELMET: 
            case LEATHER_HELMET: 
            case TURTLE_HELMET: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BINDING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("RESPIRATION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BLAST_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FIRE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROJECTILE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("THORNS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("AQUA_AFFINITY"));
                break;
            }
            case CHAINMAIL_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case GOLDEN_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case LEATHER_CHESTPLATE: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BLAST_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FIRE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROJECTILE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("THORNS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                break;
            }
            case CHAINMAIL_LEGGINGS: 
            case DIAMOND_LEGGINGS: 
            case GOLDEN_LEGGINGS: 
            case IRON_LEGGINGS: 
            case LEATHER_LEGGINGS: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BINDING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BLAST_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FIRE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROJECTILE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("THORNS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                break;
            }
            case CHAINMAIL_BOOTS: 
            case DIAMOND_BOOTS: 
            case GOLDEN_BOOTS: 
            case IRON_BOOTS: 
            case LEATHER_BOOTS: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BINDING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("BLAST_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FEATHER_FALLING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FIRE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("PROJECTILE_PROTECTION"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("THORNS"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("DEPTH_STRIDER"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("FROST_WALKER"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("SOUL_SPEED"));
                break;
            }
            case FISHING_ROD: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("LUCK_OF_THE_SEA"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("LURE"));
                break;
            }
            case SHEARS: {
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("EFFICIENCY"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("VANISHING_CURSE"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("MENDING"));
                validEnchantments.putAll(EnchantmentGenerator.validateEnchantments("UNBREAKING"));
            }
        }
        int secondaryEnchantmentTotalParsedLevel = EnchantmentGenerator.totalSecondaryEnchantmentCount(validEnchantments);
        int maxSecondaryEnchantmentLevel = (double)secondaryEnchantmentTotalParsedLevel < itemTier - 2.0 ? secondaryEnchantmentTotalParsedLevel : (int)itemTier;
        int secondaryEnchantmentCount = ThreadLocalRandom.current().nextInt(maxSecondaryEnchantmentLevel + 1);
        if (itemTier < 2.0 || secondaryEnchantmentCount < 1 || validEnchantments.size() == 0) {
            EnchantmentGenerator.generateEnchantments(itemMeta, enchantmentMap);
            return enchantmentMap;
        }
        HashMap validEnchantmentsClone = (HashMap)validEnchantments.clone();
        while (ThreadLocalRandom.current().nextBoolean() && validEnchantments.size() >= 1) {
            int randomIndex = ThreadLocalRandom.current().nextInt(validEnchantments.size());
            ArrayList<Enchantment> enchantmentList = new ArrayList<Enchantment>();
            for (Enchantment enchantment : validEnchantments.keySet()) {
                enchantmentList.add(enchantment);
            }
            Enchantment enchantment = (Enchantment)enchantmentList.get(randomIndex);
            validEnchantments.put(enchantment, validEnchantments.get(enchantment) - 1);
            int finalEnchantLevel = (Integer)validEnchantmentsClone.get(enchantment) - validEnchantments.get(enchantment);
            enchantmentMap.put(enchantment, finalEnchantLevel);
            int newEnchantInt = validEnchantments.get(enchantment);
            if (newEnchantInt == 0) {
                validEnchantments.remove(enchantment);
            }
            --secondaryEnchantmentCount;
        }
        EnchantmentGenerator.generateEnchantments(itemMeta, enchantmentMap);
        return enchantmentMap;
    }

    public static HashMap<String, Integer> generateCustomEnchantments(double itemTier, Material material) {
        HashMap<String, Integer> enchantmentMap = new HashMap<String, Integer>();
        if (itemTier < 1.0) {
            return enchantmentMap;
        }
        HashMap<String, Integer> validSecondaryEnchantments = new HashMap<String, Integer>();
        switch (material) {
            case TRIDENT: 
            case DIAMOND_SWORD: 
            case GOLDEN_SWORD: 
            case IRON_SWORD: 
            case STONE_SWORD: 
            case WOODEN_SWORD: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(CriticalStrikesEnchantment.key));
                break;
            }
            case BOW: 
            case CROSSBOW: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(CriticalStrikesEnchantment.key));
                break;
            }
            case DIAMOND_PICKAXE: 
            case GOLDEN_PICKAXE: 
            case IRON_PICKAXE: 
            case STONE_PICKAXE: 
            case WOODEN_PICKAXE: {
                break;
            }
            case DIAMOND_SHOVEL: 
            case GOLDEN_SHOVEL: 
            case IRON_SHOVEL: 
            case STONE_SHOVEL: 
            case WOODEN_SHOVEL: {
                break;
            }
            case DIAMOND_HOE: 
            case GOLDEN_HOE: 
            case IRON_HOE: 
            case STONE_HOE: 
            case WOODEN_HOE: 
            case SHIELD: {
                break;
            }
            case DIAMOND_AXE: 
            case GOLDEN_AXE: 
            case IRON_AXE: 
            case STONE_AXE: 
            case WOODEN_AXE: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(CriticalStrikesEnchantment.key));
                break;
            }
            case CHAINMAIL_HELMET: 
            case DIAMOND_HELMET: 
            case GOLDEN_HELMET: 
            case IRON_HELMET: 
            case LEATHER_HELMET: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(HunterEnchantment.key));
                break;
            }
            case CHAINMAIL_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case GOLDEN_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case LEATHER_CHESTPLATE: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(HunterEnchantment.key));
                break;
            }
            case CHAINMAIL_LEGGINGS: 
            case DIAMOND_LEGGINGS: 
            case GOLDEN_LEGGINGS: 
            case IRON_LEGGINGS: 
            case LEATHER_LEGGINGS: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(HunterEnchantment.key));
                break;
            }
            case CHAINMAIL_BOOTS: 
            case DIAMOND_BOOTS: 
            case GOLDEN_BOOTS: 
            case IRON_BOOTS: 
            case LEATHER_BOOTS: {
                validSecondaryEnchantments.putAll(EnchantmentGenerator.validateSecondaryCustomEnchantments(HunterEnchantment.key));
                break;
            }
            case FISHING_ROD: {
                break;
            }
        }
        int secondaryEnchantmentTotalParsedLevel = EnchantmentGenerator.totalEnchantmentCount(validSecondaryEnchantments);
        if (itemTier < 2.0 || secondaryEnchantmentTotalParsedLevel < 1 || validSecondaryEnchantments.size() == 0) {
            return enchantmentMap;
        }
        if (ThreadLocalRandom.current().nextDouble() > ProceduralItemGenerationSettingsConfig.getCustomEnchantmentChance()) {
            return enchantmentMap;
        }
        return validSecondaryEnchantments;
    }

    private static HashMap<Enchantment, Integer> validateEnchantments(String string) {
        EnchantmentsConfigFields enchantmentsConfigFields = EnchantmentsConfig.getEnchantment(string.toLowerCase(Locale.ROOT) + ".yml");
        if (enchantmentsConfigFields == null || !enchantmentsConfigFields.isEnabled() || !enchantmentsConfigFields.isEnabledForProcedurallyGeneratedItems()) {
            return new HashMap<Enchantment, Integer>();
        }
        HashMap<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();
        if ((string.equalsIgnoreCase("VANISHING_CURSE") || string.equalsIgnoreCase("BINDING_CURSE")) && ThreadLocalRandom.current().nextDouble() < 0.5) {
            return enchantmentMap;
        }
        if (enchantmentsConfigFields != null && enchantmentsConfigFields.isEnabled()) {
            Enchantment enchantment = enchantmentsConfigFields.getEnchantment();
            enchantmentMap.put(enchantment, enchantmentsConfigFields.getMaxLevel());
        }
        return enchantmentMap;
    }

    private static HashMap<String, Integer> validateSecondaryCustomEnchantments(String string) {
        EnchantmentsConfigFields enchantmentsConfigFields = EnchantmentsConfig.getEnchantment(string.toLowerCase(Locale.ROOT) + ".yml");
        if (enchantmentsConfigFields == null || !enchantmentsConfigFields.isEnabled() || !enchantmentsConfigFields.isEnabledForProcedurallyGeneratedItems()) {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> enchantmentMap = new HashMap<String, Integer>();
        if (enchantmentsConfigFields != null && enchantmentsConfigFields.isEnabled()) {
            enchantmentMap.put(string, ThreadLocalRandom.current().nextInt(enchantmentsConfigFields.getMaxLevel()) + 1);
        }
        return enchantmentMap;
    }

    private static int totalSecondaryEnchantmentCount(HashMap<Enchantment, Integer> validEnchantments) {
        int totalCount = 0;
        for (Enchantment enchantment : validEnchantments.keySet()) {
            totalCount += validEnchantments.get(enchantment).intValue();
        }
        return totalCount;
    }

    private static int totalEnchantmentCount(HashMap<String, Integer> validEnchantments) {
        int totalCount = 0;
        for (String enchantment : validEnchantments.keySet()) {
            totalCount += validEnchantments.get(enchantment).intValue();
        }
        return totalCount;
    }
}

