/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.itemconstructor;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.CustomModelsConfig;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import com.magmaguy.elitemobs.versionnotifier.VersionChecker;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class EliteItemSkins {
    private static final NavigableMap<Integer, SkinTier> TIER_THRESHOLDS = new TreeMap<Integer, SkinTier>();
    private static final double NETHERITE_SWORD_DAMAGE = 8.0;
    private static final double NETHERITE_AXE_DAMAGE = 10.0;
    private static final double NETHERITE_HOE_DAMAGE = 1.0;
    private static final double SWORD_ATTACK_SPEED = 1.6;
    private static final double AXE_ATTACK_SPEED = 1.0;
    private static final double HOE_ATTACK_SPEED = 4.0;
    private static final double NETHERITE_HELMET_ARMOR = 3.0;
    private static final double NETHERITE_CHESTPLATE_ARMOR = 8.0;
    private static final double NETHERITE_LEGGINGS_ARMOR = 6.0;
    private static final double NETHERITE_BOOTS_ARMOR = 3.0;
    private static final double NETHERITE_ARMOR_TOUGHNESS = 3.0;
    private static final double NETHERITE_KNOCKBACK_RESISTANCE = 0.1;
    private static final double MAX_TOTAL_ARMOR = 30.0;
    private static final double MAX_TOTAL_TOUGHNESS = 20.0;
    private static final double MAX_KNOCKBACK_RESISTANCE = 1.0;
    private static final double MAX_ATTACK_SPEED_MULTIPLIER = 0.2;

    private static void registerTier(int minLevel, SkinTier tier) {
        TIER_THRESHOLDS.put(minLevel, tier);
    }

    public static SkinTier getSkinTier(int level) {
        Map.Entry<Integer, SkinTier> entry = TIER_THRESHOLDS.floorEntry(level);
        return entry != null ? entry.getValue() : SkinTier.NONE;
    }

    public static int getTierMinLevel(SkinTier tier) {
        if (tier == SkinTier.NONE) {
            return -1;
        }
        for (Map.Entry entry : TIER_THRESHOLDS.entrySet()) {
            if (entry.getValue() != tier) continue;
            return (Integer)entry.getKey();
        }
        return -1;
    }

    public static String getItemModelId(Material material, int level) {
        SkinTier tier = EliteItemSkins.getSkinTier(level);
        if (!tier.hasCustomAssets()) {
            return null;
        }
        ItemType itemType = ItemType.fromMaterial(material);
        if (itemType == null || !itemType.hasItemModel()) {
            return null;
        }
        return EliteItemSkins.buildItemModelId(tier, itemType);
    }

    public static String getEquipmentModelId(Material material, int level) {
        SkinTier tier = EliteItemSkins.getSkinTier(level);
        if (!tier.hasCustomAssets()) {
            return null;
        }
        ItemType itemType = ItemType.fromMaterial(material);
        if (itemType == null || !itemType.hasEquipmentModel()) {
            return null;
        }
        return EliteItemSkins.buildEquipmentModelId(tier);
    }

    private static String buildItemModelId(SkinTier tier, ItemType itemType) {
        return "elitemobs:equipment/" + tier.getId() + "_" + itemType.getModelName();
    }

    private static String buildEquipmentModelId(SkinTier tier) {
        return "elitemobs:" + tier.getId();
    }

    public static void applyLevelBasedSkin(ItemStack itemStack, int level) {
        if (itemStack == null) {
            return;
        }
        Material material = itemStack.getType();
        String itemModelId = EliteItemSkins.getItemModelId(material, level);
        String equipmentModelId = EliteItemSkins.getEquipmentModelId(material, level);
        if (itemModelId != null) {
            CustomModelAdder.addCustomModel(itemStack, itemModelId);
        }
        if (equipmentModelId != null) {
            CustomModelAdder.addEquippableModel(itemStack, equipmentModelId);
        }
        EliteItemSkins.applyAttributeScaling(itemStack, level);
    }

    public static void applySkinTier(ItemStack itemStack, SkinTier tier) {
        int tierLevel;
        if (itemStack == null || !tier.hasCustomAssets()) {
            return;
        }
        Material material = itemStack.getType();
        ItemType itemType = ItemType.fromMaterial(material);
        if (itemType == null) {
            return;
        }
        if (itemType.hasItemModel()) {
            String itemModelId = EliteItemSkins.buildItemModelId(tier, itemType);
            CustomModelAdder.addCustomModel(itemStack, itemModelId);
        }
        if (itemType.hasEquipmentModel()) {
            String equipmentModelId = EliteItemSkins.buildEquipmentModelId(tier);
            CustomModelAdder.addEquippableModel(itemStack, equipmentModelId);
        }
        if ((tierLevel = EliteItemSkins.getTierMinLevel(tier)) > 0) {
            EliteItemSkins.applyAttributeScaling(itemStack, tierLevel);
        }
    }

    public static boolean isSupportedMaterial(Material material) {
        return ItemType.fromMaterial(material) != null;
    }

    public static boolean wouldApplySkin(Material material, int level) {
        return EliteItemSkins.getItemModelId(material, level) != null || EliteItemSkins.getEquipmentModelId(material, level) != null;
    }

    public static String getTierDisplayName(int level) {
        SkinTier tier = EliteItemSkins.getSkinTier(level);
        if (tier == SkinTier.NONE) {
            return "None";
        }
        String id = tier.getId();
        return id.substring(0, 1).toUpperCase() + id.substring(1);
    }

    public static void applyAttributeScaling(ItemStack itemStack, int level) {
        if (itemStack == null || level < 1) {
            return;
        }
        if (!CustomModelsConfig.useAttributeScaling) {
            return;
        }
        if (VersionChecker.serverVersionOlderThan(21, 2)) {
            return;
        }
        Material material = itemStack.getType();
        ItemType itemType = ItemType.fromMaterial(material);
        if (itemType == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return;
        }
        double levelMultiplier = (double)level / 100.0;
        switch (itemType) {
            case SWORD: {
                EliteItemSkins.applyWeaponAttributes(meta, 8.0, 1.6, levelMultiplier, EquipmentSlotGroup.MAINHAND);
                break;
            }
            case AXE: {
                EliteItemSkins.applyWeaponAttributes(meta, 10.0, 1.0, levelMultiplier, EquipmentSlotGroup.MAINHAND);
                break;
            }
            case SCYTHE: {
                EliteItemSkins.applyWeaponAttributes(meta, 1.0, 4.0, levelMultiplier, EquipmentSlotGroup.MAINHAND);
                break;
            }
            case HELMET: {
                EliteItemSkins.applyArmorAttributes(meta, 3.0, levelMultiplier, EquipmentSlotGroup.HEAD);
                break;
            }
            case CHESTPLATE: {
                EliteItemSkins.applyArmorAttributes(meta, 8.0, levelMultiplier, EquipmentSlotGroup.CHEST);
                break;
            }
            case LEGGINGS: {
                EliteItemSkins.applyArmorAttributes(meta, 6.0, levelMultiplier, EquipmentSlotGroup.LEGS);
                break;
            }
            case BOOTS: {
                EliteItemSkins.applyArmorAttributes(meta, 3.0, levelMultiplier, EquipmentSlotGroup.FEET);
                break;
            }
        }
        itemStack.setItemMeta(meta);
    }

    private static void applyWeaponAttributes(ItemMeta meta, double baseDamage, double baseSpeed, double levelMultiplier, EquipmentSlotGroup slot) {
        double scaledDamage = baseDamage * (1.0 + levelMultiplier);
        double speedMultiplier = Math.min(levelMultiplier * 0.1, 0.2);
        double scaledSpeed = baseSpeed * (1.0 + speedMultiplier);
        meta.addAttributeModifier(Attribute.ATTACK_DAMAGE, new AttributeModifier(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "elite_damage"), scaledDamage - 1.0, AttributeModifier.Operation.ADD_NUMBER, slot));
        meta.addAttributeModifier(Attribute.ATTACK_SPEED, new AttributeModifier(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "elite_speed"), scaledSpeed - 4.0, AttributeModifier.Operation.ADD_NUMBER, slot));
    }

    private static void applyArmorAttributes(ItemMeta meta, double baseArmor, double levelMultiplier, EquipmentSlotGroup slot) {
        double scaledArmor = baseArmor * (1.0 + levelMultiplier * 0.5);
        double scaledToughness = 3.0 * (1.0 + levelMultiplier * 0.67);
        double scaledKnockbackResist = Math.min(0.1 * (1.0 + levelMultiplier), 0.25);
        meta.addAttributeModifier(Attribute.ARMOR, new AttributeModifier(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "elite_armor"), scaledArmor, AttributeModifier.Operation.ADD_NUMBER, slot));
        meta.addAttributeModifier(Attribute.ARMOR_TOUGHNESS, new AttributeModifier(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "elite_toughness"), scaledToughness, AttributeModifier.Operation.ADD_NUMBER, slot));
        meta.addAttributeModifier(Attribute.KNOCKBACK_RESISTANCE, new AttributeModifier(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "elite_knockback_resist"), scaledKnockbackResist, AttributeModifier.Operation.ADD_NUMBER, slot));
    }

    static {
        EliteItemSkins.registerTier(20, SkinTier.BRONZE);
        EliteItemSkins.registerTier(50, SkinTier.PALLADIUM);
        EliteItemSkins.registerTier(100, SkinTier.CORRUPTED);
        EliteItemSkins.registerTier(150, SkinTier.LIVING);
        EliteItemSkins.registerTier(200, SkinTier.ULTIMATIUM);
    }

    public static enum SkinTier {
        NONE(null),
        BRONZE("bronze"),
        PALLADIUM("palladium"),
        CORRUPTED("corrupted"),
        LIVING("living"),
        ULTIMATIUM("ultimatium");

        private final String id;

        private SkinTier(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean hasCustomAssets() {
            return this.id != null;
        }
    }

    public static enum ItemType {
        HELMET("_HELMET", "helmet", true, true),
        CHESTPLATE("_CHESTPLATE", "chestplate", true, true),
        LEGGINGS("_LEGGINGS", "leggings", true, true),
        BOOTS("_BOOTS", "boots", true, true),
        SWORD("_SWORD", "sword", true, false),
        AXE("_AXE", "axe", true, false),
        SCYTHE("_HOE", "scythe", true, false),
        BOW("BOW", "bow", true, false),
        CROSSBOW("CROSSBOW", "crossbow", true, false);

        private final String materialSuffix;
        private final String modelName;
        private final boolean hasItemModel;
        private final boolean hasEquipmentModel;

        private ItemType(String materialSuffix, String modelName, boolean hasItemModel, boolean hasEquipmentModel) {
            this.materialSuffix = materialSuffix;
            this.modelName = modelName;
            this.hasItemModel = hasItemModel;
            this.hasEquipmentModel = hasEquipmentModel;
        }

        public static ItemType fromMaterial(Material material) {
            String name = material.name();
            for (ItemType type : ItemType.values()) {
                if (!(type == BOW || type == CROSSBOW ? name.equals(type.materialSuffix) : name.endsWith(type.materialSuffix))) continue;
                return type;
            }
            return null;
        }

        public String getModelName() {
            return this.modelName;
        }

        public boolean hasItemModel() {
            return this.hasItemModel;
        }

        public boolean hasEquipmentModel() {
            return this.hasEquipmentModel;
        }
    }
}

