/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.enchantments.premade.EarthquakeConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EarthquakeEnchantment
extends CustomEnchantment {
    public static String key = "earthquake";

    public EarthquakeEnchantment() {
        super(key, false);
    }

    public static void doEarthquakeEnchantment(int earthquakeLevel, Player player) {
        player.sendMessage(EarthquakeConfig.getEarthquakeActivationMessage());
        player.setVelocity(player.getLocation().getDirection().normalize().multiply((Math.log((double)earthquakeLevel + 1.0) + 1.0) / 20.0).setY(Math.log((double)earthquakeLevel + 1.0)));
        Bukkit.getScheduler().runTaskTimer((Plugin)MetadataHandler.PLUGIN, task -> {
            player.setFallDistance(0.0f);
            if (!player.isValid() || !player.getLocation().clone().subtract(new Vector(0, 1, 0)).getBlock().isPassable() && player.getLocation().getY() - (double)player.getLocation().getBlock().getY() < 0.1 || !player.getLocation().clone().getBlock().isPassable()) {
                task.cancel();
                EarthquakeEnchantment.doLanding(earthquakeLevel, player);
                return;
            }
            player.getWorld().spawnParticle(Particle.DUST, player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ(), 20, 0.1, 0.1, 0.1, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)ThreadLocalRandom.current().nextInt(80, 100), (int)ThreadLocalRandom.current().nextInt(20, 40), (int)ThreadLocalRandom.current().nextInt(10, 20)), 1.0f));
        }, 5L, 1L);
    }

    public static void doLanding(int level, Player player) {
        double distance = Math.log((double)level + 1.0) * 3.0;
        for (Entity entity : player.getNearbyEntities(distance, distance, distance)) {
            if (!(entity instanceof LivingEntity) || entity.getType().equals((Object)EntityType.PLAYER)) continue;
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(entity);
            if (eliteEntity == null) {
                try {
                    entity.setVelocity(entity.getLocation().subtract(player.getLocation()).toVector().normalize().setY(0.3).multiply(distance / 2.0));
                }
                catch (Exception exception) {}
                continue;
            }
            entity.setVelocity(entity.getLocation().subtract(player.getLocation()).toVector().normalize().setY(0.3).multiply(distance / 2.0 / ((double)eliteEntity.getLevel() * eliteEntity.getHealthMultiplier())));
        }
    }

    public static class EarthquakeEnchantmentEvents
    implements Listener {
        private static final HashSet<UUID> players = new HashSet();
        private static final HashSet<UUID> cooldownPlayers = new HashSet();

        public static void shutdown() {
            players.clear();
            cooldownPlayers.clear();
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onSneak(PlayerToggleSneakEvent event) {
            if (!event.isSneaking()) {
                return;
            }
            if (event.getPlayer().isFlying()) {
                return;
            }
            if (cooldownPlayers.contains(event.getPlayer().getUniqueId())) {
                return;
            }
            if (ElitePlayerInventory.playerInventories.get(event.getPlayer().getUniqueId()) == null) {
                return;
            }
            double earthquakeLevel = ElitePlayerInventory.playerInventories.get(event.getPlayer().getUniqueId()).getEarthquakeLevel(true);
            if (earthquakeLevel < 1.0) {
                return;
            }
            if (!players.contains(event.getPlayer().getUniqueId())) {
                players.add(event.getPlayer().getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, task -> players.remove(event.getPlayer().getUniqueId()), 10L);
                return;
            }
            players.remove(event.getPlayer().getUniqueId());
            cooldownPlayers.add(event.getPlayer().getUniqueId());
            Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, task -> {
                event.getPlayer().sendMessage(EarthquakeConfig.getEarthquakeAvailableMessage());
                cooldownPlayers.remove(event.getPlayer().getUniqueId());
            }, 2400L);
            EarthquakeEnchantment.doEarthquakeEnchantment((int)earthquakeLevel, event.getPlayer());
        }
    }
}

