/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfigFields;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CriticalStrikesEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.DrillingEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.EarthquakeEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.EnchantedSourceEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.FlamethrowerEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.GrapplingHookEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.HunterEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.IceBreakerEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.LightningEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.LoudStrikesEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.LuckySourceEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.MeteorShowerEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.PlasmaBootsEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.RepairEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.SummonMerchantEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.SummonWolfEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.UnbindEnchantment;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class CustomEnchantment {
    private static final HashMap<String, CustomEnchantment> customEnchantmentMap = new HashMap();
    public final String key;
    private final boolean dynamic;
    private final EnchantmentsConfigFields enchantmentsConfigFields;
    private final Enchantment originalEnchantment = null;

    public CustomEnchantment(String key, boolean dynamic) {
        this.key = key;
        this.dynamic = dynamic;
        this.enchantmentsConfigFields = EnchantmentsConfig.getEnchantment(key + ".yml");
        customEnchantmentMap.put(this.enchantmentsConfigFields.getFilename(), this);
    }

    public static void initializeCustomEnchantments() {
        new FlamethrowerEnchantment();
        new PlasmaBootsEnchantment();
        new HunterEnchantment();
        new CriticalStrikesEnchantment();
        new DrillingEnchantment();
        new IceBreakerEnchantment();
        new MeteorShowerEnchantment();
        new SummonMerchantEnchantment();
        new SummonWolfEnchantment();
        new UnbindEnchantment();
        new LightningEnchantment();
        new GrapplingHookEnchantment();
        new EarthquakeEnchantment();
        new LoudStrikesEnchantment();
        new RepairEnchantment();
        new LuckySourceEnchantment();
        new EnchantedSourceEnchantment();
    }

    public static boolean isCustomEnchantment(String enchantmentFilename) {
        for (CustomEnchantment customEnchantment : customEnchantmentMap.values()) {
            if (!customEnchantment.getKey().equalsIgnoreCase(enchantmentFilename)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCustomEnchantment(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        if (!itemStack.getItemMeta().hasLore()) {
            return false;
        }
        return CustomEnchantment.hasCustomEnchantment(itemStack.getItemMeta(), key);
    }

    public static boolean hasCustomEnchantment(ItemMeta itemMeta, String key) {
        return ItemTagger.getEnchantment(itemMeta, new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key)) > 0;
    }

    public static int getCustomEnchantmentLevel(ItemStack itemStack, String key) {
        if (itemStack == null) {
            return 0;
        }
        return ItemTagger.getEnchantment(itemStack.getItemMeta(), new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key));
    }

    public String getKey() {
        return this.key;
    }

    public EnchantmentsConfigFields getEnchantmentsConfigFields() {
        return this.enchantmentsConfigFields;
    }

    @Generated
    public static HashMap<String, CustomEnchantment> getCustomEnchantmentMap() {
        return customEnchantmentMap;
    }
}

