/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced.dungeons;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.DungeonCompleteEvent;
import com.magmaguy.elitemobs.api.DungeonStartEvent;
import com.magmaguy.elitemobs.api.InstancedDungeonRemoveEvent;
import com.magmaguy.elitemobs.api.WorldInstanceEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.DungeonsConfig;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfig;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.utility.DungeonUtils;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.WorldOperationQueue;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonObjective;
import com.magmaguy.elitemobs.instanced.dungeons.EnchantmentDungeonInstance;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.treasurechest.TreasureChest;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.elitemobs.utils.WorldInstantiator;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.TemporaryWorldManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DungeonInstance
extends MatchInstance {
    private static final Set<DungeonInstance> dungeonInstances = new HashSet<DungeonInstance>();
    private final List<DungeonObjective> dungeonObjectives = new ArrayList<DungeonObjective>();
    private World world;
    private String instancedWorldName;
    private ContentPackagesConfigFields contentPackagesConfigFields;
    private List<InstancedBossEntity> instancedBossEntities = new ArrayList<InstancedBossEntity>();
    private int levelSync = -1;
    private String rawLevelSync = null;
    private String difficultyName = null;
    private String difficultyID = null;

    public static void shutdown() {
        dungeonInstances.clear();
    }

    public DungeonInstance(ContentPackagesConfigFields contentPackagesConfigFields, Location lobbyLocation, Location startLocation, World world, Player player, String difficultyName) {
        super(startLocation, null, contentPackagesConfigFields.getMinPlayerCount(), contentPackagesConfigFields.getMaxPlayerCount());
        if (this.cancelled) {
            return;
        }
        this.lobbyLocation = lobbyLocation;
        this.contentPackagesConfigFields = contentPackagesConfigFields;
        for (String rawObjective : contentPackagesConfigFields.getRawDungeonObjectives()) {
            this.dungeonObjectives.add(DungeonObjective.registerObjective(this, rawObjective));
        }
        this.world = world;
        this.instancedWorldName = world.getName();
        this.difficultyName = difficultyName;
        this.setDifficulty(difficultyName);
        this.addNewPlayer(player);
        new InitializeEntitiesTask(this, contentPackagesConfigFields, world).runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
        dungeonInstances.add(this);
        this.permission = contentPackagesConfigFields.getPermission();
    }

    public static void setupInstancedDungeon(Player player, String instancedDungeonConfigFieldsString, String difficultyName) {
        ContentPackagesConfigFields instancedDungeonsConfigFields = ContentPackagesConfig.getDungeonPackages().get(instancedDungeonConfigFieldsString);
        if (instancedDungeonsConfigFields == null) {
            player.sendMessage("[EliteMobs] Failed to get data for dungeon " + instancedDungeonConfigFieldsString + "! The dungeon will not start.");
            return;
        }
        if (instancedDungeonsConfigFields.getPermission() != null && !instancedDungeonsConfigFields.getPermission().isEmpty() && !player.hasPermission(instancedDungeonsConfigFields.getPermission())) {
            player.sendMessage("[EliteMobs] You don't have the permission to go to this dungeon!");
            return;
        }
        String instancedWorldName = WorldInstantiator.getNewWorldName(instancedDungeonsConfigFields.getWorldName());
        if (!DungeonInstance.launchEvent(instancedDungeonsConfigFields, instancedWorldName, player)) {
            return;
        }
        WorldOperationQueue.queueOperation(player, () -> DungeonInstance.cloneWorldFiles(instancedDungeonsConfigFields, instancedWorldName, player) != null, () -> DungeonInstance.initializeInstancedWorld(instancedDungeonsConfigFields, instancedWorldName, player, difficultyName), instancedDungeonsConfigFields.getName());
    }

    protected static boolean launchEvent(ContentPackagesConfigFields instancedDungeonsConfigFields, String instancedWordName, Player player) {
        WorldInstanceEvent worldInstanceEvent = new WorldInstanceEvent(instancedDungeonsConfigFields.getWorldName(), instancedWordName, instancedDungeonsConfigFields);
        new EventCaller(worldInstanceEvent);
        if (worldInstanceEvent.isCancelled()) {
            player.sendMessage("[EliteMobs] Something cancelled the instancing event! The dungeon will not start.");
            return false;
        }
        return true;
    }

    protected static File cloneWorldFiles(ContentPackagesConfigFields instancedDungeonsConfigFields, String instancedWordName, Player player) {
        File targetFile = WorldInstantiator.cloneWorld(instancedDungeonsConfigFields.getWorldName(), instancedWordName, instancedDungeonsConfigFields.getDungeonConfigFolderName());
        if (targetFile == null) {
            player.sendMessage("[EliteMobs] Failed to copy the world! Report this to the dev. The dungeon will not start.");
            return null;
        }
        return targetFile;
    }

    protected static DungeonInstance initializeInstancedWorld(ContentPackagesConfigFields instancedDungeonsConfigFields, String instancedWordName, Player player, String difficultyName) {
        World world = DungeonUtils.loadWorld(instancedWordName, instancedDungeonsConfigFields.getEnvironment(), instancedDungeonsConfigFields);
        if (world == null) {
            player.sendMessage("[EliteMobs] Failed to load the world! Report this to the dev. The dungeon will not start.");
            return null;
        }
        Location startLocation = ConfigurationLocation.serialize(instancedDungeonsConfigFields.getStartLocationString());
        startLocation.setWorld(world);
        Location lobbyLocation = ConfigurationLocation.serialize(instancedDungeonsConfigFields.getTeleportLocationString());
        if (lobbyLocation != null) {
            lobbyLocation.setWorld(world);
        } else {
            lobbyLocation = startLocation;
        }
        if (!instancedDungeonsConfigFields.isEnchantmentChallenge()) {
            return new DungeonInstance(instancedDungeonsConfigFields, lobbyLocation, startLocation, world, player, difficultyName);
        }
        return new EnchantmentDungeonInstance(instancedDungeonsConfigFields, lobbyLocation, startLocation, world, player, difficultyName);
    }

    @Override
    public boolean addNewPlayer(Player player) {
        if (!super.addNewPlayer(player)) {
            return false;
        }
        if (this.levelSync > 0) {
            player.sendMessage("[EliteMobs] Dungeon difficulty is set to " + this.difficultyName + " ! Level sync caps your item level to " + this.levelSync + ".");
        }
        return true;
    }

    @Override
    protected void startMatch() {
        this.updateBossHealth();
        super.startMatch();
        new EventCaller(new DungeonStartEvent(this));
    }

    private void updateBossHealth() {
        this.instancedBossEntities.forEach(instancedBossEntity -> instancedBossEntity.setNormalizedMaxHealth(this.players.size()));
    }

    public boolean checkCompletionStatus() {
        for (DungeonObjective dungeonObjective : this.dungeonObjectives) {
            if (dungeonObjective.isCompleted()) continue;
            return false;
        }
        new EventCaller(new DungeonCompleteEvent(this));
        this.victory();
        return true;
    }

    @Override
    public void endMatch() {
        super.endMatch();
        if (this.players.isEmpty()) {
            this.removeInstance();
            return;
        }
        this.announce(DungeonsConfig.getInstancedDungeonCompleteMessage());
        new DestroyMatchTask().runTaskLater((Plugin)MetadataHandler.PLUGIN, 2400L);
    }

    @Override
    public void destroyMatch() {
        super.destroyMatch();
        this.removeInstance();
    }

    public void removeInstance() {
        this.participants.forEach(player -> player.sendMessage(DungeonsConfig.getInstancedDungeonClosingInstanceMessage()));
        HashSet participants = new HashSet(this.participants);
        participants.forEach(this::removeAnyKind);
        instances.remove(this);
        DungeonInstance dungeonInstance = this;
        if (this.world == null) {
            Logger.warn((String)"Instanced dungeon's world was already unloaded before removing the entities in it! This shouldn't happen, but doesn't break anything.");
            return;
        }
        this.world.getEntities().forEach(entity -> EntityTracker.unregister(entity, RemovalReason.WORLD_UNLOAD));
        new RemoveInstanceTask(dungeonInstance).runTaskLater((Plugin)MetadataHandler.PLUGIN, 600L);
    }

    private void setDifficulty(String difficultyName) {
        if (difficultyName == null) {
            return;
        }
        if (this.contentPackagesConfigFields.getDifficulties() == null || this.contentPackagesConfigFields.getDifficulties().isEmpty()) {
            return;
        }
        Map<String, Object> difficulty = null;
        for (Map<String, Object> difficultyMap : this.contentPackagesConfigFields.getDifficulties()) {
            if (difficultyMap.get("name") == null || !difficultyMap.get("name").equals(difficultyName)) continue;
            difficulty = difficultyMap;
            break;
        }
        if (difficulty == null) {
            Logger.warn((String)("Failed to set difficulty " + String.valueOf(difficulty) + " for instanced dungeon " + this.contentPackagesConfigFields.getFilename()));
            return;
        }
        if (difficulty.get("levelSync") != null) {
            try {
                this.rawLevelSync = MapListInterpreter.parseString("levelSync", difficulty.get("levelSync"), this.contentPackagesConfigFields.getFilename());
                this.levelSync = this.parseLevelSync(this.rawLevelSync, this.contentPackagesConfigFields.getContentLevel());
            }
            catch (Exception exception) {
                Logger.warn((String)("Incorrect level sync entry for dungeon " + this.contentPackagesConfigFields.getFilename() + " ! Value: " + this.rawLevelSync + " . No level sync will be applied!"));
                this.levelSync = 0;
            }
        } else {
            this.levelSync = 0;
        }
        if (difficulty.get("id") != null) {
            this.difficultyID = MapListInterpreter.parseString("id", difficulty.get("id"), this.contentPackagesConfigFields.getFilename());
        }
    }

    protected int parseLevelSync(String rawValue, int contentLevel) {
        if (rawValue == null || rawValue.isEmpty()) {
            return 0;
        }
        if ((rawValue = rawValue.trim()).startsWith("+") || rawValue.startsWith("-")) {
            int offset;
            try {
                offset = Integer.parseInt(rawValue);
            }
            catch (NumberFormatException e) {
                Logger.warn((String)("Invalid relative level sync value: " + rawValue));
                return 0;
            }
            if (contentLevel < 0) {
                return 0;
            }
            return Math.max(1, contentLevel + offset);
        }
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            Logger.warn((String)("Invalid level sync value: " + rawValue));
            return 0;
        }
    }

    protected void recalculateLevelSyncForDynamicLevel(int dynamicLevel) {
        if (this.rawLevelSync == null || this.rawLevelSync.isEmpty()) {
            this.levelSync = 0;
            return;
        }
        String trimmed = this.rawLevelSync.trim();
        if (trimmed.startsWith("+") || trimmed.startsWith("-")) {
            try {
                int offset = Integer.parseInt(trimmed);
                this.levelSync = Math.max(1, dynamicLevel + offset);
            }
            catch (NumberFormatException e) {
                this.levelSync = 0;
            }
        }
    }

    protected boolean isRelativeLevelSync() {
        if (this.rawLevelSync == null || this.rawLevelSync.isEmpty()) {
            return false;
        }
        String trimmed = this.rawLevelSync.trim();
        return trimmed.startsWith("+") || trimmed.startsWith("-");
    }

    @Override
    protected boolean isInRegion(Location location) {
        return location.getWorld().equals(this.startLocation.getWorld());
    }

    @Generated
    public static Set<DungeonInstance> getDungeonInstances() {
        return dungeonInstances;
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public String getInstancedWorldName() {
        return this.instancedWorldName;
    }

    @Generated
    public ContentPackagesConfigFields getContentPackagesConfigFields() {
        return this.contentPackagesConfigFields;
    }

    @Generated
    public int getLevelSync() {
        return this.levelSync;
    }

    @Generated
    public String getDifficultyID() {
        return this.difficultyID;
    }

    private class InitializeEntitiesTask
    extends BukkitRunnable {
        private final DungeonInstance dungeonInstance;
        private final ContentPackagesConfigFields contentPackagesConfigFields;
        private final World world;

        public InitializeEntitiesTask(DungeonInstance dungeonInstance2, ContentPackagesConfigFields contentPackagesConfigFields, World world) {
            this.dungeonInstance = dungeonInstance2;
            this.contentPackagesConfigFields = contentPackagesConfigFields;
            this.world = world;
        }

        public void run() {
            DungeonInstance.this.instancedBossEntities = InstancedBossEntity.initializeInstancedBosses(this.contentPackagesConfigFields.getWorldName(), this.world, DungeonInstance.this.players.size(), this.dungeonInstance);
            NPCEntity.initializeInstancedNPCs(this.contentPackagesConfigFields.getWorldName(), this.world, DungeonInstance.this.players.size(), this.dungeonInstance);
            TreasureChest.initializeInstancedTreasureChests(this.contentPackagesConfigFields.getWorldName(), this.world);
        }
    }

    private class DestroyMatchTask
    extends BukkitRunnable {
        private DestroyMatchTask() {
        }

        public void run() {
            DungeonInstance.this.destroyMatch();
        }
    }

    private class RemoveInstanceTask
    extends BukkitRunnable {
        private final DungeonInstance dungeonInstance;

        public RemoveInstanceTask(DungeonInstance dungeonInstance2) {
            this.dungeonInstance = dungeonInstance2;
        }

        public void run() {
            new EventCaller(new InstancedDungeonRemoveEvent(this.dungeonInstance));
            dungeonInstances.remove(this.dungeonInstance);
            TemporaryWorldManager.permanentlyDeleteWorld((World)DungeonInstance.this.world);
        }
    }
}

