/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced.arena;

import com.magmaguy.elitemobs.instanced.arena.ArenaEntity;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ArenaWaves {
    private final HashMap<Integer, List<ArenaEntity>> arenaEntities = new HashMap();

    public ArenaWaves(List<String> rawBosses) {
        for (String iteratedBoss : rawBosses) {
            boolean mythicMob;
            int wave;
            String[] subString = iteratedBoss.split(":");
            String waveString = "";
            String spawnpointString = "";
            String boss = "";
            String mythicMobString = "";
            String levelString = "";
            block21: for (String iteratedString : subString) {
                String[] valuesString = iteratedString.split("=");
                switch (valuesString[0].toLowerCase(Locale.ROOT)) {
                    case "wave": {
                        waveString = valuesString[1];
                        continue block21;
                    }
                    case "spawnpoint": {
                        spawnpointString = valuesString[1];
                        continue block21;
                    }
                    case "boss": {
                        boss = valuesString[1];
                        continue block21;
                    }
                    case "mythicmob": {
                        mythicMobString = valuesString[1];
                        continue block21;
                    }
                    case "level": {
                        levelString = valuesString[1];
                    }
                }
            }
            try {
                wave = Integer.valueOf(waveString);
            }
            catch (Exception exception) {
                Logger.warn((String)("Invalid value for wave in arena wave: " + waveString));
                continue;
            }
            if (mythicMobString.isEmpty()) {
                mythicMob = false;
            } else {
                try {
                    mythicMob = Boolean.valueOf(mythicMobString);
                }
                catch (Exception exception) {
                    Logger.warn((String)("Invalid value for mythic mob in arena wave: " + waveString));
                    continue;
                }
            }
            int level = -1;
            if (!levelString.isEmpty()) {
                try {
                    level = Integer.valueOf(levelString);
                }
                catch (Exception exception) {
                    Logger.warn((String)("Invalid value for level in: " + levelString));
                    continue;
                }
            }
            ArenaEntity arenaEntity = new ArenaEntity(spawnpointString, wave, boss);
            if (mythicMob) {
                arenaEntity.setMythicMob(true);
            }
            if (level != -1) {
                arenaEntity.setLevel(level);
            }
            if (this.arenaEntities.get(wave) == null) {
                this.arenaEntities.put(wave, new ArrayList<ArenaEntity>(List.of(arenaEntity)));
                continue;
            }
            this.arenaEntities.get(wave).add(arenaEntity);
        }
    }

    public List<ArenaEntity> getWaveEntities(int wave) {
        return this.arenaEntities.get(wave);
    }
}

