/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced.arena;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.ArenaCompleteEvent;
import com.magmaguy.elitemobs.api.ArenaStartEvent;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.AdventurersGuildConfig;
import com.magmaguy.elitemobs.config.ArenasConfig;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.customarenas.CustomArenasConfigFields;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.arena.ArenaEntity;
import com.magmaguy.elitemobs.instanced.arena.ArenaWaves;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.thirdparty.mythicmobs.MythicMobsInterface;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.utils.shapes.Cylinder;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ArenaInstance
extends MatchInstance {
    private static final HashMap<String, ArenaInstance> arenaInstances = new HashMap();
    private final HashSet<CustomBossEntity> customBosses = new HashSet();
    private final HashSet<Entity> nonEliteMobsEntities = new HashSet();
    private final HashMap<Integer, String> waveMessage = new HashMap();
    private final HashMap<Player, Double> roundDamage = new HashMap();
    protected HashMap<String, Location> spawnPoints = new HashMap();
    private CustomArenasConfigFields customArenasConfigFields;
    private ArenaWaves arenaWaves;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private boolean cylindricalArena;
    private int currentWave = 0;
    private ArenaState arenaState = ArenaState.IDLE;
    private Cylinder cylinder;
    private int highestArenaMobLevel = -1;

    public static void shutdown() {
        arenaInstances.clear();
    }

    public ArenaInstance(CustomArenasConfigFields customArenasConfigFields, Location corner1, Location corner2, Location startLocation, Location exitLocation) {
        super(startLocation, exitLocation, customArenasConfigFields.getMinimumPlayerCount(), customArenasConfigFields.getMaximumPlayerCount());
        if (this.cancelled) {
            return;
        }
        this.cylindricalArena = customArenasConfigFields.isCylindricalArena();
        this.lobbyLocation = customArenasConfigFields.getTeleportLocation();
        if (corner1.getX() < corner2.getX()) {
            this.minX = (int)corner1.getX();
            this.maxX = (int)corner2.getX();
        } else {
            this.minX = (int)corner2.getX();
            this.maxX = (int)corner1.getX();
        }
        if (corner1.getY() < corner2.getY()) {
            this.minY = (int)corner1.getY();
            this.maxY = (int)corner2.getY();
        } else {
            this.minY = (int)corner2.getY();
            this.maxY = (int)corner1.getY();
        }
        if (corner1.getZ() < corner2.getZ()) {
            this.minZ = (int)corner1.getZ();
            this.maxZ = (int)corner2.getZ();
        } else {
            this.minZ = (int)corner2.getZ();
            this.maxZ = (int)corner1.getZ();
        }
        this.world = corner1.getWorld();
        this.state = MatchInstance.InstancedRegionState.WAITING;
        if (this.cylindricalArena) {
            this.cylinder = new Cylinder(new Vector((double)(this.maxX - this.minX) / 2.0 + (double)this.minX, (double)this.minY, (double)(this.maxZ - this.minZ) / 2.0 + (double)this.minZ), (double)Math.abs(this.maxX - this.minX) / 2.0, this.maxY - this.minY);
        }
        this.addSpawnPoints(customArenasConfigFields.getSpawnPoints());
        this.customArenasConfigFields = customArenasConfigFields;
        this.arenaWaves = new ArenaWaves(customArenasConfigFields.getBossList());
        arenaInstances.put(customArenasConfigFields.getFilename(), this);
        this.arenaWatchdog();
        for (String string : customArenasConfigFields.getArenaMessages()) {
            String[] splitString = string.split(":");
            String message = "";
            int wave = 0;
            block11: for (String subString : splitString) {
                String[] finalString = subString.split("=");
                switch (finalString[0].toLowerCase(Locale.ROOT)) {
                    case "wave": {
                        try {
                            wave = Integer.parseInt(finalString[1]);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("Failed to parse wave for entry " + subString + " for arena " + customArenasConfigFields.getFilename()));
                        }
                        continue block11;
                    }
                    case "message": {
                        message = finalString[1];
                        continue block11;
                    }
                    default: {
                        Logger.warn((String)("Failed to parse arena message entry " + subString + " for arena " + customArenasConfigFields.getFilename()));
                    }
                }
            }
            if (message.isEmpty() || wave <= 0) continue;
            this.waveMessage.put(wave, ChatColorConverter.convert((String)message));
        }
        this.permission = customArenasConfigFields.getPermission();
    }

    public static void initializeArena(CustomArenasConfigFields customArenasConfigFields) {
        Location corner1 = ConfigurationLocation.serialize(customArenasConfigFields.getCorner1());
        Location corner2 = ConfigurationLocation.serialize(customArenasConfigFields.getCorner2());
        Location startLocation = ConfigurationLocation.serialize(customArenasConfigFields.getStartLocation());
        Location exitLocation = ConfigurationLocation.serialize(customArenasConfigFields.getExitLocation());
        if (corner1 == null || corner2 == null || startLocation == null || exitLocation == null) {
            return;
        }
        if (corner1.getWorld() == null || corner2.getWorld() == null || startLocation.getWorld() == null || exitLocation.getWorld() == null) {
            return;
        }
        new ArenaInstance(customArenasConfigFields, corner1, corner2, startLocation, exitLocation);
    }

    public void addSpawnPoints(List<String> rawSpawnPoints) {
        for (String string : rawSpawnPoints) {
            String[] splitEntry = string.split(":");
            String name = "";
            String location = "";
            block9: for (String subString : splitEntry) {
                String[] splitSubEntry = subString.split("=");
                switch (splitSubEntry[0].toLowerCase(Locale.ROOT)) {
                    case "name": {
                        name = splitSubEntry[1];
                        continue block9;
                    }
                    case "location": {
                        location = splitSubEntry[1];
                        continue block9;
                    }
                    default: {
                        Logger.warn((String)("Invalid entry for the spawn points of instanced content: " + splitSubEntry[0]));
                    }
                }
            }
            this.spawnPoints.put(name, ConfigurationLocation.serialize(location));
        }
    }

    @Override
    protected boolean isInRegion(Location location) {
        if (!this.cylindricalArena) {
            return location.getWorld().equals(this.world) && (double)this.minX <= location.getX() && (double)this.maxX >= location.getX() && (double)this.minY <= location.getY() && (double)this.maxY >= location.getY() && (double)this.minZ <= location.getZ() && (double)this.maxZ >= location.getZ();
        }
        return location.getWorld().equals(this.world) && this.cylinder.contains(location);
    }

    @Override
    protected void startMatch() {
        super.startMatch();
        new EventCaller(new ArenaStartEvent(this));
        this.nextWave();
    }

    private void nextWave() {
        ++this.currentWave;
        this.arenaState = ArenaState.COOLDOWN;
        if (this.waveMessage.get(this.currentWave) != null) {
            this.players.forEach(player -> player.sendMessage(this.waveMessage.get(this.currentWave)));
            this.spectators.forEach(player -> player.sendMessage(this.waveMessage.get(this.currentWave)));
        }
        this.doRewards();
        if (this.currentWave > this.customArenasConfigFields.getWaveCount()) {
            this.victory();
            return;
        }
        int delayBetweenWaves = this.customArenasConfigFields.getDelayBetweenWaves();
        if (this.customArenasConfigFields.getIntermissionWaves().contains(this.currentWave)) {
            delayBetweenWaves *= 2;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, () -> {
            if (this.arenaState == ArenaState.IDLE) {
                return;
            }
            String title = ArenasConfig.getWaveTitle();
            String subtitle = ArenasConfig.getWaveSubtitle();
            if (title == null) {
                title = "";
            }
            if (subtitle == null) {
                subtitle = "";
            }
            String finalTitle = title;
            String finalSubtitle = subtitle;
            this.players.forEach(player -> player.sendTitle(finalTitle.replace("$wave", "" + this.currentWave), finalSubtitle.replace("$wave", "" + this.currentWave), 0, 20, 0));
            this.spectators.forEach(player -> player.sendTitle(finalTitle.replace("$wave", "" + this.currentWave), finalSubtitle.replace("$wave", "" + this.currentWave), 0, 20, 0));
            this.spawnBosses();
            this.arenaState = ArenaState.ACTIVE;
            this.roundDamage.clear();
        }, 20L * (long)delayBetweenWaves);
    }

    private void arenaWatchdog() {
        new BukkitRunnable(){

            public void run() {
                if (ArenaInstance.this.arenaState != ArenaState.ACTIVE) {
                    return;
                }
                for (CustomBossEntity customBossEntity : (HashSet)ArenaInstance.this.customBosses.clone()) {
                    if (customBossEntity.exists()) continue;
                    ArenaInstance.this.removeBoss(customBossEntity);
                }
                if (!ArenaInstance.this.nonEliteMobsEntities.isEmpty()) {
                    for (Entity entity : (HashSet)ArenaInstance.this.nonEliteMobsEntities.clone()) {
                        if (entity.isValid()) continue;
                        ArenaInstance.this.removeBoss(entity);
                    }
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
    }

    public void removeBoss(CustomBossEntity customBossEntity) {
        this.customBosses.remove(customBossEntity);
        if (this.customBosses.isEmpty() && this.nonEliteMobsEntities.isEmpty()) {
            this.nextWave();
        }
    }

    public void removeBoss(Entity nonEliteEntity) {
        this.nonEliteMobsEntities.remove(nonEliteEntity);
        if (this.customBosses.isEmpty() && this.nonEliteMobsEntities.isEmpty()) {
            this.nextWave();
        }
    }

    private void spawnBosses() {
        if (this.arenaWaves.getWaveEntities(this.currentWave) == null) {
            return;
        }
        this.highestArenaMobLevel = -1;
        for (ArenaEntity arenaEntity : this.arenaWaves.getWaveEntities(this.currentWave)) {
            if (!arenaEntity.isMythicMob()) {
                CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity(arenaEntity.getBossfile());
                if (customBossEntity == null) {
                    Logger.warn((String)("Failed to generate custom boss " + arenaEntity.getBossfile() + " because the filename was not valid!"));
                    continue;
                }
                customBossEntity.setNormalizedCombat();
                customBossEntity.setEliteLoot(false);
                customBossEntity.setVanillaLoot(false);
                customBossEntity.setRandomLoot(false);
                customBossEntity.spawn(this.spawnPoints.get(arenaEntity.getSpawnPointName()), true);
                if (customBossEntity.getLevel() > this.highestArenaMobLevel) {
                    this.highestArenaMobLevel = customBossEntity.getLevel();
                }
                if (!customBossEntity.exists()) {
                    Logger.warn((String)("Arena " + this.getCustomArenasConfigFields().getArenaName() + " failed to spawn boss " + customBossEntity.getCustomBossesConfigFields().getFilename()));
                    continue;
                }
                this.customBosses.add(customBossEntity);
                continue;
            }
            try {
                Entity mythicMob = MythicMobsInterface.spawn(this.spawnPoints.get(arenaEntity.getSpawnPointName()), arenaEntity.getBossfile(), arenaEntity.getLevel());
                if (mythicMob != null) {
                    this.nonEliteMobsEntities.add(mythicMob);
                    continue;
                }
                Logger.warn((String)("Failed to spawn MythicMobs entity '" + arenaEntity.getBossfile() + "' at spawn point " + arenaEntity.getSpawnPointName() + " with level " + arenaEntity.getLevel() + " because MythicMobs did not recognize the name of the entity!"));
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to spawn MythicMobs entity '" + arenaEntity.getBossfile() + "' at spawn point " + arenaEntity.getSpawnPointName() + " with level " + arenaEntity.getLevel() + " due to a MythicMobs error - there is a high chance mob spawning is being prevented in this area!"));
            }
        }
    }

    private void doRewards() {
        ArrayList<Player> validPlayers = new ArrayList<Player>();
        double minimumDamageThreshold = 0.0;
        double totalDamage = 0.0;
        for (Map.Entry<Player, Double> entry : this.roundDamage.entrySet()) {
            totalDamage += entry.getValue().doubleValue();
        }
        minimumDamageThreshold = totalDamage * 0.1;
        for (Map.Entry<Player, Double> entry : this.roundDamage.entrySet()) {
            if (!(entry.getValue() >= minimumDamageThreshold)) continue;
            validPlayers.add(entry.getKey());
        }
        this.players.forEach(player -> {
            if (this.highestArenaMobLevel > 0) {
                if (AdventurersGuildConfig.isGuildLootLimiter() && PlayerData.getMaxGuildLevel(player.getUniqueId()) < this.highestArenaMobLevel / 10) {
                    Logger.sendSimpleMessage((CommandSender)player, (String)AdventurersGuildConfig.getLootLimiterMessage());
                    return;
                }
                if (Math.abs(ElitePlayerInventory.getPlayer(player).getFullPlayerTier(true) - this.highestArenaMobLevel) > ItemSettingsConfig.getLootLevelDifferenceLockout()) {
                    Logger.sendSimpleMessage((CommandSender)player, (String)ItemSettingsConfig.getLevelRangeTooDifferent().replace("$playerLevel", "" + ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(false)).replace("$bossLevel", "" + this.highestArenaMobLevel));
                    return;
                }
            }
            this.customArenasConfigFields.getArenaRewards().arenaReward((Player)player, this.currentWave - 1);
        });
    }

    @Override
    protected void endMatch() {
        super.endMatch();
        this.arenaState = ArenaState.IDLE;
        if (this.currentWave > this.getCustomArenasConfigFields().getWaveCount()) {
            this.participants.forEach(player -> player.sendTitle(ArenasConfig.getVictoryTitle().replace("$wave", "" + this.customArenasConfigFields.getWaveCount()), ArenasConfig.getVictorySubtitle().replace("$wave", "" + this.customArenasConfigFields.getWaveCount()), 20, 200, 20));
            StringBuilder playerNames = new StringBuilder();
            for (Player player2 : this.participants) {
                playerNames.append(player2.getName()).append(" ");
            }
            Bukkit.getServer().broadcastMessage(ArenasConfig.getVictoryBroadcast().replace("$players", playerNames.toString()).replace("$arenaName", this.customArenasConfigFields.getArenaName()));
            ArenaCompleteEvent.ArenaCompleteEventHandler.call(this);
        } else {
            this.participants.forEach(player -> player.sendTitle(ArenasConfig.getDefeatTitle().replace("$wave", "" + this.currentWave), ArenasConfig.getDefeatSubtitle().replace("$wave", "" + this.currentWave), 20, 200, 20));
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, this::destroyMatch, (long)this.customArenasConfigFields.getDelayBetweenWaves());
    }

    @Override
    protected void destroyMatch() {
        super.destroyMatch();
        this.arenaState = ArenaState.IDLE;
        this.currentWave = 0;
        this.customBosses.forEach(customBoss -> customBoss.remove(RemovalReason.ARENA_RESET));
        this.customBosses.clear();
    }

    @Generated
    public static HashMap<String, ArenaInstance> getArenaInstances() {
        return arenaInstances;
    }

    @Generated
    public HashSet<CustomBossEntity> getCustomBosses() {
        return this.customBosses;
    }

    @Generated
    public HashMap<Player, Double> getRoundDamage() {
        return this.roundDamage;
    }

    @Generated
    public CustomArenasConfigFields getCustomArenasConfigFields() {
        return this.customArenasConfigFields;
    }

    @Generated
    public ArenaWaves getArenaWaves() {
        return this.arenaWaves;
    }

    @Generated
    public int getCurrentWave() {
        return this.currentWave;
    }

    @Generated
    public ArenaState getArenaState() {
        return this.arenaState;
    }

    private static enum ArenaState {
        IDLE,
        COOLDOWN,
        ACTIVE;

    }

    public static class ArenaInstanceEvents
    implements Listener {
        @EventHandler
        public void onEliteDeath(EliteMobDeathEvent event) {
            if (!(event.getEliteEntity() instanceof CustomBossEntity)) {
                return;
            }
            for (ArenaInstance arenaInstance : arenaInstances.values()) {
                if (!arenaInstance.getCustomBosses().contains((CustomBossEntity)event.getEliteEntity())) continue;
                arenaInstance.removeBoss((CustomBossEntity)event.getEliteEntity());
                return;
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onEliteDamages(EliteMobDamagedByPlayerEvent event) {
            if (PlayerData.getMatchInstance(event.getPlayer()) == null) {
                return;
            }
            MatchInstance matchInstance = PlayerData.getMatchInstance(event.getPlayer());
            if (!(matchInstance instanceof ArenaInstance)) {
                return;
            }
            ArenaInstance arenaInstance = (ArenaInstance)matchInstance;
            arenaInstance.getRoundDamage().merge(event.getPlayer(), event.getDamage(), Double::sum);
        }
    }
}

