/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.magmacore.util.Logger;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WorldOperationQueue {
    private static final Queue<WorldOperation> operationQueue = new ConcurrentLinkedQueue<WorldOperation>();
    private static final AtomicBoolean isProcessing = new AtomicBoolean(false);

    public static void queueOperation(Player player, Supplier<Boolean> asyncOperation, Runnable syncOperation, String operationName) {
        WorldOperation operation = new WorldOperation(player, asyncOperation, syncOperation, operationName);
        operationQueue.add(operation);
        int queuePosition = operationQueue.size();
        if (queuePosition > 1) {
            player.sendMessage("[EliteMobs] Preparing your dungeon... (Queue position: " + queuePosition + ")");
        } else {
            player.sendMessage("[EliteMobs] Preparing your dungeon...");
        }
        WorldOperationQueue.processNextOperation();
    }

    private static void processNextOperation() {
        if (!isProcessing.compareAndSet(false, true)) {
            return;
        }
        final WorldOperation operation = operationQueue.poll();
        if (operation == null) {
            isProcessing.set(false);
            return;
        }
        WorldOperationQueue.notifyQueuePositions();
        CompletableFuture.supplyAsync(() -> {
            try {
                return operation.asyncOperation.get();
            }
            catch (Exception e) {
                Logger.warn((String)("World operation failed during async phase: " + e.getMessage()));
                e.printStackTrace();
                return false;
            }
        }).thenAccept(success -> {
            if (!success.booleanValue()) {
                if (operation.player.isOnline()) {
                    operation.player.sendMessage("[EliteMobs] Failed to prepare dungeon. Please try again.");
                }
                isProcessing.set(false);
                WorldOperationQueue.processNextOperation();
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    try {
                        operation.syncOperation.run();
                        isProcessing.set(false);
                    }
                    catch (Exception e) {
                        try {
                            Logger.warn((String)("World operation failed during sync phase: " + e.getMessage()));
                            e.printStackTrace();
                            if (operation.player.isOnline()) {
                                operation.player.sendMessage("[EliteMobs] Failed to load dungeon. Please try again.");
                            }
                            isProcessing.set(false);
                        }
                        catch (Throwable throwable) {
                            isProcessing.set(false);
                            new BukkitRunnable(this){
                                final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                public void run() {
                                    WorldOperationQueue.processNextOperation();
                                }
                            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 10L);
                            throw throwable;
                        }
                        new /* invalid duplicate definition of identical inner class */.runTaskLater((Plugin)MetadataHandler.PLUGIN, 10L);
                    }
                    new /* invalid duplicate definition of identical inner class */.runTaskLater((Plugin)MetadataHandler.PLUGIN, 10L);
                }
            }.runTask((Plugin)MetadataHandler.PLUGIN);
        });
    }

    private static void notifyQueuePositions() {
        int position = 1;
        for (WorldOperation op : operationQueue) {
            if (op.player.isOnline()) {
                op.player.sendMessage("[EliteMobs] Preparing your dungeon... (Queue position: " + position + ")");
            }
            ++position;
        }
    }

    public static int getQueueSize() {
        return operationQueue.size() + (isProcessing.get() ? 1 : 0);
    }

    public static void shutdown() {
        for (WorldOperation op : operationQueue) {
            if (!op.player.isOnline()) continue;
            op.player.sendMessage("[EliteMobs] Dungeon preparation cancelled due to server shutdown.");
        }
        operationQueue.clear();
    }

    private record WorldOperation(Player player, Supplier<Boolean> asyncOperation, Runnable syncOperation, String operationName) {
    }
}

