/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.PlayerJoinArenaEvent;
import com.magmaguy.elitemobs.api.PlayerJoinDungeonEvent;
import com.magmaguy.elitemobs.api.instanced.MatchJoinEvent;
import com.magmaguy.elitemobs.api.instanced.MatchLeaveEvent;
import com.magmaguy.elitemobs.collateralminecraftchanges.AlternativeDurabilityLoss;
import com.magmaguy.elitemobs.config.ArenasConfig;
import com.magmaguy.elitemobs.instanced.InstanceDeathLocation;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.arena.ArenaInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.AttributeManager;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InstancePlayerManager {
    public static boolean addNewPlayer(final Player player, final MatchInstance matchInstance) {
        MatchJoinEvent event = new MatchJoinEvent(matchInstance, player);
        if (event.isCancelled()) {
            return false;
        }
        if (!matchInstance.state.equals((Object)MatchInstance.InstancedRegionState.WAITING)) {
            player.sendMessage(ArenasConfig.getArenasOngoingMessage());
            return false;
        }
        if (matchInstance.players.size() + 1 > matchInstance.maxPlayers) {
            player.sendMessage(ArenasConfig.getArenaFullMessage());
            return false;
        }
        if (matchInstance.getPermission() != null && !player.hasPermission(matchInstance.getPermission())) {
            return false;
        }
        matchInstance.participants.add(player);
        matchInstance.players.add(player);
        PlayerData.setMatchInstance(player, matchInstance);
        player.sendMessage(ArenasConfig.getArenaJoinPlayerMessage().replace("$count", "" + matchInstance.minPlayers));
        player.sendTitle(ArenasConfig.getJoinPlayerTitle(), ArenasConfig.getJoinPlayerSubtitle(), 60, 180, 60);
        matchInstance.getPreviousPlayerLocations().put(player, player.getLocation());
        if (matchInstance instanceof ArenaInstance) {
            ArenaInstance arenaInstance = (ArenaInstance)matchInstance;
            new EventCaller(new PlayerJoinArenaEvent(arenaInstance));
        } else if (matchInstance instanceof DungeonInstance) {
            DungeonInstance dungeonInstance = (DungeonInstance)matchInstance;
            new EventCaller(new PlayerJoinDungeonEvent(dungeonInstance));
        }
        new BukkitRunnable(){

            public void run() {
                MatchInstance.MatchInstanceEvents.teleportBypass = true;
                if (matchInstance.state.equals((Object)MatchInstance.InstancedRegionState.WAITING) && matchInstance.lobbyLocation != null) {
                    player.teleport(matchInstance.lobbyLocation);
                } else {
                    player.teleport(matchInstance.startLocation);
                }
                matchInstance.playerLives.put(player, 3);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
        return true;
    }

    public static void removePlayer(Player player, MatchInstance matchInstance) {
        new MatchLeaveEvent(matchInstance, player);
        PlayerData.setMatchInstance(player, null);
        matchInstance.players.remove(player);
        if (!matchInstance.spectators.contains(player)) {
            matchInstance.participants.remove(player);
            PlayerData.setMatchInstance(player, null);
        }
        if (matchInstance.players.isEmpty() && matchInstance.getDeathLocationByPlayer(player) != null) {
            matchInstance.getDeathLocationByPlayer(player).clear(false);
        }
        if (player.isOnline()) {
            MatchInstance.MatchInstanceEvents.teleportBypass = true;
            if (matchInstance instanceof DungeonInstance) {
                Location location = matchInstance.previousPlayerLocations.get(player);
                if (location != null) {
                    player.teleport(location);
                } else {
                    player.teleport(matchInstance.exitLocation);
                }
            } else {
                player.teleport(matchInstance.exitLocation);
            }
        }
        if (matchInstance.state != MatchInstance.InstancedRegionState.COMPLETED && matchInstance.state != MatchInstance.InstancedRegionState.COMPLETED_DEFEAT && matchInstance.state != MatchInstance.InstancedRegionState.COMPLETED_VICTORY && matchInstance.players.isEmpty()) {
            matchInstance.defeat();
        } else {
            matchInstance.playerLives.remove(player);
        }
    }

    public static void playerDeath(MatchInstance matchInstance, Player player) {
        if (!matchInstance.players.contains(player)) {
            return;
        }
        AlternativeDurabilityLoss.doDurabilityLoss(player);
        AttributeManager.setAttribute((LivingEntity)player, (String)"generic_max_health", (double)AttributeManager.getAttributeBaseValue((LivingEntity)player, (String)"generic_max_health"));
        matchInstance.players.remove(player);
        if (matchInstance.players.isEmpty()) {
            matchInstance.defeat();
            MatchInstance.MatchInstanceEvents.teleportBypass = true;
            if (matchInstance.previousPlayerLocations.get(player) != null) {
                player.teleport(matchInstance.previousPlayerLocations.get(player));
            } else if (matchInstance.exitLocation != null) {
                player.teleport(matchInstance.exitLocation);
            }
            PlayerData.setMatchInstance(player, null);
            matchInstance.participants.remove(player);
            return;
        }
        new InstanceDeathLocation(player, matchInstance);
        matchInstance.addSpectator(player, true);
    }

    public static void revivePlayer(MatchInstance matchInstance, Player player, InstanceDeathLocation deathLocation) {
        matchInstance.playerLives.put(player, matchInstance.playerLives.get(player) - 1);
        matchInstance.players.add(player);
        player.setGameMode(GameMode.SURVIVAL);
        matchInstance.spectators.remove(player);
        MatchInstance.MatchInstanceEvents.teleportBypass = true;
        player.teleport(deathLocation.getBannerBlock().getLocation());
        PlayerData.setMatchInstance(player, matchInstance);
    }

    public static void addSpectator(MatchInstance matchInstance, Player player, boolean wasPlayer) {
        new MatchJoinEvent(matchInstance, player);
        if (!wasPlayer) {
            matchInstance.previousPlayerLocations.put(player, player.getLocation());
        }
        matchInstance.participants.add(player);
        player.sendMessage(ArenasConfig.getArenaJoinSpectatorMessage());
        player.sendTitle(ArenasConfig.getJoinSpectatorTitle(), ArenasConfig.getJoinSpectatorSubtitle(), 60, 180, 60);
        matchInstance.spectators.add(player);
        player.setGameMode(GameMode.SPECTATOR);
        if (!wasPlayer) {
            MatchInstance.MatchInstanceEvents.teleportBypass = true;
            player.teleport(matchInstance.startLocation);
        }
        PlayerData.setMatchInstance(player, matchInstance);
    }

    public static void removeSpectator(MatchInstance matchInstance, Player player) {
        matchInstance.spectators.remove(player);
        if (!matchInstance.players.contains(player)) {
            PlayerData.setMatchInstance(player, null);
            matchInstance.participants.remove(player);
        }
        player.setGameMode(GameMode.SURVIVAL);
        MatchInstance.MatchInstanceEvents.teleportBypass = true;
        if (matchInstance instanceof DungeonInstance) {
            Location location = matchInstance.previousPlayerLocations.get(player);
            if (location != null) {
                player.teleport(location);
            } else {
                player.teleport(matchInstance.exitLocation);
            }
        } else {
            player.teleport(matchInstance.exitLocation);
        }
        PlayerData.setMatchInstance(player, null);
        matchInstance.playerLives.remove(player);
        if (matchInstance.getDeathLocationByPlayer(player) != null) {
            matchInstance.getDeathLocationByPlayer(player).clear(false);
        }
    }

    public static void removeAnyKind(MatchInstance matchInstance, Player player) {
        if (matchInstance.players.contains(player)) {
            matchInstance.removePlayer(player);
        }
        if (matchInstance.spectators.contains(player)) {
            matchInstance.removeSpectator(player);
        }
        matchInstance.participants.remove(player);
        PlayerData.setMatchInstance(player, null);
    }
}

