/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons.utility;

import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.dungeons.WorldDungeonPackage;
import com.magmaguy.elitemobs.dungeons.WorldPackage;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.util.TemporaryWorldManager;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class DungeonUtils {
    public static Pair getLowestAndHighestLevels(List<CustomBossEntity> customBossEntities) {
        int lowestLevel = 0;
        int highestLevel = 0;
        for (CustomBossEntity customBossEntity : customBossEntities) {
            try {
                int level = customBossEntity.getLevel();
                lowestLevel = lowestLevel == 0 ? level : Math.min(lowestLevel, level);
                highestLevel = highestLevel == 0 ? level : Math.max(highestLevel, level);
            }
            catch (Exception exception) {}
        }
        return new Pair(lowestLevel, highestLevel);
    }

    public static World loadWorld(WorldPackage worldPackage) {
        String worldName = worldPackage.getContentPackagesConfigFields().getWorldName();
        World.Environment environment = worldPackage.getContentPackagesConfigFields().getEnvironment();
        World world = DungeonUtils.loadWorld(worldName, environment, worldPackage.getContentPackagesConfigFields());
        if (worldPackage.getContentPackagesConfigFields().getWormholeWorldName() != null) {
            DungeonUtils.loadWorld(worldPackage.getContentPackagesConfigFields().getWormholeWorldName(), environment, worldPackage.getContentPackagesConfigFields());
        }
        if (world != null) {
            worldPackage.setInstalled(true);
        }
        return world;
    }

    public static World loadWorld(String worldName, World.Environment environment, ContentPackagesConfigFields contentPackagesConfigFields) {
        World world = TemporaryWorldManager.loadVoidTemporaryWorld((String)worldName, (World.Environment)environment);
        if (world != null) {
            EliteMobsWorld.create(world.getUID(), contentPackagesConfigFields);
        }
        return world;
    }

    public static boolean unloadWorld(WorldPackage worldPackage) {
        World defaultWorld = (World)Bukkit.getWorlds().get(0);
        World wormholeWorld = null;
        if (worldPackage instanceof WorldDungeonPackage && ((WorldDungeonPackage)worldPackage).getWormholeWorld() != null) {
            wormholeWorld = ((WorldDungeonPackage)worldPackage).getWormholeWorld();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getWorld() != worldPackage.getWorld() && player.getWorld() != wormholeWorld) continue;
            if (defaultWorld == null) {
                return false;
            }
            player.teleport(defaultWorld.getSpawnLocation());
        }
        Bukkit.unloadWorld((World)worldPackage.getWorld(), (boolean)false);
        if (worldPackage instanceof WorldDungeonPackage && ((WorldDungeonPackage)worldPackage).getWormholeWorld() != null) {
            Bukkit.unloadWorld((World)((WorldDungeonPackage)worldPackage).getWormholeWorld(), (boolean)false);
        }
        EliteMobsWorld.destroy(worldPackage.getWorld().getUID());
        return true;
    }

    public static class Pair {
        Integer lowestValue;
        Integer highestValue;

        public Pair(Integer lowestValue, Integer highestValue) {
            this.lowestValue = lowestValue;
            this.highestValue = highestValue;
        }

        @Generated
        public Integer getLowestValue() {
            return this.lowestValue;
        }

        @Generated
        public Integer getHighestValue() {
            return this.highestValue;
        }
    }
}

