/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.DungeonInstallEvent;
import com.magmaguy.elitemobs.api.DungeonUninstallEvent;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfig;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.CombatContent;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class WorldInstancedDungeonPackage
extends EMPackage
implements CombatContent {
    private int level;

    public WorldInstancedDungeonPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        super(contentPackagesConfigFields);
    }

    @Override
    public void doInstall(Player player) {
        DungeonInstallEvent event = new DungeonInstallEvent(this.contentPackagesConfigFields);
        new EventCaller(event);
        this.contentPackagesConfigFields.simpleInstall();
        player.sendMessage(ChatColorConverter.convert((String)("&2Dungeon " + this.contentPackagesConfigFields.getFilename() + " installed!")));
        if (!this.contentPackagesConfigFields.isEnchantmentChallenge()) {
            player.sendMessage(ChatColorConverter.convert((String)"&6Instanced dungeons must be accessed either through the &a/em &6menu or an NPC! NPCs for premade EliteMobs content can be found at the Adventurer's Guild Hub map."));
            player.sendMessage("Remember that instanced dungeons create a world when you join them and remove that world when you are done playing in them!");
        } else {
            player.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &2Enchantment instanced dungeon installed! This dungeon can only be accessed when attempting to enchant items and getting a challenge as a result!"));
            ContentPackagesConfig.getEnchantedChallengeDungeonPackages().put(this.contentPackagesConfigFields.getFilename(), this.contentPackagesConfigFields);
        }
        this.isInstalled = true;
    }

    @Override
    public void doUninstall(Player player) {
        DungeonUninstallEvent event = new DungeonUninstallEvent(this.contentPackagesConfigFields);
        new EventCaller(event);
        this.contentPackagesConfigFields.simpleUninstall();
        this.isInstalled = false;
    }

    @Override
    public void baseInitialization() {
        this.level = this.contentPackagesConfigFields.getContentLevel();
        File file = new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "world_blueprints" + File.separatorChar + this.contentPackagesConfigFields.getDungeonConfigFolderName());
        if (!file.exists()) {
            this.isDownloaded = false;
            this.isInstalled = false;
            return;
        }
        for (File worldFile : Bukkit.getWorldContainer().listFiles()) {
            if (!worldFile.getName().contains(file.getName()) || !worldFile.getName().matches(".*_\\d{1,2}$")) continue;
            try {
                FileUtils.deleteDirectory((File)worldFile);
                Logger.info((String)("Removing previously instanced world " + worldFile.getName()));
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to remove previously instanced world " + worldFile.getName()));
            }
        }
        this.isDownloaded = true;
        this.isInstalled = this.contentPackagesConfigFields.isEnabled();
    }

    @Override
    public void initializeContent() {
    }

    @Override
    public int getLowestLevel() {
        return this.level;
    }

    @Override
    public int getHighestLevel() {
        return this.level;
    }
}

