/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.api.DungeonUninstallEvent;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.Dungeon;
import com.magmaguy.elitemobs.dungeons.WorldPackage;
import com.magmaguy.elitemobs.dungeons.utility.DungeonUtils;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.treasurechest.TreasureChest;
import com.magmaguy.elitemobs.utils.EventCaller;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldDungeonPackage
extends WorldPackage
implements Dungeon {
    private int lowestLevel;
    private int highestLevel;
    private World wormholeWorld = null;

    public WorldDungeonPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        super(contentPackagesConfigFields);
    }

    @Override
    public void baseInitialization() {
        super.baseInitialization();
        this.initializeWormholeWorld();
    }

    private void initializeWormholeWorld() {
        if (this.contentPackagesConfigFields.getWormholeWorldName() != null && !this.contentPackagesConfigFields.getWormholeWorldName().isEmpty() && Bukkit.getWorld((String)this.contentPackagesConfigFields.getWormholeWorldName()) == null) {
            String wormholeWorldName = this.contentPackagesConfigFields.getWormholeWorldName();
            boolean wormholeWorldExists = Files.exists(Paths.get(String.valueOf(Bukkit.getWorldContainer()) + File.separator + wormholeWorldName, new String[0]), new LinkOption[0]);
            if (wormholeWorldExists) {
                this.wormholeWorld = DungeonUtils.loadWorld(this.getContentPackagesConfigFields().getWormholeWorldName(), this.getContentPackagesConfigFields().getEnvironment(), this.contentPackagesConfigFields);
            }
        }
    }

    @Override
    public void initializeContent() {
        if (this.isInstalled) {
            this.getEntities();
            this.qualifyEntities();
            this.getChests();
            this.getNPCs();
        }
    }

    @Override
    public void doUninstall(Player player) {
        DungeonUninstallEvent event = new DungeonUninstallEvent(this.contentPackagesConfigFields);
        new EventCaller(event);
        this.isInstalled = false;
        this.customBossEntityList.clear();
        this.treasureChestList.clear();
    }

    private void getEntities() {
        for (RegionalBossEntity regionalBossEntity : RegionalBossEntity.getRegionalBossEntitySet()) {
            if ((regionalBossEntity == null || regionalBossEntity.getWorldName() == null || this.world == null || !regionalBossEntity.getWorldName().equals(this.world.getName())) && (this.wormholeWorld == null || !regionalBossEntity.getWorldName().equals(this.wormholeWorld.getName()))) continue;
            this.customBossEntityList.add(regionalBossEntity);
        }
    }

    private void qualifyEntities() {
        DungeonUtils.Pair lowestAndHighestValues = DungeonUtils.getLowestAndHighestLevels(this.customBossEntityList);
        this.lowestLevel = lowestAndHighestValues.getLowestValue();
        this.highestLevel = lowestAndHighestValues.getHighestValue();
    }

    private void getChests() {
        for (TreasureChest treasureChest : TreasureChest.getTreasureChestHashMap().values()) {
            if ((treasureChest.getWorldName() == null || this.world == null || !treasureChest.getWorldName().equals(this.world.getName())) && (this.wormholeWorld == null || !treasureChest.getWorldName().equals(this.wormholeWorld.getName()))) continue;
            this.treasureChestList.add(treasureChest);
        }
    }

    private void getNPCs() {
        if (this.world == null) {
            return;
        }
        for (NPCEntity npcEntity : EntityTracker.getNpcEntities().values()) {
            if (!npcEntity.getWorldName().equals(this.world.getName()) && (this.wormholeWorld == null || !npcEntity.getWorldName().equals(this.wormholeWorld.getName()))) continue;
            this.npcEntities.add(npcEntity);
        }
    }

    @Override
    public int getLowestLevel() {
        return this.lowestLevel;
    }

    @Override
    public int getHighestLevel() {
        return this.highestLevel;
    }

    @Generated
    public World getWormholeWorld() {
        return this.wormholeWorld;
    }
}

