/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.translations;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.translations.TranslationsConfigFields;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import lombok.Generated;

public class TranslationsConfig {
    private static TranslationsConfigFields translationsConfigFields;

    public TranslationsConfig() {
        if (TranslationsConfig.isEnglish()) {
            translationsConfigFields = null;
            Logger.info((String)"Language set to English - using plugin defaults");
        } else {
            translationsConfigFields = new TranslationsConfigFields();
        }
    }

    public static String add(String filename, String key, String value) {
        if (TranslationsConfig.isEnglish()) {
            return value;
        }
        if (translationsConfigFields == null) {
            Logger.warn((String)"TranslationsConfig not initialized, defaulting to English! (String)");
            return value;
        }
        translationsConfigFields.add(filename, key, value);
        Object result = translationsConfigFields.get(filename, key);
        return result instanceof String ? (String)result : value;
    }

    public static List<String> add(String filename, String key, List<String> value) {
        if (TranslationsConfig.isEnglish()) {
            return value;
        }
        if (translationsConfigFields == null) {
            Logger.warn((String)"TranslationsConfig not initialized, defaulting to English! (List)");
            return value;
        }
        translationsConfigFields.add(filename, key, value);
        Object result = translationsConfigFields.get(filename, key);
        return result instanceof List ? (List)result : value;
    }

    private static boolean isEnglish() {
        String lang = DefaultConfig.getLanguage();
        if (lang == null) {
            return true;
        }
        return (lang = lang.toLowerCase().replace(".yml", "").replace(".csv", "")).equals("english") || lang.equals("en");
    }

    public static void shutdown() {
        if (translationsConfigFields != null) {
            translationsConfigFields.shutdown();
        }
    }

    @Generated
    public static TranslationsConfigFields getTranslationsConfigFields() {
        return translationsConfigFields;
    }
}

