/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.magmacore.config.ConfigurationFile;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;

public class AdventurersGuildConfig
extends ConfigurationFile {
    private static final String[][] rankNames = new String[11][21];
    private static final String[][] shortRankNames = new String[11][21];
    private static boolean addMaxHealth;
    private static boolean addCrit;
    private static boolean addDodge;
    private static boolean agTeleport;
    private static boolean guildLootLimiter;
    private static String lootLimiterMessage;
    private static List<String> onRankUpCommand;
    private static List<String> onPrestigeUpCommand;
    private static double dodge1;
    private static double dodge2;
    private static double dodge3;
    private static double crit1;
    private static double crit2;
    private static double crit3;
    private static double health1;
    private static double health2;
    private static double health3;
    private static double health4;
    private static String adventurersGuildMenuName;
    private static int baseKillsForRankUp;
    private static int additionalKillsForRankUpPerTier;
    private static String prestigeUnlockMessageTitle;
    private static String prestigeUnlockMessageSubtitle;
    private static List<String> worldsWithoutAGBonuses;
    private static double peacefulModeEliteChanceDecrease;
    private static boolean disableCommonerRank;
    private static boolean defaultToCommonerRank;

    public AdventurersGuildConfig() {
        super("AdventurersGuild.yml");
    }

    public static String getRankName(int prestigeTier, int rankTier) {
        return ChatColorConverter.convert((String)rankNames[prestigeTier][rankTier]);
    }

    public static String getShortenedRankName(int prestigeTier, int rankTier) {
        return ChatColorConverter.convert((String)shortRankNames[prestigeTier][rankTier]);
    }

    private static String prestigeColors(int prestigeTier) {
        switch (prestigeTier) {
            case 1: {
                return "&e";
            }
            case 2: {
                return "&2";
            }
            case 3: {
                return "&a";
            }
            case 4: {
                return "&3";
            }
            case 5: {
                return "&b";
            }
            case 6: {
                return "&4";
            }
            case 7: {
                return "&c";
            }
            case 8: {
                return "&9";
            }
            case 9: {
                return "&d";
            }
            case 10: {
                return "&5";
            }
        }
        return "error";
    }

    private static String romanNumerals(int prestigeTier) {
        switch (prestigeTier) {
            case 1: {
                return "\u2160";
            }
            case 2: {
                return "\u2160\u2160";
            }
            case 3: {
                return "\u2160\u2160\u2160";
            }
            case 4: {
                return "\u2160\u2164";
            }
            case 5: {
                return "\u2164";
            }
            case 6: {
                return "\u2164\u2160";
            }
            case 7: {
                return "\u2164\u2160\u2160";
            }
            case 8: {
                return "\u2164\u2160\u2160\u2160";
            }
            case 9: {
                return "\u2160\u2169";
            }
            case 10: {
                return "\u2169";
            }
            case 11: {
                return "\u2169\u2160";
            }
            case 12: {
                return "\u2169\u2160\u2160";
            }
            case 13: {
                return "\u2169\u2160\u2160\u2160";
            }
            case 14: {
                return "\u2169\u2160\u2164";
            }
            case 15: {
                return "\u2169\u2164";
            }
            case 16: {
                return "\u2169\u2164\u2160";
            }
            case 17: {
                return "\u2169\u2164\u2160\u2160";
            }
            case 18: {
                return "\u2169\u2164\u2160\u2160\u2160";
            }
            case 19: {
                return "\u2169\u2160\u2169";
            }
            case 20: {
                return "\u2169\u2169";
            }
            case 0: {
                return "0";
            }
        }
        return "error";
    }

    public void initializeValues() {
        addMaxHealth = ConfigurationEngine.setBoolean(List.of("Sets if EliteMobs will add max health when unlocking guild ranks as a prestige reward"), (FileConfiguration)this.fileConfiguration, (String)"Add max health when unlocking higher guild ranks", (boolean)true);
        addCrit = ConfigurationEngine.setBoolean(List.of("Sets if EliteMobs will add a critical strike chance when unlocking guild ranks as a prestige reward"), (FileConfiguration)this.fileConfiguration, (String)"Add critical chance when unlocking higher guild ranks", (boolean)true);
        addDodge = ConfigurationEngine.setBoolean(List.of("Sets if EliteMobs will add dodge chance when unlocking guild ranks as a prestige reward"), (FileConfiguration)this.fileConfiguration, (String)"Add dodge chance when unlocking higher guild ranks", (boolean)true);
        agTeleport = ConfigurationEngine.setBoolean(List.of("Sets if user commands get rerouted to the adventurer's guild hub. This is highly recommended for gameplay immersion and tutorial purposes."), (FileConfiguration)this.fileConfiguration, (String)"userCommandsTeleportToAdventurersGuild", (boolean)true);
        adventurersGuildMenuName = ConfigurationEngine.setString(List.of("Sets the in-game display name of the adventurer's guild"), this.file, this.fileConfiguration, "adventurersGuildMenuName", "&6&lAdventurer's Hub", true);
        for (int prestigeRank = 0; prestigeRank < 11; ++prestigeRank) {
            block24: for (int normalRank = 0; normalRank < 11 + prestigeRank; ++normalRank) {
                String rankName = "";
                String shortRankName = "";
                switch (normalRank) {
                    case 0: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&8Commoner - disables elites!", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &8Commoner", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 1: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&fRookie", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &fRookie", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 2: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&fNovice", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &fNovice", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 3: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&fApprentice", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &fApprentice", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 4: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&2Adventurer", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &2Adventurer", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 5: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&2Journeyman", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &2Journeyman", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 6: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&2Adept", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &2Adept", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 7: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&1Veteran", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &1Veteran", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 8: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&1Elite", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &1Elite", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 9: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&lMaster", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Master", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 10: {
                        if (prestigeRank == 0) {
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, "&5Hero", true);
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        } else {
                            shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                            rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Hero", true);
                        }
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 11: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Legend", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 12: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Myth", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 13: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Immortal", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 14: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Chosen", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 15: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Ascendant", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 16: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Titan", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 17: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Demigod", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 18: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Deity", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 19: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Godhunter", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    case 20: {
                        rankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank, AdventurersGuildConfig.prestigeColors(prestigeRank) + "Prestige " + prestigeRank + " &5Godslayer", true);
                        shortRankName = ConfigurationEngine.setString(this.file, this.fileConfiguration, "Prestige " + prestigeRank + " rank " + normalRank + " short placeholder", AdventurersGuildConfig.prestigeColors(prestigeRank) + "\u269c" + AdventurersGuildConfig.romanNumerals(prestigeRank) + "&6&l\u2727&e" + AdventurersGuildConfig.romanNumerals(normalRank), true);
                        AdventurersGuildConfig.rankNames[prestigeRank][normalRank] = rankName;
                        AdventurersGuildConfig.shortRankNames[prestigeRank][normalRank] = shortRankName;
                        continue block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + normalRank);
                    }
                }
            }
        }
        guildLootLimiter = ConfigurationEngine.setBoolean(List.of("Sets if player loot is limited by their guild level.", " This is an incredibly important part of EliteMobs and extremely highly recommended."), (FileConfiguration)this.fileConfiguration, (String)"limitLootBasedOnGuildTier", (boolean)true);
        lootLimiterMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players if their loot gets nerfed due to their low guild level."), this.file, this.fileConfiguration, "lootLimiterMessage", "&7[EM] &cYou must unlock the next guild rank through /ag to loot better items!", true);
        onRankUpCommand = ConfigurationEngine.setList(List.of("Sets the commands that run on guild rank up. Placeholders are:", "$prestigerank - outputs the prestige rank", "$activerank - outputs the currently active rank", "$player - outputs the player name"), this.file, this.fileConfiguration, "onRankUpCommand", Collections.emptyList(), false);
        onPrestigeUpCommand = ConfigurationEngine.setList(List.of("Sets the commands that run on prestige rank up.", "$prestigerank - outputs the prestige rank", "$activerank - outputs the currently active rank", "$player - outputs the player name"), this.file, this.fileConfiguration, "onPrestigeUpCommand", Collections.emptyList(), false);
        dodge1 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the first dodge bonus."), (FileConfiguration)this.fileConfiguration, (String)"dodgePrestige3Bonus", (double)3.0);
        dodge2 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the second dodge bonus."), (FileConfiguration)this.fileConfiguration, (String)"dodgePrestige6Bonus", (double)6.0);
        dodge3 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the third dodge bonus."), (FileConfiguration)this.fileConfiguration, (String)"dodgePrestige9Bonus", (double)10.0);
        crit1 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the first critical hit bonus."), (FileConfiguration)this.fileConfiguration, (String)"critPrestige2Bonus", (double)3.0);
        crit2 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the second critical hit bonus."), (FileConfiguration)this.fileConfiguration, (String)"critPrestige5Bonus", (double)6.0);
        crit3 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the third critical hit bonus."), (FileConfiguration)this.fileConfiguration, (String)"critPrestige8Bonus", (double)10.0);
        health1 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the first max health bonus."), (FileConfiguration)this.fileConfiguration, (String)"healthPrestige1Bonus", (double)2.0);
        health2 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the second max health bonus."), (FileConfiguration)this.fileConfiguration, (String)"healthPrestige4Bonus", (double)2.5);
        health3 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the third max health bonus."), (FileConfiguration)this.fileConfiguration, (String)"healthPrestige7Bonus", (double)3.0);
        health4 = ConfigurationEngine.setDouble(List.of("Sets the prestige level for the third max health bonus."), (FileConfiguration)this.fileConfiguration, (String)"healthPrestige10Bonus", (double)4.0);
        baseKillsForRankUp = ConfigurationEngine.setInt(List.of("Sets the estimated base amount of bosses that must be killed to be able to afford a rank up."), (FileConfiguration)this.fileConfiguration, (String)"baseKillsForRankUpV2", (int)100);
        additionalKillsForRankUpPerTier = ConfigurationEngine.setInt(List.of("Sets the estimated additional amount of bosses that must be killed to be able to rank up, per level.", "The formula is this amount x the level the player is currently at."), (FileConfiguration)this.fileConfiguration, (String)"additionalKillsForRankUpPerTierV2", (int)50);
        prestigeUnlockMessageTitle = ConfigurationEngine.setString(List.of("Sets title sent to players when someone unlocks a prestige rank.", "$player is a placeholder that gets replaced with the player's display name."), this.file, this.fileConfiguration, "prestigeUnlockMessageTitle", "$player", true);
        prestigeUnlockMessageSubtitle = ConfigurationEngine.setString(List.of("Sets subtitle sent to players when someone unlocks a prestige rank.", "$tier is a placeholder that gets replaced with the player's prestige level."), this.file, this.fileConfiguration, "prestigeUnlockMessageSubtitle", "&2has unlocked $tier&2!", true);
        peacefulModeEliteChanceDecrease = ConfigurationEngine.setDouble(List.of("Sets the multiplier that will be applied to the spawn chance when players are using the peaceful (commoner) rank."), (FileConfiguration)this.fileConfiguration, (String)"peacefulModeEliteChanceDecrease", (double)0.2);
        worldsWithoutAGBonuses = ConfigurationEngine.setList(List.of("Sets the list of worlds to which guild rank bonuses will not be applied"), this.file, this.fileConfiguration, "worldsWithoutAGBonuses", new ArrayList(), false);
        disableCommonerRank = ConfigurationEngine.setBoolean(List.of("Disables users' ability to switch to peaceful mode for EliteMobs. Peaceful mode lowers level and spawn rates of mobs around that player specifically"), (FileConfiguration)this.fileConfiguration, (String)"disableCommonerRank", (boolean)false);
        defaultToCommonerRank = ConfigurationEngine.setBoolean(List.of("Sets whether the default rank for new players will be peaceful mode or commoner.", "Not recommended as the expectation is most players will want to play with EliteMobs, which commoner rank virtually disables."), (FileConfiguration)this.fileConfiguration, (String)"defaultToCommonerRank", (boolean)false);
    }

    @Generated
    public static String[][] getRankNames() {
        return rankNames;
    }

    @Generated
    public static String[][] getShortRankNames() {
        return shortRankNames;
    }

    @Generated
    public static boolean isAddMaxHealth() {
        return addMaxHealth;
    }

    @Generated
    public static boolean isAddCrit() {
        return addCrit;
    }

    @Generated
    public static boolean isAddDodge() {
        return addDodge;
    }

    @Generated
    public static boolean isAgTeleport() {
        return agTeleport;
    }

    @Generated
    public static boolean isGuildLootLimiter() {
        return guildLootLimiter;
    }

    @Generated
    public static String getLootLimiterMessage() {
        return lootLimiterMessage;
    }

    @Generated
    public static List<String> getOnRankUpCommand() {
        return onRankUpCommand;
    }

    @Generated
    public static List<String> getOnPrestigeUpCommand() {
        return onPrestigeUpCommand;
    }

    @Generated
    public static double getDodge1() {
        return dodge1;
    }

    @Generated
    public static double getDodge2() {
        return dodge2;
    }

    @Generated
    public static double getDodge3() {
        return dodge3;
    }

    @Generated
    public static double getCrit1() {
        return crit1;
    }

    @Generated
    public static double getCrit2() {
        return crit2;
    }

    @Generated
    public static double getCrit3() {
        return crit3;
    }

    @Generated
    public static double getHealth1() {
        return health1;
    }

    @Generated
    public static double getHealth2() {
        return health2;
    }

    @Generated
    public static double getHealth3() {
        return health3;
    }

    @Generated
    public static double getHealth4() {
        return health4;
    }

    @Generated
    public static String getAdventurersGuildMenuName() {
        return adventurersGuildMenuName;
    }

    @Generated
    public static int getBaseKillsForRankUp() {
        return baseKillsForRankUp;
    }

    @Generated
    public static int getAdditionalKillsForRankUpPerTier() {
        return additionalKillsForRankUpPerTier;
    }

    @Generated
    public static String getPrestigeUnlockMessageTitle() {
        return prestigeUnlockMessageTitle;
    }

    @Generated
    public static String getPrestigeUnlockMessageSubtitle() {
        return prestigeUnlockMessageSubtitle;
    }

    @Generated
    public static List<String> getWorldsWithoutAGBonuses() {
        return worldsWithoutAGBonuses;
    }

    @Generated
    public static double getPeacefulModeEliteChanceDecrease() {
        return peacefulModeEliteChanceDecrease;
    }

    @Generated
    public static boolean isDisableCommonerRank() {
        return disableCommonerRank;
    }

    @Generated
    public static boolean isDefaultToCommonerRank() {
        return defaultToCommonerRank;
    }
}

