/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands.setup;

import com.magmaguy.elitemobs.dungeons.DynamicDungeonPackage;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.dungeons.EventsPackage;
import com.magmaguy.elitemobs.dungeons.ItemsPackage;
import com.magmaguy.elitemobs.dungeons.MetaPackage;
import com.magmaguy.elitemobs.dungeons.ModelsPackage;
import com.magmaguy.elitemobs.dungeons.WorldDungeonPackage;
import com.magmaguy.elitemobs.dungeons.WorldInstancedDungeonPackage;
import com.magmaguy.magmacore.menus.MenuButton;
import com.magmaguy.magmacore.menus.SetupMenu;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EliteSetupMenu {
    public static void createMenu(Player player) {
        ArrayList<EMPackage> rawEmPackages = new ArrayList<EMPackage>(EMPackage.getEmPackages().values());
        List<EMPackage> emPackages = rawEmPackages.stream().sorted(Comparator.comparing(pkg -> ChatColor.stripColor((String)ChatColorConverter.convert((String)pkg.getContentPackagesConfigFields().getName())))).collect(Collectors.toList());
        rawEmPackages.stream().filter(MetaPackage.class::isInstance).forEach(rawEmPackage -> ((MetaPackage)((Object)rawEmPackage)).getPackages().forEach(emPackages::remove));
        MenuButton infoButton = new MenuButton(ItemStackGenerator.generateSkullItemStack((String)"magmaguy", (String)"&2Installation instructions:", List.of("&2To setup the optional/recommended content for EliteMobs:", "&61) &fDownload content from &9https://nightbreak.io/plugin/elitemobs", "&62) &fPut the content in the &2imports &ffolder of EliteMobs", "&63) &fDo &2/em reload", "&2That's it!", "&6Click for more info and links!"))){

            public void onClick(Player p) {
                p.closeInventory();
                Logger.sendSimpleMessage((CommandSender)p, (String)"&8&l&m&o---------------------------------------------");
                Logger.sendSimpleMessage((CommandSender)p, (String)"&6&lEliteMobs installation resources:");
                Logger.sendSimpleMessage((CommandSender)p, (String)"&2&lWiki page: &9&nhttps://magmaguy.com/wiki.html");
                Logger.sendSimpleMessage((CommandSender)p, (String)"&2&lVideo setup guide: &9&nhttps://youtu.be/boRg2X4qhw4");
                Logger.sendSimpleMessage((CommandSender)p, (String)"&2&lContent download links: &9&nhttps://nightbreak.io/plugin/elitemobs/");
                Logger.sendSimpleMessage((CommandSender)p, (String)"&2&lDiscord support: &9&nhttps://discord.gg/9f5QSka");
                Logger.sendSimpleMessage((CommandSender)p, (String)"&8&l&m&o---------------------------------------------");
            }
        };
        new SetupMenu(player, infoButton, emPackages, List.of(EliteSetupMenu.createFilter(emPackages, Material.GRASS_BLOCK, "Filter By Open Dungeons", EliteSetupMenu::filterOpenDungeon), EliteSetupMenu.createFilter(emPackages, Material.CRYING_OBSIDIAN, "Filter By Instanced Dungeons", EliteSetupMenu::filterInstancedDungeon), EliteSetupMenu.createFilter(emPackages, Material.ENDER_PEARL, "Filter By Dynamic Dungeons", EliteSetupMenu::filterDynamicDungeon), EliteSetupMenu.createFilter(emPackages, Material.SKULL_BANNER_PATTERN, "Filter By Events", EliteSetupMenu::filterEvents), EliteSetupMenu.createFilter(emPackages, Material.DIAMOND_SWORD, "Filter By Custom Items", EliteSetupMenu::filterItems), EliteSetupMenu.createFilter(emPackages, Material.ARMOR_STAND, "Filter By Custom Models", EliteSetupMenu::filterModels)));
    }

    private static SetupMenu.SetupMenuFilter createFilter(List<EMPackage> orderedPackages, Material material, String name, Predicate<EMPackage> predicate) {
        List<EMPackage> filteredPackages = orderedPackages.stream().filter(predicate).toList();
        return new SetupMenu.SetupMenuFilter(ItemStackGenerator.generateItemStack((Material)material, (String)name), filteredPackages);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean filterOpenDungeon(EMPackage pkg) {
        if (pkg instanceof WorldDungeonPackage) return true;
        if (!(pkg instanceof MetaPackage)) return false;
        MetaPackage metaPackage = (MetaPackage)pkg;
        if (!metaPackage.getPackages().stream().anyMatch(WorldDungeonPackage.class::isInstance)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean filterInstancedDungeon(EMPackage pkg) {
        if (pkg instanceof WorldInstancedDungeonPackage) return true;
        if (!(pkg instanceof MetaPackage)) return false;
        MetaPackage metaPackage = (MetaPackage)pkg;
        if (!metaPackage.getPackages().stream().allMatch(WorldInstancedDungeonPackage.class::isInstance)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean filterDynamicDungeon(EMPackage pkg) {
        if (pkg instanceof DynamicDungeonPackage) return true;
        if (!(pkg instanceof MetaPackage)) return false;
        MetaPackage metaPackage = (MetaPackage)pkg;
        if (!metaPackage.getPackages().stream().allMatch(DynamicDungeonPackage.class::isInstance)) return false;
        return true;
    }

    private static boolean filterEvents(EMPackage pkg) {
        return pkg instanceof EventsPackage;
    }

    private static boolean filterModels(EMPackage pkg) {
        return pkg instanceof ModelsPackage;
    }

    private static boolean filterItems(EMPackage pkg) {
        return pkg instanceof ItemsPackage;
    }
}

