/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;

public class TrackBossCommand
extends AdvancedCommand {
    public TrackBossCommand() {
        super(List.of("track"));
        this.addLiteral("boss");
        this.addArgument("id", (ICommandArgument)new ListStringCommandArgument("<id>"));
        this.setDescription("Tracks a Custom Boss.");
        this.setUsage("/em track boss <id>");
        this.setSenderType(SenderType.PLAYER);
        this.setPermission("elitemobs.boss.track");
    }

    public void execute(CommandData commandData) {
        try {
            for (CustomBossEntity customBossEntity : CustomBossEntity.getTrackableCustomBosses()) {
                if (!customBossEntity.getEliteUUID().equals(UUID.fromString(commandData.getStringArgument("id")))) continue;
                customBossEntity.getBossTrackingBar().addTrackingPlayer(commandData.getPlayerSender());
                return;
            }
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)DefaultConfig.getBossAlreadyGoneMessage());
        }
        catch (Exception ex) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)DefaultConfig.getBossAlreadyGoneMessage());
        }
    }
}

