/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class SetupToggleCommand
extends AdvancedCommand {
    public SetupToggleCommand() {
        super(List.of("setup"));
        this.addLiteral("toggle");
        this.addArgument("empackages", (ICommandArgument)new ListStringCommandArgument(EMPackage.getEmPackages().values().stream().map(emPackage -> emPackage.getContentPackagesConfigFields().getFilename()).collect(Collectors.toUnmodifiableList()), "empackages"));
        this.setUsage("/em setup toggle <dungeonConfig>");
        this.setPermission("elitemobs.setup");
        this.setDescription("Allows you to toggle the installation of specified EliteMobs content.");
    }

    public void execute(CommandData commandData) {
        String dungeon = commandData.getStringArgument("empackages");
        if (dungeon.isEmpty() || EMPackage.getEmPackages().get(dungeon) == null) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"Not a valid em package!");
        }
        EMPackage emPackage = EMPackage.getEmPackages().get(dungeon);
        emPackage.doInstall(null);
        if (emPackage.isInstalled()) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"Successfully installed content!");
        } else {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"Successfully uninstalled content!");
        }
    }
}

