/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.menus.QuestMenu;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.dialog.DialogManager;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class QuestCheckCommand
extends AdvancedCommand {
    private static final int QUEST_DIALOG_WIDTH = 300;

    public QuestCheckCommand() {
        super(List.of("quest"));
        this.addLiteral("check");
        this.addArgument("questID", (ICommandArgument)new ListStringCommandArgument("<questID>"));
        this.setUsage("Internal command.");
        this.setSenderType(SenderType.PLAYER);
        this.setDescription("Internal command.");
    }

    private static String processText(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\u00a70", "\u00a7f").replace("&0", "&f");
    }

    public void execute(CommandData commandData) {
        Player player = commandData.getPlayerSender();
        UUID questID = UUID.fromString(commandData.getStringArgument("questID"));
        List<Quest> quests = PlayerData.getQuests(player.getUniqueId());
        if (quests == null || quests.isEmpty()) {
            player.sendMessage("You have no active quests.");
            return;
        }
        Quest targetQuest = null;
        for (Quest quest : quests) {
            if (!quest.getQuestID().equals(questID)) continue;
            targetQuest = quest;
            break;
        }
        if (targetQuest == null) {
            player.sendMessage("Quest not found.");
            return;
        }
        this.showQuestDialog(targetQuest, player);
    }

    private void showQuestDialog(Quest quest, Player player) {
        QuestMenu.QuestText questText = new QuestMenu.QuestText(quest, null, player);
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        String title = QuestCheckCommand.processText(questText.getHeader().getText());
        if (title != null && !title.isEmpty()) {
            builder.title(title);
        }
        String statusSuffix = "";
        if (quest.isAccepted()) {
            statusSuffix = quest.getQuestObjectives().isOver() ? " \u00a7f| \u00a72Turn in!" : " \u00a7f| \u00a7aAccepted";
        }
        builder.externalTitle(title + statusSuffix);
        this.addBodySection(builder, questText.getBody());
        this.addBodySectionWithHeader(builder, questText.getFixedSummary(), questText.getSummary());
        this.addBodySectionWithRewards(builder, questText.getFixedRewards(), questText.getRewards(), quest);
        this.addActionButtons(builder, quest, questText);
        builder.addAction(DialogManager.ActionButton.of((String)"\u2190 Back to Status Menu", (DialogManager.Action)new DialogManager.RunCommandAction("/elitemobs")).width(300));
        DialogManager.sendDialog((Player)player, (DialogManager.DialogBuilder)builder);
    }

    private void addBodySection(DialogManager.MultiActionDialogBuilder builder, List<TextComponent> components) {
        if (components == null || components.isEmpty()) {
            return;
        }
        StringBuilder text = new StringBuilder();
        for (TextComponent component : components) {
            if (component.getText() == null) continue;
            text.append(QuestCheckCommand.processText(component.getText())).append("\n");
        }
        if (!text.isEmpty()) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)text.toString().trim()).width(300));
        }
    }

    private void addBodySectionWithHeader(DialogManager.MultiActionDialogBuilder builder, TextComponent header, List<TextComponent> items) {
        if (header != null && header.getText() != null) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)QuestCheckCommand.processText(header.getText())).width(300));
        }
        if (items != null && !items.isEmpty()) {
            StringBuilder text = new StringBuilder();
            for (TextComponent item : items) {
                if (item.getText() == null) continue;
                text.append("  ").append(QuestCheckCommand.processText(item.getText())).append("\n");
            }
            if (!text.isEmpty()) {
                builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)text.toString().trim()).width(300));
            }
        }
    }

    private void addBodySectionWithRewards(DialogManager.MultiActionDialogBuilder builder, TextComponent header, List<TextComponent> items, Quest quest) {
        if (header != null && header.getText() != null) {
            builder.addBody((DialogManager.BodyElement)DialogManager.PlainMessageBody.of((String)QuestCheckCommand.processText(header.getText())).width(300));
        }
        if (quest != null && quest.getQuestObjectives().getQuestReward().previewRewards() != null && !quest.getQuestObjectives().getQuestReward().previewRewards().isEmpty()) {
            List<ItemStack> previewRewards = quest.getQuestObjectives().getQuestReward().previewRewards();
            for (int i = 0; i < previewRewards.size(); ++i) {
                ItemStack itemStack = previewRewards.get(i);
                if (itemStack == null) continue;
                String itemId = itemStack.getType().getKey().toString();
                String description = "";
                if (items != null && i < items.size() && items.get(i).getText() != null) {
                    description = QuestCheckCommand.processText(items.get(i).getText());
                }
                DialogManager.ItemBody itemBody = DialogManager.ItemBody.of((String)itemId, (int)itemStack.getAmount()).showTooltip(true).showDecoration(true);
                JsonObject components = DialogManager.serializeItemComponents((ItemStack)itemStack);
                if (components != null && !components.entrySet().isEmpty()) {
                    this.fixCustomModelDataFormat(components);
                    itemBody.components(components);
                }
                if (!description.isEmpty()) {
                    itemBody.description(description);
                }
                builder.addBody((DialogManager.BodyElement)itemBody);
            }
        } else {
            this.addBodySection(builder, items);
        }
    }

    private void addActionButtons(DialogManager.MultiActionDialogBuilder builder, Quest quest, QuestMenu.QuestText questText) {
        builder.columns(1);
        this.addButtonFromComponent(builder, questText.getAccept());
        this.addButtonFromComponent(builder, questText.getTrack());
    }

    private void addButtonFromComponent(DialogManager.MultiActionDialogBuilder builder, TextComponent component) {
        String command;
        if (component == null || component.getText() == null || component.getText().isEmpty()) {
            return;
        }
        String text = QuestCheckCommand.processText(component.getText());
        if (text.contains("[Abandon]")) {
            text = "\u00a7l\u00a7c[Abandon]";
        }
        if ((command = this.extractCommandFromComponent(component)) != null && !command.isEmpty()) {
            builder.addAction(DialogManager.ActionButton.of((String)text, (DialogManager.Action)new DialogManager.RunCommandAction(command)).width(100));
        }
    }

    private String extractCommandFromComponent(TextComponent component) {
        if (component == null) {
            return null;
        }
        try {
            if (component.getClickEvent() != null && component.getClickEvent().getAction() == ClickEvent.Action.RUN_COMMAND) {
                return component.getClickEvent().getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void fixCustomModelDataFormat(JsonObject components) {
        JsonElement element;
        String key = "minecraft:custom_model_data";
        if (components.has(key) && (element = components.get(key)).isJsonPrimitive()) {
            double value = element.getAsDouble();
            JsonObject newFormat = new JsonObject();
            JsonArray floats = new JsonArray();
            floats.add((Number)value);
            newFormat.add("floats", (JsonElement)floats);
            components.add(key, (JsonElement)newFormat);
        }
    }
}

