/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.config.wormholes.WormholeConfig;
import com.magmaguy.elitemobs.wormhole.Wormhole;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.IntegerCommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import org.bukkit.command.CommandSender;

public class PlaceWormholeCommand
extends AdvancedCommand {
    public PlaceWormholeCommand() {
        super(List.of("place"));
        this.addLiteral("wormhole");
        this.addArgument("filename", (ICommandArgument)new ListStringCommandArgument(WormholeConfig.getWormholes().keySet().stream().toList(), "<filename>"));
        this.addArgument("wormholeOption", (ICommandArgument)new IntegerCommandArgument(List.of(Integer.valueOf(1), Integer.valueOf(2)), "<1>/<2>"));
        this.setUsage("/em place wormhole <filename> <1/2>");
        this.setPermission("elitemobs.place.admin");
        this.setSenderType(SenderType.PLAYER);
        this.setDescription("Place a wormhole teleport at your current location.");
    }

    public void execute(CommandData commandData) {
        for (Wormhole wormhole : Wormhole.getWormholes()) {
            if (!wormhole.getWormholeConfigFields().getFilename().equals(commandData.getStringArgument("filename"))) continue;
            switch (commandData.getStringArgument("wormholeOption")) {
                case "1": {
                    wormhole.getWormholeEntry1().updateLocation(commandData.getPlayerSender());
                    return;
                }
                case "2": {
                    wormhole.getWormholeEntry2().updateLocation(commandData.getPlayerSender());
                    return;
                }
            }
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"Not a valid wormhole option! Pick 1 or 2 to set either end of the wormhole.");
        }
        Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"Failed to set location for this wormhole.");
    }
}

