/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.commands.CustomBossCommandHandler;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlaceBossCommand
extends AdvancedCommand {
    public PlaceBossCommand() {
        super(List.of("place"));
        this.addLiteral("boss");
        ArrayList<String> regionalBosses = new ArrayList<String>();
        for (Map.Entry<String, ? extends CustomBossesConfigFields> entry : CustomBossesConfig.getCustomBosses().entrySet()) {
            if (!entry.getValue().isRegionalBoss()) continue;
            regionalBosses.add(entry.getKey());
        }
        this.addArgument("filename", (ICommandArgument)new ListStringCommandArgument(regionalBosses, "<filename>"));
        this.setUsage("/em place boss <filename>");
        this.setPermission("elitemobs.place.admin");
        this.setSenderType(SenderType.PLAYER);
        this.setDescription("Add a spawn location for the specified boss at your current location.");
    }

    public void execute(CommandData commandData) {
        CustomBossCommandHandler.addSpawnLocation(commandData.getStringArgument("filename"), commandData.getPlayerSender());
    }
}

