/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.ZipFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.bukkit.command.CommandSender;

public class PackageCommand {
    CommandSender commandSender;
    String dungeonFolderName;

    public PackageCommand(CommandSender commandSender, String dungeonFolderName, String versionNumber) {
        this.commandSender = commandSender;
        if (dungeonFolderName == null || dungeonFolderName.isEmpty()) {
            commandSender.sendMessage("[EliteMobs] This commands needs a valid dungeon name!");
            return;
        }
        int version = 0;
        try {
            version = Integer.parseInt(versionNumber);
        }
        catch (Exception exception) {
            commandSender.sendMessage("This command needs a valid natural number! (1, 2, 3, 4...)");
            return;
        }
        this.dungeonFolderName = dungeonFolderName;
        this.clearPreviousContents();
        this.packContents("custombosses");
        this.packContents("customevents");
        this.packContents("npcs");
        this.packContents("customitems");
        this.packContents("customquests");
        this.packContents("customarenas");
        this.packContents("customspawns");
        this.packContents("customtreasurechests");
        this.packContents("wormholes");
        this.packContents("world_blueprints");
        this.packContents("powers");
        commandSender.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &2Done! You can find your package in &9~/plugins/EliteMobs/exports &2. &6If you are making a dungeon, make sure to create your own dungeonpackages file!"));
        commandSender.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &6Don't forget to add your world and schematic files to the package if needed!"));
        try {
            ZipFile.ZipUtility.zip((File)new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + "exports" + File.separatorChar + dungeonFolderName), (String)(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + "exports" + File.separatorChar + dungeonFolderName + "_packaged.zip"));
        }
        catch (Exception exception) {
            commandSender.sendMessage(ChatColorConverter.convert((String)"4&[EliteMobs] Failed to zip package!"));
        }
        commandSender.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &6Zipped files for your convenience. Don't forget any additional files like the dungeonpackager or world/schematics files before distributing!"));
    }

    private void clearPreviousContents() {
        File targetFolder = new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + "exports" + File.separatorChar + this.dungeonFolderName);
        if (targetFolder.exists()) {
            this.delete(targetFolder.toPath());
        }
        if (new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + "exports" + File.separatorChar + this.dungeonFolderName + "_packaged.zip").exists()) {
            this.delete(Path.of(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + "exports" + File.separatorChar + this.dungeonFolderName + "_packaged.zip", new String[0]));
        }
    }

    private void delete(Path path) {
        for (File file : path.toFile().listFiles()) {
            if (file.isDirectory()) {
                this.delete(file.toPath());
                continue;
            }
            file.delete();
        }
    }

    private void packContents(String subdirectory) {
        Path path = Path.of(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + subdirectory + File.separatorChar + this.dungeonFolderName, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            this.commandSender.sendMessage("[EliteMobs] Could not find any " + subdirectory + " for this dungeon. This might be normal depending on your setup.");
            return;
        }
        File sourceFolder = new File(path.toString());
        File targetFolder = new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + File.separatorChar + "exports" + File.separatorChar + this.dungeonFolderName + File.separatorChar + subdirectory + File.separatorChar + this.dungeonFolderName);
        if (!targetFolder.exists()) {
            try {
                targetFolder.mkdirs();
                targetFolder.mkdir();
            }
            catch (Exception ex) {
                this.commandSender.sendMessage("[EliteMobs] Failed to create directory " + targetFolder.getPath());
                ex.printStackTrace();
                return;
            }
        }
        for (File file : sourceFolder.listFiles()) {
            this.recursivelyGetFiles(file, targetFolder);
        }
    }

    private void recursivelyGetFiles(File scannedFile, File destination) {
        try {
            if (scannedFile.isDirectory()) {
                File newDestination = new File(destination.getAbsolutePath() + File.separatorChar + scannedFile.getName());
                newDestination.mkdir();
                for (File file : scannedFile.listFiles()) {
                    this.recursivelyGetFiles(file, newDestination);
                }
            } else {
                Files.copy(scannedFile.toPath(), Path.of(destination.getAbsolutePath() + File.separatorChar + scannedFile.getName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception exception) {
            Logger.warn((String)"Failed to recursively pack dungeon!");
        }
    }
}

