/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.command.CommandSender;

public class LanguageCommand
extends AdvancedCommand {
    private static final List<String> REMOTE_LANGUAGES = List.of("french", "german", "spanish", "italian", "portuguese", "portugueseBrazilian", "russian", "chineseSimplified", "chineseTraditional", "japanese", "korean", "polish", "dutch", "czech", "hungarian", "romanian", "turkish", "vietnamese", "indonesian");
    private final List<String> suggestions;

    public LanguageCommand() {
        super(List.of("language"));
        LinkedHashSet<String> langs = new LinkedHashSet<String>();
        langs.add("english");
        langs.add("custom");
        langs.addAll(REMOTE_LANGUAGES);
        Path folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations");
        if (Files.isDirectory(folder, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder, "*.csv");){
                for (Path p : ds) {
                    String filename = p.getFileName().toString();
                    if (filename.endsWith("_data.csv")) continue;
                    langs.add(filename.replace(".csv", ""));
                }
            }
            catch (Exception e) {
                Logger.warn((String)("Could not list translations folder: " + e.getMessage()));
            }
        }
        this.suggestions = new ArrayList<String>(langs);
        this.addArgument("language", (ICommandArgument)new ListStringCommandArgument(this.suggestions, "<language>"));
        this.setUsage("/em language <language>");
        this.setPermission("elitemobs.language");
        this.setDescription("Sets the language for EliteMobs (downloads from remote if needed).");
    }

    public void execute(CommandData commandData) {
        String language = commandData.getStringArgument("language");
        CommandSender sender = commandData.getCommandSender();
        String finalLanguage = language = language.replace(".csv", "").replace(".yml", "");
        if (!this.suggestions.stream().anyMatch(s -> s.equalsIgnoreCase(finalLanguage))) {
            Logger.sendMessage((CommandSender)sender, (String)"&cLanguage not found. Valid options:");
            this.suggestions.forEach(s -> Logger.sendMessage((CommandSender)sender, (String)("  - " + s)));
            return;
        }
        if (language.equals("english")) {
            DefaultConfig.setLanguage(sender, language);
            Logger.sendMessage((CommandSender)sender, (String)"&2Language set to English! Using plugin defaults.");
            return;
        }
        if (language.equals("custom")) {
            Path folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations");
            Path target = folder.resolve("custom.csv");
            if (!Files.exists(target, new LinkOption[0])) {
                Logger.sendMessage((CommandSender)sender, (String)"&eGenerating custom.csv template...");
                if (!this.generateCustomCsv(target)) {
                    Logger.sendMessage((CommandSender)sender, (String)"&cFailed to generate custom.csv. Language not changed.");
                    return;
                }
                Logger.sendMessage((CommandSender)sender, (String)"&2Generated custom.csv! Edit it to customize text or add translations.");
            }
            DefaultConfig.setLanguage(sender, language);
            Logger.sendMessage((CommandSender)sender, (String)"&2Language set to custom! &eEdit plugins/EliteMobs/translations/custom.csv to customize text. New keys will be added automatically as the plugin runs.");
            return;
        }
        Path folder = Paths.get(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath(), "translations");
        Path target = folder.resolve(language + ".csv");
        if (!Files.exists(target, new LinkOption[0])) {
            Logger.sendMessage((CommandSender)sender, (String)("&eDownloading " + language + ".csv..."));
            if (!this.downloadRemoteLanguage(language, target)) {
                Logger.sendMessage((CommandSender)sender, (String)("&cFailed to download " + language + ".csv. Language not changed."));
                return;
            }
            Logger.sendMessage((CommandSender)sender, (String)("&2Downloaded " + language + ".csv successfully."));
        }
        DefaultConfig.setLanguage(sender, language);
        Logger.sendMessage((CommandSender)sender, (String)("&2Language set to " + language + "! &eTranslations are community-managed. Use at your own discretion."));
    }

    private boolean generateCustomCsv(Path outPath) {
        try {
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            String header = "\ufeff\"key\",\"en\",\"custom\"\n";
            Files.writeString(outPath, (CharSequence)header, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return true;
        }
        catch (Exception ex) {
            Logger.warn((String)("Error generating custom.csv: " + ex.getMessage()));
            return false;
        }
    }

    private boolean downloadRemoteLanguage(String language, Path outPath) {
        String apiUrl = "https://magmaguy.com/api/elitemobs_translations/" + language + ".csv";
        try {
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                Logger.warn((String)("Download failed: HTTP " + responseCode + " for " + language + ".csv"));
                return false;
            }
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            try (InputStream in = conn.getInputStream();
                 OutputStream out = Files.newOutputStream(outPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                int bytesRead;
                byte[] buf = new byte[8192];
                while ((bytesRead = in.read(buf)) != -1) {
                    out.write(buf, 0, bytesRead);
                }
            }
            conn.disconnect();
            return true;
        }
        catch (Exception ex) {
            Logger.warn((String)("Error downloading " + language + ".csv: " + ex.getMessage()));
            return false;
        }
    }
}

