/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.utils.DebugBlockLocation;
import com.magmaguy.magmacore.util.ChatColorConverter;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CustomBossCommandHandler {
    private CustomBossCommandHandler() {
    }

    public static Location autoSeekSafeSpawnLocation(Location originalLocation) {
        Location newLocation = new Location(originalLocation.getWorld(), (double)originalLocation.getBlockX() + 0.5, (double)originalLocation.getBlockY() + 0.5, (double)originalLocation.getBlockZ() + 0.5);
        for (int i = 0; i < 4; ++i) {
            if (!newLocation.add(new Vector(0, i, 0)).getBlock().isPassable()) continue;
            new DebugBlockLocation(newLocation);
            return newLocation;
        }
        return null;
    }

    public static void addSpawnLocation(String customBossConfigFieldsString, Player player) {
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfigFields.getRegionalElites().get(customBossConfigFieldsString);
        if (customBossesConfigFields == null) {
            player.sendMessage(ChatColorConverter.convert((String)("&8[EliteMobs] &4Failed to add spawn location! Custom Boss " + customBossConfigFieldsString + " is not valid regional boss!")));
        } else {
            Location safeSpawnLocation = CustomBossCommandHandler.autoSeekSafeSpawnLocation(player.getLocation());
            if (safeSpawnLocation == null) {
                player.sendMessage("[EliteMobs] No safe spawn location found! Make sure the area is passable!");
            } else {
                RegionalBossEntity.createPermanentRegionalBossEntity(customBossesConfigFields, safeSpawnLocation);
            }
        }
    }

    public static void setLeashRadius(String customBossConfigFieldsString, CommandSender commandSender, int leashRadius) {
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfigFields.getRegionalElites().get(customBossConfigFieldsString);
        if (customBossesConfigFields == null) {
            commandSender.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &4Failed set the leash radius! Was the boss a valid regional boss?"));
            return;
        }
        customBossesConfigFields.runtimeSetLeashRadius(leashRadius);
        for (RegionalBossEntity regionalBossEntity : RegionalBossEntity.getRegionalBossEntitySet()) {
            if (!customBossesConfigFields.getFilename().equals(regionalBossEntity.getCustomBossesConfigFields().getFilename())) continue;
            regionalBossEntity.setLeashRadius(leashRadius);
        }
    }
}

