/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.combatsystem.displays;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.EliteMobEnterCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobHealEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.premade.CriticalStrikesConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Round;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class BossHealthDisplay
implements Listener {
    private static final String FULL_BAR = "\u258c";
    private static final String EMPTY_BAR = "\u258c";
    private static final int BARS_PER_ROW = 10;
    private static final String COLOR_FULL_HIGH = "&a";
    private static final String COLOR_FULL_MED = "&e";
    private static final String COLOR_FULL_LOW = "&c";
    private static final String COLOR_FULL_CRITICAL = "&4";
    private static final String COLOR_EMPTY = "&8";
    private static final String COLOR_DAMAGE = "&c";
    private static final String COLOR_HEAL = "&a";
    private static final String COLOR_CRIT = "&d";
    private static final double PROXIMITY_RANGE = 30.0;
    private static final int POPUP_DURATION_TICKS = 20;
    private static final Map<UUID, HealthDisplayData> activeDisplays = new ConcurrentHashMap<UUID, HealthDisplayData>();
    private static final List<PopupData> activePopups = Collections.synchronizedList(new ArrayList());
    private static BukkitTask masterUpdateTask = null;

    public static void startMasterUpdateTask() {
        if (masterUpdateTask != null) {
            return;
        }
        masterUpdateTask = new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Iterator<Map.Entry<UUID, HealthDisplayData>> iterator = activeDisplays.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<UUID, HealthDisplayData> entry = iterator.next();
                    HealthDisplayData data = entry.getValue();
                    if (!data.isValid()) {
                        data.cleanup();
                        iterator.remove();
                        continue;
                    }
                    if (data.checkCombatTimeout()) {
                        data.cleanup();
                        iterator.remove();
                        continue;
                    }
                    data.updatePositions();
                    data.updateProximityBossBar();
                }
                List<PopupData> list = activePopups;
                synchronized (list) {
                    Iterator<PopupData> popupIterator = activePopups.iterator();
                    while (popupIterator.hasNext()) {
                        PopupData popup = popupIterator.next();
                        if (popup.update()) continue;
                        popup.cleanup();
                        popupIterator.remove();
                    }
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (masterUpdateTask != null) {
            masterUpdateTask.cancel();
            masterUpdateTask = null;
        }
        for (HealthDisplayData data : activeDisplays.values()) {
            data.cleanup();
        }
        activeDisplays.clear();
        List<PopupData> list = activePopups;
        synchronized (list) {
            for (PopupData popup : activePopups) {
                popup.cleanup();
            }
            activePopups.clear();
        }
    }

    private static HealthDisplayData getOrCreateDisplay(EliteEntity eliteEntity) {
        return activeDisplays.computeIfAbsent(eliteEntity.getEliteUUID(), uuid -> new HealthDisplayData(eliteEntity));
    }

    public static void removeDisplay(EliteEntity eliteEntity) {
        HealthDisplayData data = activeDisplays.remove(eliteEntity.getEliteUUID());
        if (data != null) {
            data.cleanup();
        }
    }

    private void createDamagePopup(EliteEntity eliteEntity, double damage, boolean isCritical, double damageModifier, Vector offset, Player player) {
        if (!MobCombatSettingsConfig.isDisplayDamageOnHit()) {
            return;
        }
        LivingEntity entity = eliteEntity.getUnsyncedLivingEntity();
        if (entity == null || !entity.isValid()) {
            return;
        }
        Location baseLoc = entity.getLocation().clone();
        Location mobLocation = eliteEntity.getLocation();
        double eyeHeight = entity.getEyeHeight();
        baseLoc.add(offset.getX(), eyeHeight + offset.getY() + 0.3, offset.getZ());
        StringBuilder textBuilder = new StringBuilder();
        if (damageModifier < 1.0) {
            textBuilder.append(MobCombatSettingsConfig.getResistTextColor());
            if (mobLocation.getWorld() != null) {
                mobLocation.getWorld().playSound(mobLocation, Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
            }
            if (MobCombatSettingsConfig.isDoResistEffect() && player != null) {
                this.createResistArmorStandEffect(eliteEntity, player);
            }
        } else if (damageModifier > 1.0) {
            textBuilder.append(MobCombatSettingsConfig.getWeakTextColor());
            if (mobLocation.getWorld() != null) {
                mobLocation.getWorld().playSound(mobLocation, Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            }
            if (MobCombatSettingsConfig.isDoWeakEffect() && player != null) {
                this.createWeakVisualEffect(eliteEntity, player);
            }
        } else {
            textBuilder.append("&c");
        }
        if (isCritical) {
            textBuilder.append(CriticalStrikesConfig.getCriticalHitColor());
            textBuilder.append("&l");
        }
        textBuilder.append(Round.twoDecimalPlaces((double)damage));
        this.createAnimatedPopup(baseLoc, ChatColorConverter.convert((String)textBuilder.toString()), isCritical ? PopupType.CRITICAL : PopupType.DAMAGE, isCritical ? 1.3f : 1.0f);
        if (damageModifier < 1.0) {
            modifierOffset = offset.clone().subtract(new Vector(0.0, 0.3, 0.0));
            modifierLoc = entity.getLocation().clone();
            modifierLoc.add(modifierOffset.getX(), eyeHeight + modifierOffset.getY() + 0.3, modifierOffset.getZ());
            this.createAnimatedPopup(modifierLoc, ChatColorConverter.convert((String)MobCombatSettingsConfig.getResistText()), PopupType.RESIST, 0.8f);
        } else if (damageModifier > 1.0) {
            modifierOffset = offset.clone().subtract(new Vector(0.0, 0.3, 0.0));
            modifierLoc = entity.getLocation().clone();
            modifierLoc.add(modifierOffset.getX(), eyeHeight + modifierOffset.getY() + 0.3, modifierOffset.getZ());
            this.createAnimatedPopup(modifierLoc, ChatColorConverter.convert((String)MobCombatSettingsConfig.getWeakText()), PopupType.WEAK, 0.8f);
        }
        if (isCritical) {
            Vector critOffset = offset.clone().add(new Vector(0.0, 0.4, 0.0));
            Location critLoc = entity.getLocation().clone();
            critLoc.add(critOffset.getX(), eyeHeight + critOffset.getY() + 0.3, critOffset.getZ());
            this.createAnimatedPopup(critLoc, ChatColorConverter.convert((String)CriticalStrikesConfig.getCriticalHitPopup()), PopupType.CRITICAL, 0.9f);
        }
    }

    private void createResistArmorStandEffect(final EliteEntity eliteEntity, final Player player) {
        if (!eliteEntity.isValid() || !player.isValid()) {
            return;
        }
        if (!eliteEntity.getLocation().getWorld().equals(player.getWorld())) {
            return;
        }
        Location armorStandLocation = this.getResistLocation(player, eliteEntity);
        if (armorStandLocation.getWorld() == null) {
            return;
        }
        try {
            final ArmorStand armorStand = (ArmorStand)armorStandLocation.getWorld().spawn(armorStandLocation, ArmorStand.class, as -> {
                as.setVisible(false);
                as.setGravity(false);
                as.setMarker(true);
                as.setPersistent(false);
                as.getEquipment().setItemInMainHand(new ItemStack(Material.SHIELD));
                as.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.REMOVING_OR_CHANGING);
                as.setRightArmPose(new EulerAngle(1.5707963267948966, 4.71238898038469, Math.PI));
            });
            EntityTracker.registerVisualEffects((Entity)armorStand);
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    if (!(this.counter <= 20 && eliteEntity.isValid() && player.isValid() && eliteEntity.getLocation().getWorld().equals(player.getWorld()))) {
                        EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                        this.cancel();
                        return;
                    }
                    try {
                        armorStand.teleport(BossHealthDisplay.this.getResistLocation(player, eliteEntity));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++this.counter;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Location getResistLocation(Player player, EliteEntity eliteEntity) {
        Vector armorStandVector = player.getLocation().subtract(eliteEntity.getLocation()).toVector().normalize().multiply(1.5);
        Location armorStandLocation = eliteEntity.getLocation().add(armorStandVector);
        armorStandLocation.setDirection(armorStandVector);
        return armorStandLocation;
    }

    private void createWeakVisualEffect(final EliteEntity eliteEntity, final Player player) {
        if (!eliteEntity.isValid() || !player.isValid()) {
            return;
        }
        if (!eliteEntity.getLocation().getWorld().equals(player.getWorld())) {
            return;
        }
        final TextDisplay[] textDisplays = new TextDisplay[]{this.generateWeakTextDisplay(player, eliteEntity, -1), this.generateWeakTextDisplay(player, eliteEntity, 1)};
        if (textDisplays[0] == null || textDisplays[1] == null) {
            return;
        }
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!(this.counter <= 10 && eliteEntity.isValid() && player.isValid() && eliteEntity.getLocation().getWorld().equals(player.getWorld()))) {
                    if (textDisplays[0] != null) {
                        EntityTracker.unregister((Entity)textDisplays[0], RemovalReason.EFFECT_TIMEOUT);
                    }
                    if (textDisplays[1] != null) {
                        EntityTracker.unregister((Entity)textDisplays[1], RemovalReason.EFFECT_TIMEOUT);
                    }
                    this.cancel();
                    return;
                }
                for (TextDisplay display : textDisplays) {
                    if (display == null || !display.isValid()) continue;
                    display.teleport(display.getLocation().add(eliteEntity.getLocation().subtract(display.getLocation()).toVector().normalize().multiply(0.4)));
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }

    private TextDisplay generateWeakTextDisplay(Player player, EliteEntity eliteEntity, int offset) {
        Vector displayVector = player.getLocation().clone().add(new Vector(0, 2, 0)).subtract(eliteEntity.getLocation()).toVector().normalize().multiply(3.0).rotateAroundY(0.39269908169872414 * (double)offset);
        Location displayLocation = eliteEntity.getLocation().add(displayVector);
        displayLocation.setDirection(displayVector.multiply(-1));
        if (displayLocation.getWorld() == null) {
            return null;
        }
        try {
            TextDisplay display = (TextDisplay)displayLocation.getWorld().spawn(displayLocation, TextDisplay.class, td -> {
                td.setText(ChatColorConverter.convert((String)"&9&l\u2726"));
                td.setPersistent(false);
                td.setBillboard(Display.Billboard.CENTER);
                td.setShadowed(true);
                td.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
            });
            EntityTracker.registerVisualEffects((Entity)display);
            return display;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createHealPopup(EliteEntity eliteEntity, double healAmount, boolean isFullHeal) {
        if (!MobCombatSettingsConfig.isDisplayDamageOnHit()) {
            return;
        }
        LivingEntity entity = eliteEntity.getUnsyncedLivingEntity();
        if (entity == null || !entity.isValid()) {
            return;
        }
        Vector offset = new Vector(ThreadLocalRandom.current().nextDouble(-1.0, 1.0), 0.0, ThreadLocalRandom.current().nextDouble(-1.0, 1.0));
        Location baseLoc = entity.getLocation().clone();
        double eyeHeight = entity.getEyeHeight();
        baseLoc.add(offset.getX(), eyeHeight + 0.3, offset.getZ());
        Object text = isFullHeal ? MobCombatSettingsConfig.getFullHealMessage() : "&a+" + Round.twoDecimalPlaces((double)healAmount) + " HP";
        this.createAnimatedPopup(baseLoc, ChatColorConverter.convert((String)text), PopupType.HEAL, isFullHeal ? 1.2f : 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAnimatedPopup(Location location, String text, PopupType type, float scale) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        try {
            TextDisplay display = (TextDisplay)location.getWorld().spawn(location, TextDisplay.class, textDisplay -> {
                textDisplay.setText(text);
                textDisplay.setPersistent(false);
                textDisplay.setBillboard(Display.Billboard.CENTER);
                textDisplay.setShadowed(true);
                textDisplay.setSeeThrough(false);
                switch (type) {
                    case DAMAGE: {
                        textDisplay.setBackgroundColor(Color.fromARGB((int)100, (int)50, (int)0, (int)0));
                        break;
                    }
                    case CRITICAL: {
                        textDisplay.setBackgroundColor(Color.fromARGB((int)120, (int)80, (int)0, (int)80));
                        break;
                    }
                    case HEAL: {
                        textDisplay.setBackgroundColor(Color.fromARGB((int)100, (int)0, (int)50, (int)0));
                        break;
                    }
                    case WEAK: {
                        textDisplay.setBackgroundColor(Color.fromARGB((int)100, (int)0, (int)0, (int)80));
                        break;
                    }
                    case RESIST: {
                        textDisplay.setBackgroundColor(Color.fromARGB((int)100, (int)80, (int)0, (int)0));
                    }
                }
                textDisplay.setInterpolationDelay(0);
                textDisplay.setInterpolationDuration(20);
                Transformation transformation = new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector3f(scale, scale, scale), new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
                textDisplay.setTransformation(transformation);
            });
            EntityTracker.registerVisualEffects((Entity)display);
            List<PopupData> list = activePopups;
            synchronized (list) {
                activePopups.add(new PopupData(display, location, type, scale));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (!eliteEntity.isValid()) {
            return;
        }
        Vector offset = new Vector(ThreadLocalRandom.current().nextDouble(-1.5, 1.5), 0.0, ThreadLocalRandom.current().nextDouble(-1.5, 1.5));
        this.createDamagePopup(eliteEntity, event.getDamage(), event.isCriticalStrike(), event.getDamageModifier(), offset, event.getPlayer());
        if (MobCombatSettingsConfig.isDisplayVisualHealthBars() || MobCombatSettingsConfig.isDisplayNumericHealth() || MobCombatSettingsConfig.isDisplayBossBarForHighMultiplier()) {
            HealthDisplayData data = BossHealthDisplay.getOrCreateDisplay(eliteEntity);
            data.resetCombatTimer();
            data.updateHealthDisplay();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHeal(EliteMobHealEvent event) {
        HealthDisplayData data;
        EliteEntity eliteEntity = event.getEliteEntity();
        if (!eliteEntity.isValid()) {
            return;
        }
        this.createHealPopup(eliteEntity, event.getHealAmount(), event.isFullHeal());
        if ((MobCombatSettingsConfig.isDisplayVisualHealthBars() || MobCombatSettingsConfig.isDisplayNumericHealth()) && (data = activeDisplays.get(eliteEntity.getEliteUUID())) != null) {
            data.updateHealthDisplay();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEnterCombat(EliteMobEnterCombatEvent event) {
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (!eliteEntity.isValid()) {
            return;
        }
        if (MobCombatSettingsConfig.isDisplayVisualHealthBars() || MobCombatSettingsConfig.isDisplayNumericHealth() || MobCombatSettingsConfig.isDisplayBossBarForHighMultiplier()) {
            CustomBossEntity customBoss;
            double healthMultiplier;
            HealthDisplayData data = BossHealthDisplay.getOrCreateDisplay(eliteEntity);
            data.resetCombatTimer();
            if (MobCombatSettingsConfig.isDisplayBossBarForHighMultiplier() && eliteEntity instanceof CustomBossEntity && (healthMultiplier = (customBoss = (CustomBossEntity)eliteEntity).getHealthMultiplier()) > MobCombatSettingsConfig.getBossBarHealthMultiplierThreshold()) {
                data.showBossBarForPlayer(event.getTargetEntity());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onExitCombat(EliteMobExitCombatEvent event) {
        EliteEntity eliteEntity = event.getEliteMobEntity();
        BossHealthDisplay.removeDisplay(eliteEntity);
    }

    private static class HealthDisplayData {
        private final EliteEntity eliteEntity;
        private final List<TextDisplay> healthBarDisplays = new ArrayList<TextDisplay>();
        private final Map<Player, BossBar> playerBossBars = new ConcurrentHashMap<Player, BossBar>();
        private final double healthMultiplier;
        private TextDisplay numericDisplay = null;
        private long lastCombatTime;

        public HealthDisplayData(EliteEntity eliteEntity) {
            this.eliteEntity = eliteEntity;
            this.lastCombatTime = System.currentTimeMillis();
            if (eliteEntity instanceof CustomBossEntity) {
                CustomBossEntity customBoss = (CustomBossEntity)eliteEntity;
                this.healthMultiplier = customBoss.getHealthMultiplier();
            } else {
                this.healthMultiplier = eliteEntity.getHealthMultiplier();
            }
        }

        public boolean isValid() {
            return this.eliteEntity != null && this.eliteEntity.isValid();
        }

        public void resetCombatTimer() {
            this.lastCombatTime = System.currentTimeMillis();
        }

        public boolean checkCombatTimeout() {
            int timeoutSeconds;
            long elapsed = System.currentTimeMillis() - this.lastCombatTime;
            return elapsed > (long)(timeoutSeconds = MobCombatSettingsConfig.getCombatDisplayTimeoutSeconds()) * 1000L;
        }

        public void updateHealthDisplay() {
            if (!this.isValid()) {
                return;
            }
            double currentHealth = this.eliteEntity.getHealth();
            double maxHealth = this.eliteEntity.getMaxHealth();
            this.cleanupVisualDisplays();
            if (MobCombatSettingsConfig.isDisplayVisualHealthBars()) {
                this.createHealthBars(currentHealth, maxHealth);
            }
            if (MobCombatSettingsConfig.isDisplayNumericHealth()) {
                this.createNumericDisplay(currentHealth, maxHealth);
            }
            this.updateAllBossBars(currentHealth, maxHealth);
        }

        private void cleanupVisualDisplays() {
            if (this.numericDisplay != null && this.numericDisplay.isValid()) {
                EntityTracker.unregister((Entity)this.numericDisplay, RemovalReason.EFFECT_TIMEOUT);
                this.numericDisplay = null;
            }
            for (TextDisplay display : this.healthBarDisplays) {
                if (display == null || !display.isValid()) continue;
                EntityTracker.unregister((Entity)display, RemovalReason.EFFECT_TIMEOUT);
            }
            this.healthBarDisplays.clear();
        }

        private void createHealthBars(double currentHealth, double maxHealth) {
            if (!this.isValid()) {
                return;
            }
            Location baseLoc = this.getBaseLocation();
            if (baseLoc == null) {
                return;
            }
            BarLayout layout = this.calculateBarLayout();
            int totalBars = layout.totalBars;
            int barsPerRow = layout.barsPerRow;
            int rows = layout.rows;
            int filledBars = (int)Math.ceil(currentHealth / maxHealth * (double)totalBars);
            double healthPercent = currentHealth / maxHealth * 100.0;
            String filledColor = this.getHealthColor(healthPercent);
            int barsRemaining = filledBars;
            int totalBarsRemaining = totalBars;
            for (int row = 0; row < rows; ++row) {
                int i;
                int barsInThisRow = Math.min(barsPerRow, totalBarsRemaining);
                int filledInThisRow = Math.min(barsInThisRow, barsRemaining);
                StringBuilder barText = new StringBuilder();
                for (i = 0; i < filledInThisRow; ++i) {
                    barText.append(filledColor).append("\u258c");
                }
                for (i = filledInThisRow; i < barsInThisRow; ++i) {
                    barText.append(BossHealthDisplay.COLOR_EMPTY).append("\u258c");
                }
                Location displayLoc = baseLoc.clone().add(0.0, (double)row * 0.22, 0.0);
                TextDisplay display = this.createHealthBarDisplay(displayLoc, ChatColorConverter.convert((String)barText.toString()));
                if (display != null) {
                    this.healthBarDisplays.add(display);
                }
                barsRemaining -= filledInThisRow;
                totalBarsRemaining -= barsInThisRow;
            }
        }

        private void createNumericDisplay(double currentHealth, double maxHealth) {
            if (!this.isValid()) {
                return;
            }
            double healthPercent = currentHealth / maxHealth * 100.0;
            String color = this.getHealthColor(healthPercent);
            String numericText = color + "&l" + Round.twoDecimalPlaces((double)currentHealth) + " &7/ " + color + "&l" + Round.twoDecimalPlaces((double)maxHealth);
            Location baseLoc = this.getBaseLocation();
            if (baseLoc == null) {
                return;
            }
            BarLayout layout = this.calculateBarLayout();
            int rows = MobCombatSettingsConfig.isDisplayVisualHealthBars() ? layout.rows : 0;
            Location numericLoc = baseLoc.clone().add(0.0, (double)rows * 0.22, 0.0);
            this.numericDisplay = this.createHealthBarDisplay(numericLoc, ChatColorConverter.convert((String)numericText));
        }

        private BarLayout calculateBarLayout() {
            if (MobCombatSettingsConfig.isUseFixedHealthBarSize()) {
                return new BarLayout(10, 10, 1);
            }
            if (this.healthMultiplier <= 0.0) {
                return new BarLayout(10, 10, 1);
            }
            if (this.healthMultiplier < 1.0) {
                int totalBars = Math.max(1, (int)Math.round(10.0 * this.healthMultiplier));
                return new BarLayout(totalBars, totalBars, 1);
            }
            if (this.healthMultiplier <= 1.0) {
                return new BarLayout(10, 10, 1);
            }
            double logScale = Math.log(this.healthMultiplier) / Math.log(20.0);
            int totalBars = (int)Math.ceil(10.0 + 10.0 * logScale);
            if ((totalBars = Math.min(totalBars, 20)) <= 10) {
                return new BarLayout(totalBars, totalBars, 1);
            }
            int barsPerRow = (int)Math.ceil((double)totalBars / 2.0);
            return new BarLayout(totalBars, barsPerRow, 2);
        }

        private String getHealthColor(double healthPercent) {
            if (healthPercent > 75.0) {
                return "&a";
            }
            if (healthPercent > 50.0) {
                return BossHealthDisplay.COLOR_FULL_MED;
            }
            if (healthPercent > 25.0) {
                return "&c";
            }
            return BossHealthDisplay.COLOR_FULL_CRITICAL;
        }

        private Location getBaseLocation() {
            Location nametagLocation;
            CustomBossEntity customBoss;
            if (!this.isValid()) {
                return null;
            }
            LivingEntity entity = this.eliteEntity.getLivingEntity();
            if (entity == null) {
                return null;
            }
            EliteEntity eliteEntity = this.eliteEntity;
            if (eliteEntity instanceof CustomBossEntity && (customBoss = (CustomBossEntity)eliteEntity).getCustomModel() != null && (nametagLocation = customBoss.getCustomModel().getNametagBoneLocation()) != null) {
                return nametagLocation.clone().subtract(0.0, 0.9, 0.0);
            }
            double height = entity.getEyeHeight() + 0.8;
            return entity.getLocation().clone().add(0.0, height, 0.0);
        }

        private TextDisplay createHealthBarDisplay(Location location, String text) {
            if (location == null || location.getWorld() == null) {
                return null;
            }
            try {
                TextDisplay display = (TextDisplay)location.getWorld().spawn(location, TextDisplay.class, textDisplay -> {
                    textDisplay.setText(text);
                    textDisplay.setPersistent(false);
                    textDisplay.setBillboard(Display.Billboard.CENTER);
                    textDisplay.setShadowed(true);
                    textDisplay.setSeeThrough(false);
                    textDisplay.setBackgroundColor(Color.fromARGB((int)80, (int)0, (int)0, (int)0));
                });
                EntityTracker.registerVisualEffects((Entity)display);
                return display;
            }
            catch (Exception e) {
                return null;
            }
        }

        public void updatePositions() {
            if (!this.isValid()) {
                return;
            }
            Location baseLoc = this.getBaseLocation();
            if (baseLoc == null) {
                return;
            }
            BarLayout layout = this.calculateBarLayout();
            for (int i = 0; i < this.healthBarDisplays.size(); ++i) {
                TextDisplay display = this.healthBarDisplays.get(i);
                if (display == null || !display.isValid()) continue;
                Location newLoc = baseLoc.clone().add(0.0, (double)i * 0.22, 0.0);
                display.teleport(newLoc);
            }
            if (this.numericDisplay != null && this.numericDisplay.isValid()) {
                int rows = MobCombatSettingsConfig.isDisplayVisualHealthBars() ? layout.rows : 0;
                Location numericLoc = baseLoc.clone().add(0.0, (double)rows * 0.22, 0.0);
                this.numericDisplay.teleport(numericLoc);
            }
        }

        public void showBossBarForPlayer(Player player) {
            if (player == null || !player.isValid()) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            if (this.playerBossBars.containsKey(player)) {
                return;
            }
            String bossName = this.eliteEntity.getName();
            if (bossName == null) {
                bossName = "Elite Boss";
            }
            BossBar bossBar = Bukkit.createBossBar((String)bossName, (BarColor)this.getBarColor(this.eliteEntity.getHealth() / this.eliteEntity.getMaxHealth()), (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
            double progress = Math.max(0.0, Math.min(1.0, this.eliteEntity.getHealth() / this.eliteEntity.getMaxHealth()));
            bossBar.setProgress(progress);
            bossBar.addPlayer(player);
            this.playerBossBars.put(player, bossBar);
        }

        public void removeBossBarForPlayer(Player player) {
            BossBar bossBar = this.playerBossBars.remove(player);
            if (bossBar != null) {
                bossBar.removePlayer(player);
                bossBar.removeAll();
            }
        }

        public void updateAllBossBars(double currentHealth, double maxHealth) {
            double progress = Math.max(0.0, Math.min(1.0, currentHealth / maxHealth));
            BarColor color = this.getBarColor(progress);
            Iterator<Map.Entry<Player, BossBar>> iterator = this.playerBossBars.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Player, BossBar> entry = iterator.next();
                Player player = entry.getKey();
                BossBar bossBar = entry.getValue();
                if (!player.isValid() || !player.isOnline()) {
                    bossBar.removeAll();
                    iterator.remove();
                    continue;
                }
                bossBar.setProgress(progress);
                bossBar.setColor(color);
            }
        }

        public void updateProximityBossBar() {
            double distance;
            Player player;
            if (!MobCombatSettingsConfig.isDisplayBossBarForHighMultiplier()) {
                return;
            }
            if (this.healthMultiplier < MobCombatSettingsConfig.getProximityBossBarHealthMultiplierThreshold()) {
                return;
            }
            if (!this.isValid()) {
                return;
            }
            Location bossLoc = this.eliteEntity.getLocation();
            if (bossLoc == null || bossLoc.getWorld() == null) {
                return;
            }
            LivingEntity livingEntity = this.eliteEntity.getLivingEntity();
            if (livingEntity == null) {
                return;
            }
            for (Entity entity : livingEntity.getNearbyEntities(30.0, 30.0, 30.0)) {
                if (!(entity instanceof Player)) continue;
                player = (Player)entity;
                distance = player.getLocation().distance(bossLoc);
                if (distance <= 30.0) {
                    if (this.playerBossBars.containsKey(player)) continue;
                    this.showBossBarForPlayer(player);
                    continue;
                }
                if (this.eliteEntity.getDamagers().containsKey(player)) continue;
                this.removeBossBarForPlayer(player);
            }
            Iterator<Map.Entry<Player, BossBar>> iterator = this.playerBossBars.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Player, BossBar> entry = iterator.next();
                player = entry.getKey();
                if (!player.isValid() || !player.isOnline()) {
                    entry.getValue().removeAll();
                    iterator.remove();
                    continue;
                }
                if (!player.getWorld().equals(bossLoc.getWorld())) {
                    entry.getValue().removeAll();
                    iterator.remove();
                    continue;
                }
                distance = player.getLocation().distance(bossLoc);
                if (!(distance > 30.0) || this.eliteEntity.getDamagers().containsKey(player)) continue;
                entry.getValue().removeAll();
                iterator.remove();
            }
        }

        private BarColor getBarColor(double healthRatio) {
            if (healthRatio > 0.75) {
                return BarColor.GREEN;
            }
            if (healthRatio > 0.5) {
                return BarColor.YELLOW;
            }
            if (healthRatio > 0.25) {
                return BarColor.RED;
            }
            return BarColor.RED;
        }

        public void cleanup() {
            this.cleanupVisualDisplays();
            for (BossBar bossBar : this.playerBossBars.values()) {
                bossBar.removeAll();
            }
            this.playerBossBars.clear();
        }

        private static class BarLayout {
            final int totalBars;
            final int barsPerRow;
            final int rows;

            BarLayout(int totalBars, int barsPerRow, int rows) {
                this.totalBars = totalBars;
                this.barsPerRow = barsPerRow;
                this.rows = rows;
            }
        }
    }

    private static class PopupData {
        private final TextDisplay display;
        private final Location startLocation;
        private final PopupType type;
        private final float baseScale;
        private final int maxTicks = 20;
        private int ticksAlive = 0;

        public PopupData(TextDisplay display, Location startLocation, PopupType type, float baseScale) {
            this.display = display;
            this.startLocation = startLocation.clone();
            this.type = type;
            this.baseScale = baseScale;
        }

        public boolean update() {
            ++this.ticksAlive;
            if (this.ticksAlive >= 20 || this.display == null || !this.display.isValid()) {
                return false;
            }
            float progress = (float)this.ticksAlive / 20.0f;
            double yOffset = (double)progress * 0.8;
            Location newLoc = this.startLocation.clone().add(0.0, yOffset, 0.0);
            this.display.teleport(newLoc);
            float scaleMultiplier = progress < 0.2f ? 1.0f + progress / 0.2f * 0.3f : (progress > 0.7f ? 1.3f - (progress - 0.7f) / 0.3f * 0.5f : 1.3f);
            float finalScale = this.baseScale * scaleMultiplier;
            Transformation transformation = new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector3f(finalScale, finalScale, finalScale), new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
            this.display.setTransformation(transformation);
            if (progress > 0.7f) {
                byte opacity = (byte)((1.0f - (progress - 0.7f) / 0.3f) * 255.0f);
                this.display.setTextOpacity(opacity);
            }
            return true;
        }

        public void cleanup() {
            if (this.display != null && this.display.isValid()) {
                EntityTracker.unregister((Entity)this.display, RemovalReason.EFFECT_TIMEOUT);
            }
        }
    }

    private static enum PopupType {
        DAMAGE,
        CRITICAL,
        HEAL,
        WEAK,
        RESIST;

    }
}

