/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.wormhole.WormholeManager;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public class PlayerTeleportEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Location destination;
    private final Location originalLocation;
    private final Player player;
    private boolean isCancelled = false;

    public PlayerTeleportEvent(Player player, Location destination) {
        this.player = player;
        this.destination = destination;
        this.originalLocation = player.getLocation().clone();
    }

    public static void teleportPlayer(Player player, Location destination) {
        new EventCaller(new PlayerTeleportEvent(player, destination));
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean b) {
        this.isCancelled = b;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public void executeTeleport() {
        if (!EliteMobsWorld.isEliteMobsWorld(this.player.getLocation().getWorld().getUID())) {
            PlayerData.setBackTeleportLocation(this.player, this.originalLocation);
        }
        WormholeManager.getInstance(false).addPlayerToCooldown(this.player, this.destination);
        this.player.teleport(this.destination);
    }

    @Generated
    public Location getDestination() {
        return this.destination;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    public static class PlayerTeleportEventExecutor
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            event.executeTeleport();
        }
    }
}

