/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.utils.CommandRunner;
import java.util.ArrayList;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class EliteMobExitCombatEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final EliteEntity eliteEntity;
    private final EliteMobExitCombatReason eliteMobExitCombatReason;

    public EliteMobExitCombatEvent(EliteEntity eliteEntity, EliteMobExitCombatReason reason) {
        this.eliteEntity = eliteEntity;
        this.eliteMobExitCombatReason = reason;
        eliteEntity.setInCombat(false);
        if (eliteEntity.getUnsyncedLivingEntity().isDead()) {
            return;
        }
        if (eliteEntity instanceof CustomBossEntity) {
            CommandRunner.runCommandFromList(((CustomBossEntity)eliteEntity).getCustomBossesConfigFields().getOnCombatLeaveCommands(), new ArrayList<CommandRunner.ConfigPlaceholder>());
        }
        if (eliteEntity.isValid() && MobCombatSettingsConfig.isRegenerateCustomBossHealthOnCombatEnd() && !reason.equals((Object)EliteMobExitCombatReason.PHASE_SWITCH) && !eliteEntity.getUnsyncedLivingEntity().getType().equals((Object)EntityType.PHANTOM)) {
            eliteEntity.fullHeal();
        }
        if (!DefaultConfig.isAlwaysShowNametags()) {
            eliteEntity.setNameVisible(false);
        }
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public EliteEntity getEliteMobEntity() {
        return this.eliteEntity;
    }

    public EliteMobExitCombatReason getEliteMobExitCombatReason() {
        return this.eliteMobExitCombatReason;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static enum EliteMobExitCombatReason {
        NO_NEARBY_PLAYERS,
        SPIRIT_WALK,
        ELITE_NOT_VALID,
        PHASE_SWITCH;

    }
}

