/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.treasurechest;

import com.google.common.collect.ArrayListMultimap;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.SoundsConfig;
import com.magmaguy.elitemobs.config.customtreasurechests.CustomTreasureChestConfigFields;
import com.magmaguy.elitemobs.config.customtreasurechests.CustomTreasureChestsConfig;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.mobconstructor.PersistentObjectHandler;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.WeightedProbability;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.Round;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TreasureChest
implements PersistentObject {
    private static final HashMap<Location, TreasureChest> treasureChestHashMap = new HashMap();
    private static final ArrayListMultimap<String, TreasureChest> instancedTreasureChests = ArrayListMultimap.create();
    private final CustomTreasureChestConfigFields customTreasureChestConfigFields;
    private final String locationString;
    private final String worldName;
    private final HashSet<UUID> blacklistedPlayersInstance = new HashSet();
    private Location location;
    private long restockTime;
    private EMPackage emPackage = null;

    public TreasureChest(CustomTreasureChestConfigFields customTreasureChestConfigFields, String locationString, long restockTime) {
        this.customTreasureChestConfigFields = customTreasureChestConfigFields;
        this.locationString = locationString;
        this.worldName = ConfigurationLocation.worldName(locationString);
        this.location = ConfigurationLocation.serialize(locationString);
        this.restockTime = restockTime;
        this.emPackage = EMPackage.getContent(customTreasureChestConfigFields.getFilename());
        if (!customTreasureChestConfigFields.isEnabled()) {
            return;
        }
        if (customTreasureChestConfigFields.getChestMaterial() == null) {
            return;
        }
        if (!customTreasureChestConfigFields.isInstanced()) {
            this.initializeChest();
            new PersistentObjectHandler(this);
            treasureChestHashMap.put(this.location, this);
        } else {
            instancedTreasureChests.put((Object)this.worldName, (Object)this);
        }
    }

    public static void initializeInstancedTreasureChests(String instanceWorldName, World instancedWorld) {
        List chests = instancedTreasureChests.get((Object)instanceWorldName);
        chests.forEach(treasureChest -> {
            treasureChest.location = ConfigurationLocation.serializeWithInstance(instancedWorld, treasureChest.locationString);
            treasureChest.restockTime = 0L;
            new PersistentObjectHandler((PersistentObject)treasureChest);
            treasureChest.generateChest();
            treasureChestHashMap.put(treasureChest.location, (TreasureChest)treasureChest);
        });
    }

    public static void clearTreasureChests() {
        treasureChestHashMap.clear();
    }

    public static TreasureChest getTreasureChest(Location location) {
        return TreasureChest.getTreasureChestHashMap().get(location);
    }

    private void initializeChest() {
        if (this.customTreasureChestConfigFields.isInstanced()) {
            return;
        }
        if (this.location != null && this.location.getWorld() != null) {
            long time = (this.restockTime - Instant.now().getEpochSecond()) * 20L;
            if (time < 0L) {
                this.generateChest();
            } else {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, this::generateChest, time);
            }
        }
    }

    private void generateChest() {
        try {
            if (!this.location.getWorld().getBlockAt(this.location).getType().equals((Object)this.customTreasureChestConfigFields.getChestMaterial())) {
                this.location.getWorld().getBlockAt(this.location).setType(this.customTreasureChestConfigFields.getChestMaterial());
            }
        }
        catch (Exception ex) {
            Logger.warn("Custom Treasure Chest " + this.customTreasureChestConfigFields.getFilename() + " has an invalid location and can not be placed.");
            return;
        }
        BlockData blockData = this.location.getBlock().getBlockData();
        if (blockData instanceof Directional) {
            Directional chest = (Directional)blockData;
            chest.setFacing(this.customTreasureChestConfigFields.getFacing());
            this.location.getBlock().setBlockData((BlockData)chest);
        } else {
            Logger.warn("Treasure chest " + this.customTreasureChestConfigFields.getFilename() + " does not have a directional block for the Treasure Chest material " + this.customTreasureChestConfigFields.getChestMaterial() + " ! Chest materials are directional, is your chest a chest?");
        }
        this.location.getBlock().getState().update();
    }

    public void doInteraction(final Player player) {
        if (this.customTreasureChestConfigFields.getDropStyle().equals((Object)DropStyle.GROUP)) {
            if (this.playerIsInCooldown(player)) {
                if (!this.customTreasureChestConfigFields.isInstanced()) {
                    this.groupTimerCooldownMessage(player, this.getPlayerCooldown(player));
                }
                return;
            }
            if (this.restockTime > Instant.now().getEpochSecond()) {
                return;
            }
        }
        if (this.customTreasureChestConfigFields.getDropStyle().equals((Object)DropStyle.GROUP)) {
            if (this.customTreasureChestConfigFields.isInstanced()) {
                this.blacklistedPlayersInstance.add(player.getUniqueId());
            } else if (this.customTreasureChestConfigFields.getRestockTimers() != null) {
                this.customTreasureChestConfigFields.getRestockTimers().add(this.cooldownStringConstructor(player));
                this.customTreasureChestConfigFields.getFileConfiguration().set("restockTimers", this.customTreasureChestConfigFields.getRestockTimers());
                try {
                    this.customTreasureChestConfigFields.getFileConfiguration().save(this.customTreasureChestConfigFields.getFile());
                }
                catch (Exception ex) {
                    Logger.warn("Failed to save restock timers for treasure chest " + this.customTreasureChestConfigFields.getFilename());
                }
                new BukkitRunnable(){

                    public void run() {
                        TreasureChest.this.customTreasureChestConfigFields.getRestockTimers().removeIf(restockTime -> restockTime.split(":")[0].equals(player.getUniqueId().toString()));
                        TreasureChest.this.customTreasureChestConfigFields.getFileConfiguration().set("restockTimers", TreasureChest.this.customTreasureChestConfigFields.getRestockTimers());
                        try {
                            TreasureChest.this.customTreasureChestConfigFields.getFileConfiguration().save(TreasureChest.this.customTreasureChestConfigFields.getFile());
                        }
                        catch (Exception ex) {
                            Logger.warn("Failed to save restock timers for treasure chest " + TreasureChest.this.customTreasureChestConfigFields.getFilename());
                        }
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1200L * (long)this.customTreasureChestConfigFields.getRestockTimer());
            }
        }
        if (ThreadLocalRandom.current().nextDouble() < this.customTreasureChestConfigFields.getMimicChance()) {
            this.doMimic();
        } else {
            this.doTreasure(player);
        }
        player.playSound(player.getLocation(), SoundsConfig.treasureChestOpenSound, 1.0f, 1.0f);
        if (this.customTreasureChestConfigFields.getDropStyle().equals((Object)DropStyle.GROUP)) {
            return;
        }
        this.location.getBlock().setType(Material.AIR);
        this.restockTime = this.cooldownTime();
        this.customTreasureChestConfigFields.setRestockTime(this.location, this.restockTime);
        if (!this.customTreasureChestConfigFields.isInstanced()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, this::generateChest, 1200L * (long)this.customTreasureChestConfigFields.getRestockTimer());
        }
    }

    private void doMimic() {
        HashMap<String, Double> weighedValues = new HashMap<String, Double>();
        for (String string : this.customTreasureChestConfigFields.getMimicCustomBossesList()) {
            String filename = string.split(":")[0];
            double weight = 1.0;
            try {
                weight = Double.parseDouble(string.split(":")[1]);
            }
            catch (Exception ex) {
                weight = 1.0;
            }
            weighedValues.put(filename, weight);
        }
        CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity(WeightedProbability.pickWeighedProbability(weighedValues));
        customBossEntity.spawn(this.location, this.randomizeTier(), false);
    }

    private void doTreasure(Player player) {
        this.customTreasureChestConfigFields.getCustomLootTable().treasureChestDrop(player, this.customTreasureChestConfigFields.getChestTier(), this.location);
    }

    private int randomizeTier() {
        return this.customTreasureChestConfigFields.getChestTier() * 10 + ThreadLocalRandom.current().nextInt(11);
    }

    private void lowRankMessage(Player player) {
        player.sendMessage(ChatColorConverter.convert(DefaultConfig.getChestLowRankMessage().replace("$rank", GuildRank.getRankName(Math.max(0, this.customTreasureChestConfigFields.getChestTier() - 10), this.customTreasureChestConfigFields.getChestTier()))));
    }

    private void groupTimerCooldownMessage(Player player, long targetTime) {
        player.sendMessage(ChatColorConverter.convert(DefaultConfig.getChestCooldownMessage().replace("$time", this.timeConverter(targetTime - Instant.now().getEpochSecond()))));
    }

    private boolean playerIsInCooldown(Player player) {
        if (this.customTreasureChestConfigFields.isInstanced()) {
            return this.blacklistedPlayersInstance.contains(player.getUniqueId());
        }
        if (this.customTreasureChestConfigFields.getRestockTimers() == null) {
            return false;
        }
        for (String string : this.customTreasureChestConfigFields.getRestockTimers()) {
            if (!string.split(":")[0].equals(player.getUniqueId().toString())) continue;
            return true;
        }
        return false;
    }

    private long getPlayerCooldown(Player player) {
        for (String string : this.customTreasureChestConfigFields.getRestockTimers()) {
            if (!string.split(":")[0].equals(player.getUniqueId().toString())) continue;
            return Long.parseLong(string.split(":")[1]);
        }
        return 0L;
    }

    private String cooldownStringConstructor(Player player) {
        return player.getUniqueId() + ":" + this.cooldownTime();
    }

    private long cooldownTime() {
        return Instant.now().getEpochSecond() + 60L * (long)this.customTreasureChestConfigFields.getRestockTimer();
    }

    private String timeConverter(long seconds) {
        if (seconds < 120L) {
            return seconds + " seconds";
        }
        if (seconds < 7200L) {
            return Round.twoDecimalPlaces((double)seconds / 60.0) + "minutes";
        }
        if (seconds < 172800L) {
            return Round.twoDecimalPlaces((double)seconds / 60.0 / 60.0) + "hours";
        }
        return Round.twoDecimalPlaces((double)seconds / 60.0 / 60.0 / 48.0) + "days";
    }

    public void removeTreasureChest() {
        CustomTreasureChestsConfig.removeTreasureChestEntry(this.location, this.customTreasureChestConfigFields.getFilename());
        if (this.location != null && this.location.getWorld() != null) {
            this.location.getBlock().setBlockData(Material.AIR.createBlockData());
        }
        treasureChestHashMap.remove(this.location);
    }

    @Override
    public void chunkLoad() {
    }

    @Override
    public void chunkUnload() {
    }

    @Override
    public void worldLoad(World world) {
        this.location = ConfigurationLocation.serialize(this.locationString);
        this.initializeChest();
        treasureChestHashMap.put(this.location, this);
    }

    @Override
    public void worldUnload() {
        treasureChestHashMap.remove(this.location);
    }

    @Override
    public Location getPersistentLocation() {
        return this.getLocation();
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Generated
    public static HashMap<Location, TreasureChest> getTreasureChestHashMap() {
        return treasureChestHashMap;
    }

    @Generated
    public CustomTreasureChestConfigFields getCustomTreasureChestConfigFields() {
        return this.customTreasureChestConfigFields;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public EMPackage getEmPackage() {
        return this.emPackage;
    }

    @Generated
    public void setEmPackage(EMPackage emPackage) {
        this.emPackage = emPackage;
    }

    public static enum DropStyle {
        SINGLE,
        GROUP;

    }

    public static class TreasureChestEvents
    implements Listener {
        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (event.getClickedBlock() == null) {
                return;
            }
            TreasureChest treasureChest = TreasureChest.getTreasureChest(event.getClickedBlock().getLocation());
            if (treasureChest == null) {
                return;
            }
            event.setCancelled(true);
            if (GuildRank.getMaxGuildRank(event.getPlayer()) < treasureChest.customTreasureChestConfigFields.getChestTier()) {
                treasureChest.lowRankMessage(event.getPlayer());
            } else {
                treasureChest.doInteraction(event.getPlayer());
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onBreak(BlockBreakEvent event) {
            for (TreasureChest treasureChest : treasureChestHashMap.values()) {
                if (treasureChest.getLocation() == null || treasureChest.getLocation().getWorld() == null || !event.getBlock().getLocation().equals((Object)treasureChest.location.getBlock().getLocation())) continue;
                event.setCancelled(true);
            }
        }
    }
}

