/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.playercooldowns;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.customquests.CustomQuestsConfigFields;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.playercooldowns.QuestCooldown;
import com.magmaguy.magmacore.util.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class PlayerQuestCooldowns
implements Serializable {
    private static final HashSet<Player> bypassedPlayers = new HashSet();
    private final List<QuestCooldown> questCooldowns = new ArrayList<QuestCooldown>();

    public static void toggleBypass(Player player) {
        if (!bypassedPlayers.contains(player)) {
            bypassedPlayers.add(player);
        } else {
            bypassedPlayers.remove(player);
        }
    }

    public static boolean bypassesQuestRestrictions(Player player) {
        return bypassedPlayers.contains(player);
    }

    public static PlayerQuestCooldowns initializePlayer() {
        return new PlayerQuestCooldowns();
    }

    public static void resetPlayerQuests(Player player) {
        if (PlayerData.getPlayerQuestCooldowns(player.getUniqueId()) == null) {
            return;
        }
        PermissionAttachment permissionAttachment = Objects.requireNonNull(player).addAttachment((Plugin)MetadataHandler.PLUGIN);
        PlayerQuestCooldowns playerQuestCooldowns = PlayerData.getPlayerQuestCooldowns(player.getUniqueId());
        for (QuestCooldown questCooldown : playerQuestCooldowns.getQuestCooldowns()) {
            if (questCooldown.getBukkitTask() != null) {
                questCooldown.getBukkitTask().cancel();
            }
            permissionAttachment.setPermission(questCooldown.getPermission(), false);
            player.removeMetadata(questCooldown.getPermission(), (Plugin)MetadataHandler.PLUGIN);
        }
        playerQuestCooldowns.getQuestCooldowns().clear();
        PlayerData.resetQuests(player.getUniqueId());
        PlayerData.resetPlayerQuestCooldowns(player.getUniqueId());
    }

    public static void resetPlayerQuestCooldown(Player player, CustomQuestsConfigFields customQuestsConfigFields) {
        if (PlayerData.getPlayerQuestCooldowns(player.getUniqueId()) == null) {
            return;
        }
        PermissionAttachment permissionAttachment = Objects.requireNonNull(player).addAttachment((Plugin)MetadataHandler.PLUGIN);
        String lockoutPermission = customQuestsConfigFields.getQuestLockoutPermission();
        if (lockoutPermission == null || lockoutPermission.isEmpty()) {
            return;
        }
        PlayerQuestCooldowns playerQuestCooldowns = PlayerData.getPlayerQuestCooldowns(player.getUniqueId());
        Iterator<QuestCooldown> iterator = playerQuestCooldowns.getQuestCooldowns().iterator();
        if (iterator.hasNext()) {
            QuestCooldown questCooldown = iterator.next();
            if (questCooldown.getPermission().equals(lockoutPermission)) {
                if (questCooldown.getBukkitTask() != null) {
                    questCooldown.getBukkitTask().cancel();
                }
                permissionAttachment.setPermission(questCooldown.getPermission(), false);
                player.removeMetadata(questCooldown.getPermission(), (Plugin)MetadataHandler.PLUGIN);
            }
            return;
        }
    }

    public static void addCooldown(Player player, String permission, int delayInMinutes) {
        PlayerQuestCooldowns playerQuestCooldowns = PlayerData.getPlayerQuestCooldowns(player.getUniqueId());
        if (playerQuestCooldowns == null) {
            playerQuestCooldowns = new PlayerQuestCooldowns();
            Logger.warn("For some reason the player cooldowns failed to read, warn the dev!", true);
        }
        playerQuestCooldowns.questCooldowns.add(new QuestCooldown(delayInMinutes, permission, player.getUniqueId()));
        PlayerData.updatePlayerQuestCooldowns(player.getUniqueId(), playerQuestCooldowns);
    }

    public static void flushPlayer(Player player) {
        PlayerQuestCooldowns playerQuestCooldowns = PlayerData.getPlayerQuestCooldowns(player.getUniqueId());
        if (playerQuestCooldowns == null) {
            return;
        }
        for (QuestCooldown questCooldown : Objects.requireNonNull(PlayerData.getPlayerQuestCooldowns((UUID)player.getUniqueId())).questCooldowns) {
            if (questCooldown.getBukkitTask() == null) continue;
            questCooldown.getBukkitTask().cancel();
        }
    }

    public void startCooldowns(UUID player) {
        for (QuestCooldown questCooldown : this.questCooldowns) {
            questCooldown.startCooldown(player);
        }
    }

    @Generated
    public static HashSet<Player> getBypassedPlayers() {
        return bypassedPlayers;
    }

    @Generated
    public List<QuestCooldown> getQuestCooldowns() {
        return this.questCooldowns;
    }
}

