/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.DynamicQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.menus.QuestMenu;
import com.magmaguy.elitemobs.quests.objectives.CustomFetchObjective;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class QuestInteractionHandler {
    private QuestInteractionHandler() {
    }

    public static void processDynamicQuests(Player player, NPCEntity npcEntity) {
        ArrayList<DynamicQuest> dynamicQuests = new ArrayList<DynamicQuest>();
        DynamicQuest.getQuests(player).forEach(quest -> {
            if (!quest.getQuestObjectives().isTurnedIn()) {
                dynamicQuests.add((DynamicQuest)quest);
            }
        });
        if (!dynamicQuests.isEmpty()) {
            QuestMenu.generateDynamicQuestMenu(dynamicQuests, player, npcEntity);
        }
    }

    public static void processNPCQuests(final Player player, final NPCEntity npcEntity) {
        final ArrayList<CustomQuest> customQuestList = new ArrayList<CustomQuest>();
        List<Quest> quests = PlayerData.getQuests(player.getUniqueId());
        QuestInteractionHandler.scanQuestTakerNPC(npcEntity, quests, customQuestList, player);
        boolean anyQuestIsValid = false;
        int questCompleteCount = 0;
        if (npcEntity.getNPCsConfigFields().getQuestFilenames() != null) {
            for (String questString : npcEntity.getNPCsConfigFields().getQuestFilenames()) {
                boolean activeQuest = false;
                for (CustomQuest customQuest : customQuestList) {
                    if (!customQuest.getCustomQuestsConfigFields().getFilename().equals(questString)) continue;
                    activeQuest = true;
                }
                if (activeQuest) continue;
                CustomQuest customQuest = CustomQuest.getQuest(questString, player);
                if (customQuest == null) {
                    player.sendMessage("[EliteMobs] This NPC's quest is not valid! This might be a configuration error on the NPC or on the quest.");
                    if (!player.hasPermission("elitemobs.*")) continue;
                    player.sendMessage("Invalid quest: " + questString);
                    continue;
                }
                if (customQuest.hasPermissionForQuest(player)) {
                    customQuestList.add(customQuest);
                    customQuest.setQuestGiver(npcEntity.getNPCsConfigFields().getFilename());
                    anyQuestIsValid = true;
                    continue;
                }
                if (customQuest.getCustomQuestsConfigFields().getQuestLockoutPermission().isEmpty() || !player.hasMetadata(customQuest.getCustomQuestsConfigFields().getQuestLockoutPermission())) continue;
                ++questCompleteCount;
                anyQuestIsValid = true;
            }
        }
        if (npcEntity.getNPCsConfigFields().getQuestFilenames() != null && questCompleteCount == npcEntity.getNPCsConfigFields().getQuestFilenames().size()) {
            player.sendMessage(QuestsConfig.getQuestAlreadyCompletedMessage());
        } else if (!anyQuestIsValid && npcEntity.getNPCsConfigFields().getQuestFilenames() != null) {
            player.sendMessage(QuestsConfig.getQuestPrerequisitesMissingMessage());
        }
        if (!customQuestList.isEmpty()) {
            new BukkitRunnable(){

                public void run() {
                    QuestMenu.generateCustomQuestMenu(customQuestList, player, npcEntity);
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
        }
    }

    private static void scanQuestTakerNPC(NPCEntity npcEntity, List<Quest> activeQuests, List<CustomQuest> npcQuests, Player player) {
        for (Quest quest : activeQuests) {
            if (!(quest instanceof CustomQuest) || !quest.getQuestTaker().equals(npcEntity.getNPCsConfigFields().getFilename())) continue;
            npcQuests.add((CustomQuest)quest);
            for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                if (!(objective instanceof CustomFetchObjective)) continue;
                objective.progressNonlinearObjective(quest.getQuestObjectives(), player);
            }
        }
    }
}

