/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.meta;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.PlayerDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.config.powers.PowersConfigFields;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashMap;
import java.util.HashSet;
import lombok.Generated;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ElitePower {
    private static final HashMap<String, CustomConfigFields> elitePowers = new HashMap();
    private static final HashSet<CustomConfigFields> bossPowers = new HashSet();
    private static final HashSet<CustomConfigFields> majorPowers = new HashSet();
    private static final HashSet<CustomConfigFields> defensivePowers = new HashSet();
    private static final HashSet<CustomConfigFields> miscellaneousPowers = new HashSet();
    private static final HashSet<CustomConfigFields> offensivePowers = new HashSet();
    private static final HashSet<CustomConfigFields> specialPowers = new HashSet();
    private final String fileName;
    private final CustomConfigFields powersConfigFields;
    private String trail = null;
    private int powerCooldownTime = 0;
    private int globalCooldownTime = 0;
    private boolean inGlobalCooldown = false;
    private boolean powerCooldownActive = false;
    private boolean isFiring = false;

    public ElitePower(CustomConfigFields customConfigFields) {
        this.fileName = customConfigFields.getFilename();
        this.powersConfigFields = customConfigFields;
    }

    public ElitePower(PowersConfigFields powersConfigFields) {
        this.powersConfigFields = powersConfigFields;
        this.fileName = powersConfigFields.getFilename();
        this.trail = powersConfigFields.getEffect();
        this.powerCooldownTime = powersConfigFields.getPowerCooldown();
        this.globalCooldownTime = powersConfigFields.getGlobalCooldown();
    }

    public static void addPower(EliteEntity eliteEntity, PowersConfigFields configFields) {
        if (configFields.getEliteScriptBlueprints().isEmpty()) {
            try {
                ElitePower elitePower = configFields.getElitePowerClass().newInstance();
                eliteEntity.getElitePowers().add(elitePower);
                elitePower.applyPowers(eliteEntity.getLivingEntity());
            }
            catch (Exception ex) {
                Logger.warn("Failed to assign power for config field " + configFields.getFilename());
            }
        } else {
            eliteEntity.getElitePowers().addAll(EliteScript.generateBossScripts(configFields.getEliteScriptBlueprints(), eliteEntity));
        }
    }

    public static void initializePowers() {
        Reflections reflections = new Reflections("com.magmaguy.elitemobs.powers", new Scanner[0]);
        reflections.getSubTypesOf(ElitePower.class).forEach(power -> {
            try {
                ElitePower thisPower = (ElitePower)power.newInstance();
                switch (((PowersConfigFields)thisPower.getPowersConfigFields()).getPowerType()) {
                    case DEFENSIVE: {
                        defensivePowers.add(thisPower.getPowersConfigFields());
                        break;
                    }
                    case OFFENSIVE: {
                        offensivePowers.add(thisPower.getPowersConfigFields());
                        break;
                    }
                    case MAJOR_BLAZE: 
                    case MAJOR_ENDERMAN: 
                    case MAJOR_SKELETON: 
                    case MAJOR_GHAST: 
                    case MAJOR_ZOMBIE: {
                        majorPowers.add(thisPower.getPowersConfigFields());
                        break;
                    }
                    case MISCELLANEOUS: {
                        miscellaneousPowers.add(thisPower.getPowersConfigFields());
                    }
                }
                elitePowers.put(thisPower.getFileName(), thisPower.getPowersConfigFields());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    protected static boolean eventIsValid(EliteMobDamagedByPlayerEvent event, ElitePower elitePower, boolean ignoreGlobalCooldown) {
        if (event.isCancelled()) {
            return false;
        }
        if (event.getEliteMobEntity().getLivingEntity() == null) {
            return false;
        }
        if (!event.getEliteMobEntity().getLivingEntity().hasAI()) {
            return false;
        }
        if (!ignoreGlobalCooldown && elitePower.isInGlobalCooldown()) {
            return false;
        }
        return !event.getEliteMobEntity().isInCooldown();
    }

    protected static boolean eventIsValid(EliteMobDamagedByPlayerEvent event, ElitePower elitePower) {
        if (event.isCancelled()) {
            return false;
        }
        if (event.getEliteMobEntity().getLivingEntity() == null) {
            return false;
        }
        if (!event.getEliteMobEntity().getLivingEntity().hasAI()) {
            return false;
        }
        if (elitePower.isInGlobalCooldown()) {
            return false;
        }
        if (elitePower.isInCooldown(event.getEliteMobEntity())) {
            return false;
        }
        return !event.getEliteMobEntity().isInCooldown();
    }

    protected static boolean eventIsValid(PlayerDamagedByEliteMobEvent event, ElitePower elitePower) {
        if (event.isCancelled()) {
            return false;
        }
        if (event.getEliteMobEntity().getLivingEntity() == null) {
            return false;
        }
        if (!event.getEliteMobEntity().getLivingEntity().hasAI()) {
            return false;
        }
        if (elitePower.isInGlobalCooldown()) {
            return false;
        }
        return !event.getEliteMobEntity().isInCooldown();
    }

    public void applyPowers(LivingEntity livingEntity) {
    }

    public boolean isInCooldown(EliteEntity eliteEntity) {
        return this.powerCooldownActive || eliteEntity.isInCooldown();
    }

    public void setInCooldown(EliteEntity eliteEntity, boolean inCooldown) {
        eliteEntity.setInCooldown(inCooldown);
        this.setInGlobalCooldown(inCooldown);
    }

    public void doCooldown(EliteEntity eliteEntity) {
        this.powerCooldownActive = true;
        if (this.globalCooldownTime < 1) {
            return;
        }
        eliteEntity.doGlobalPowerCooldown(this.globalCooldownTime * 20);
        new BukkitRunnable(){

            public void run() {
                ElitePower.this.powerCooldownActive = false;
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)this.powerCooldownTime * 20L);
    }

    public void doCooldownTicks(EliteEntity eliteEntity) {
        this.powerCooldownActive = true;
        if (this.globalCooldownTime > 0) {
            eliteEntity.doGlobalPowerCooldown(this.globalCooldownTime);
        }
        if (this.powerCooldownTime > 0) {
            new BukkitRunnable(){

                public void run() {
                    ElitePower.this.powerCooldownActive = false;
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)this.powerCooldownTime);
        }
    }

    protected void doGlobalCooldown(int ticks, EliteEntity eliteEntity) {
        this.setInGlobalCooldown(true);
        eliteEntity.doCooldown();
        new BukkitRunnable(){

            public void run() {
                ElitePower.this.setInGlobalCooldown(false);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)ticks);
    }

    protected void doGlobalCooldown(int ticks) {
        this.setInGlobalCooldown(true);
        new BukkitRunnable(){

            public void run() {
                ElitePower.this.setInGlobalCooldown(false);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)ticks);
    }

    @Generated
    public static HashMap<String, CustomConfigFields> getElitePowers() {
        return elitePowers;
    }

    @Generated
    public static HashSet<CustomConfigFields> getBossPowers() {
        return bossPowers;
    }

    @Generated
    public static HashSet<CustomConfigFields> getMajorPowers() {
        return majorPowers;
    }

    @Generated
    public static HashSet<CustomConfigFields> getDefensivePowers() {
        return defensivePowers;
    }

    @Generated
    public static HashSet<CustomConfigFields> getMiscellaneousPowers() {
        return miscellaneousPowers;
    }

    @Generated
    public static HashSet<CustomConfigFields> getOffensivePowers() {
        return offensivePowers;
    }

    @Generated
    public static HashSet<CustomConfigFields> getSpecialPowers() {
        return specialPowers;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public CustomConfigFields getPowersConfigFields() {
        return this.powersConfigFields;
    }

    @Generated
    public String getTrail() {
        return this.trail;
    }

    @Generated
    public int getPowerCooldownTime() {
        return this.powerCooldownTime;
    }

    @Generated
    public void setPowerCooldownTime(int powerCooldownTime) {
        this.powerCooldownTime = powerCooldownTime;
    }

    @Generated
    public int getGlobalCooldownTime() {
        return this.globalCooldownTime;
    }

    @Generated
    public void setGlobalCooldownTime(int globalCooldownTime) {
        this.globalCooldownTime = globalCooldownTime;
    }

    @Generated
    public boolean isInGlobalCooldown() {
        return this.inGlobalCooldown;
    }

    @Generated
    public void setInGlobalCooldown(boolean inGlobalCooldown) {
        this.inGlobalCooldown = inGlobalCooldown;
    }

    @Generated
    public boolean isPowerCooldownActive() {
        return this.powerCooldownActive;
    }

    @Generated
    public boolean isFiring() {
        return this.isFiring;
    }

    @Generated
    public void setFiring(boolean isFiring) {
        this.isFiring = isFiring;
    }
}

