/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.ProjectileDamage;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GoldExplosion
extends BossPower
implements Listener {
    public GoldExplosion() {
        super(PowersConfig.getPower("gold_explosion.yml"));
    }

    @EventHandler
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        GoldExplosion goldExplosion = (GoldExplosion)event.getEliteMobEntity().getPower(this);
        if (goldExplosion == null) {
            return;
        }
        if (!GoldExplosion.eventIsValid(event, (ElitePower)goldExplosion)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        goldExplosion.doGlobalCooldown(400, event.getEliteMobEntity());
        this.doGoldExplosion(event.getEliteMobEntity());
    }

    private void doGoldExplosion(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                if (MobCombatSettingsConfig.isEnableWarningVisualEffects()) {
                    eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.SMOKE, eliteEntity.getLivingEntity().getLocation(), this.counter, 1.0, 1.0, 1.0, 0.0);
                }
                if ((double)this.counter < 30.0) {
                    return;
                }
                this.cancel();
                eliteEntity.getLivingEntity().setAI(true);
                List<Item> goldNuggets = GoldExplosion.this.generateVisualItems(eliteEntity);
                ProjectileDamage.doGoldNuggetDamage(goldNuggets, eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private List<Item> generateVisualItems(EliteEntity eliteEntity) {
        ArrayList<Item> visualItemsList = new ArrayList<Item>();
        for (int i = 0; i < 200; ++i) {
            Vector velocityVector = new Vector(ThreadLocalRandom.current().nextDouble() - 0.5, ThreadLocalRandom.current().nextDouble() / 1.5, ThreadLocalRandom.current().nextDouble() - 0.5);
            Item visualProjectile = eliteEntity.getLivingEntity().getWorld().dropItem(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(velocityVector.getX(), 0.5, velocityVector.getZ())), ItemStackGenerator.generateItemStack(Material.GOLD_NUGGET, "visual projectile", List.of("" + ThreadLocalRandom.current().nextDouble())));
            ProjectileDamage.configureVisualProjectile(visualProjectile);
            visualProjectile.setVelocity(velocityVector);
            visualItemsList.add(visualProjectile);
        }
        return visualItemsList;
    }
}

