/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.elitemobs.ondeathcommands.OnDeathCommands;
import com.magmaguy.elitemobs.thirdparty.discordsrv.DiscordSRVAnnouncement;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Round;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class CustomBossDeath
implements Listener {
    private static void doLoot(CustomBossEntity customBossEntity) {
        if (customBossEntity.isTriggeredAntiExploit()) {
            return;
        }
        if (customBossEntity.customBossesConfigFields.getUniqueLootList() == null || customBossEntity.customBossesConfigFields.getUniqueLootList().isEmpty()) {
            return;
        }
        Set<Object> lockedOutPlayers = Set.of();
        if (customBossEntity instanceof InstancedBossEntity) {
            InstancedBossEntity instancedBoss = (InstancedBossEntity)customBossEntity;
            lockedOutPlayers = instancedBoss.getLockoutPlayers();
        }
        for (Player player : customBossEntity.getDamagers().keySet()) {
            if (lockedOutPlayers.contains(player)) continue;
            CustomBossDeath.dropLoot(player, customBossEntity);
        }
    }

    public static void dropLoot(Player player, CustomBossEntity customBossEntity) {
        customBossEntity.customBossesConfigFields.getCustomLootTable().bossDrop(player, customBossEntity.getLevel(), customBossEntity.getLocation(), customBossEntity);
    }

    private static void doDeathMessage(CustomBossEntity customBossEntity) {
        if (!MobCombatSettingsConfig.isEnableDeathMessages()) {
            return;
        }
        StringBuilder playersList = new StringBuilder();
        for (Player player : customBossEntity.getDamagers().keySet()) {
            if (playersList.length() == 0) {
                playersList.append(player.getDisplayName());
                continue;
            }
            playersList.append(", &f").append(player.getDisplayName());
        }
        playersList = new StringBuilder(ChatColorConverter.convert(playersList.toString()));
        if (customBossEntity.hasDamagers()) {
            if (customBossEntity.customBossesConfigFields.getDeathMessages() != null && !customBossEntity.customBossesConfigFields.getDeathMessages().isEmpty()) {
                Player topDamager = null;
                Player secondDamager = null;
                Player thirdDamager = null;
                HashMap<Player, Double> sortedMap = CustomBossDeath.sortByComparator(customBossEntity.getDamagers(), false);
                Iterator<Player> sortedMapIterator = sortedMap.keySet().iterator();
                block6: for (int i = 1; i < 4 && i <= sortedMap.size(); ++i) {
                    Player nextPlayer = sortedMapIterator.next();
                    switch (i) {
                        case 1: {
                            topDamager = nextPlayer;
                            continue block6;
                        }
                        case 2: {
                            secondDamager = nextPlayer;
                            continue block6;
                        }
                        case 3: {
                            thirdDamager = nextPlayer;
                        }
                    }
                }
                for (String string : customBossEntity.customBossesConfigFields.getDeathMessages()) {
                    if (string.contains("$damager1name")) {
                        string = topDamager != null ? string.replace("$damager1name", topDamager.getDisplayName()) : "";
                    }
                    if (string.contains("$damager1damage")) {
                        string = topDamager != null ? string.replace("$damager1damage", "" + Round.twoDecimalPlaces(customBossEntity.getDamagers().get(topDamager))) : "";
                    }
                    if (string.contains("$damager2name")) {
                        string = secondDamager != null ? string.replace("$damager2name", secondDamager.getDisplayName()) : "";
                    }
                    if (string.contains("$damager2damage")) {
                        string = secondDamager != null ? string.replace("$damager2damage", "" + Round.twoDecimalPlaces(customBossEntity.getDamagers().get(secondDamager))) : "";
                    }
                    if (string.contains("$damager3name")) {
                        string = thirdDamager != null ? string.replace("$damager3name", thirdDamager.getDisplayName()) : "";
                    }
                    if (string.contains("$damager3damage")) {
                        string = thirdDamager != null ? string.replace("$damager3damage", "" + Round.twoDecimalPlaces(customBossEntity.getDamagers().get(thirdDamager))) : "";
                    }
                    if (string.contains("$players")) {
                        string = string.replace("$players", playersList.toString());
                    }
                    if (customBossEntity.customBossesConfigFields.getAnnouncementPriority() > 0) {
                        Bukkit.broadcastMessage((String)ChatColorConverter.convert(string));
                    }
                    if (string.length() <= 0) continue;
                    if (customBossEntity.customBossesConfigFields.getAnnouncementPriority() > 2) {
                        new DiscordSRVAnnouncement(ChatColorConverter.convert(string));
                        continue;
                    }
                    if (customBossEntity.customBossesConfigFields.getAnnouncementPriority() >= 1) continue;
                    for (Player player : customBossEntity.getDamagers().keySet()) {
                        player.sendMessage(ChatColorConverter.convert(string));
                    }
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!customBossEntity.getDamagers().containsKey(player)) continue;
                    player.sendMessage(ChatColorConverter.convert(MobCombatSettingsConfig.getBossKillParticipationMessage().replace("$playerDamage", "" + Round.twoDecimalPlaces(customBossEntity.getDamagers().get(player)))));
                }
            } else if (customBossEntity.customBossesConfigFields.getDeathMessage() != null) {
                if (customBossEntity.customBossesConfigFields.getAnnouncementPriority() == 0) {
                    for (Player player : customBossEntity.getDamagers().keySet()) {
                        player.sendMessage(ChatColorConverter.convert(customBossEntity.customBossesConfigFields.getDeathMessage().replace("$players", playersList.toString())));
                    }
                }
                if (customBossEntity.customBossesConfigFields.getAnnouncementPriority() > 0) {
                    Bukkit.broadcastMessage((String)ChatColorConverter.convert(customBossEntity.customBossesConfigFields.getDeathMessage().replace("$players", playersList.toString())));
                }
                if (customBossEntity.customBossesConfigFields.getAnnouncementPriority() > 2) {
                    new DiscordSRVAnnouncement(ChatColorConverter.convert(customBossEntity.customBossesConfigFields.getDeathMessage().replace("$players", playersList.toString())));
                }
            }
        }
    }

    private static HashMap<Player, Double> sortByComparator(Map<Player, Double> unsortMap, final boolean order) {
        LinkedList<Map.Entry<Player, Double>> list = new LinkedList<Map.Entry<Player, Double>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Player, Double>>(){

            @Override
            public int compare(Map.Entry<Player, Double> o1, Map.Entry<Player, Double> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<Player, Double> sortedMap = new LinkedHashMap<Player, Double>();
        for (Map.Entry entry : list) {
            sortedMap.put((Player)entry.getKey(), (Double)entry.getValue());
        }
        return sortedMap;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEliteMobDeath(EliteMobDeathEvent event) {
        EliteEntity eliteEntity = event.getEliteEntity();
        if (!(eliteEntity instanceof CustomBossEntity)) {
            return;
        }
        CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
        CustomBossDeath.doLoot(customBossEntity);
        CustomBossDeath.doDeathMessage(customBossEntity);
        CustomBossEntity.trackableCustomBosses.remove(customBossEntity);
        if (customBossEntity.customBossesConfigFields.getOnDeathCommands() != null && !customBossEntity.customBossesConfigFields.getOnDeathCommands().isEmpty()) {
            OnDeathCommands.parseConsoleCommand(customBossEntity.customBossesConfigFields.getOnDeathCommands(), event);
        }
        if (!customBossEntity.customBossesConfigFields.isDropsVanillaLoot()) {
            event.getEntityDeathEvent().setDroppedExp(0);
            for (ItemStack itemStack : event.getEntityDeathEvent().getDrops()) {
                itemStack.setAmount(0);
            }
        }
    }
}

