/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.config.DungeonsConfig;
import com.magmaguy.elitemobs.dungeons.DynamicDungeonPackage;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.instanced.dungeons.DynamicDungeonInstance;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class DynamicDungeonBrowser
extends EliteMenu {
    private static final HashMap<Inventory, DynamicDungeonBrowser> inventories = new HashMap();
    private final EMPackage emPackage;
    private final MenuType menuType;
    private final List<Integer> levelSlots = List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7));
    private final List<Integer> difficultySlots = List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7));
    private Integer selectedLevel = null;

    public DynamicDungeonBrowser(Player player, String dynamicDungeonName) {
        this(player, dynamicDungeonName, MenuType.LEVEL_SELECTION, null);
    }

    private DynamicDungeonBrowser(Player player, String dynamicDungeonName, MenuType menuType, Integer selectedLevel) {
        EMPackage emPackage;
        this.emPackage = emPackage = EMPackage.getEmPackages().get(dynamicDungeonName);
        this.menuType = menuType;
        this.selectedLevel = selectedLevel;
        if (!(emPackage instanceof DynamicDungeonPackage)) {
            player.sendMessage("[EliteMobs] Not a valid dynamic dungeon!");
            return;
        }
        if (menuType == MenuType.LEVEL_SELECTION) {
            this.showLevelSelectionMenu(player, dynamicDungeonName);
        } else {
            this.showDifficultySelectionMenu(player, dynamicDungeonName);
        }
    }

    private void showLevelSelectionMenu(Player player, String dynamicDungeonName) {
        int maxGuildRank = GuildRank.getMaxGuildRank(player);
        int baseLevel = maxGuildRank * 10;
        int minLevel = Math.max(5, baseLevel - 5);
        int maxLevel = Math.min(200, baseLevel + 5);
        ArrayList<Integer> availableLevels = new ArrayList<Integer>();
        for (int level = minLevel; level <= maxLevel; level += 5) {
            availableLevels.add(level);
        }
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionMenuTitle()));
        for (int i = 0; i < availableLevels.size() && i < this.levelSlots.size(); ++i) {
            Material material;
            int level = (Integer)availableLevels.get(i);
            ArrayList<String> description = new ArrayList<String>();
            description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionClickToSelect().replace("$level", String.valueOf(level))));
            description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionMobsWillBeLevel().replace("$level", String.valueOf(level))));
            if (level == baseLevel) {
                material = Material.LIME_STAINED_GLASS_PANE;
                description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionRecommended()));
            } else if (level < baseLevel) {
                material = Material.YELLOW_STAINED_GLASS_PANE;
                description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionEasier()));
            } else {
                material = Material.ORANGE_STAINED_GLASS_PANE;
                description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionHarder()));
            }
            inventory.setItem(this.levelSlots.get(i).intValue(), ItemStackGenerator.generateItemStack(material, ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionItemTitle().replace("$level", String.valueOf(level))), description));
        }
        player.openInventory(inventory);
        inventories.put(inventory, this);
    }

    private void showDifficultySelectionMenu(Player player, String dynamicDungeonName) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonDifficultySelectionMenuTitle()));
        int difficultyCounter = 0;
        for (Map<String, Object> map : this.emPackage.getContentPackagesConfigFields().getDifficulties()) {
            ArrayList<String> description = new ArrayList<String>();
            for (String string : DungeonsConfig.getInstancedDungeonDescription()) {
                description.add(string.replace("$dungeonName", this.emPackage.getContentPackagesConfigFields().getName()));
            }
            description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonDifficultySelectionSelectedLevel().replace("$level", String.valueOf(this.selectedLevel))));
            inventory.setItem(this.difficultySlots.get(difficultyCounter).intValue(), ItemStackGenerator.generateItemStack(Material.GREEN_STAINED_GLASS_PANE, DungeonsConfig.getInstancedDungeonTitle().replace("$difficulty", "" + map.get("name")), description));
            ++difficultyCounter;
        }
        player.openInventory(inventory);
        inventories.put(inventory, this);
    }

    @Generated
    public EMPackage getEmPackage() {
        return this.emPackage;
    }

    private static enum MenuType {
        LEVEL_SELECTION,
        DIFFICULTY_SELECTION;

    }

    public static class DynamicDungeonBrowserEvents
    implements Listener {
        @EventHandler
        public void onInventoryInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, inventories.keySet())) {
                return;
            }
            event.setCancelled(true);
            if (!EliteMenu.isTopMenu(event)) {
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getType().equals((Object)Material.AIR)) {
                return;
            }
            DynamicDungeonBrowser browser = inventories.get(event.getInventory());
            Player player = (Player)event.getWhoClicked();
            event.getWhoClicked().closeInventory();
            if (browser.menuType == MenuType.LEVEL_SELECTION) {
                if (browser.levelSlots.contains(event.getSlot())) {
                    int levelIndex = browser.levelSlots.indexOf(event.getSlot());
                    int maxGuildRank = GuildRank.getMaxGuildRank(player);
                    int baseLevel = maxGuildRank * 10;
                    int minLevel = Math.max(5, baseLevel - 5);
                    int selectedLevel = minLevel + levelIndex * 5;
                    new DynamicDungeonBrowser(player, browser.getEmPackage().getContentPackagesConfigFields().getFilename(), MenuType.DIFFICULTY_SELECTION, selectedLevel);
                }
            } else if (browser.menuType == MenuType.DIFFICULTY_SELECTION && browser.difficultySlots.contains(event.getSlot())) {
                String difficultyName = (String)browser.getEmPackage().getContentPackagesConfigFields().getDifficulties().get(browser.difficultySlots.indexOf(event.getSlot())).get("name");
                DynamicDungeonInstance.setupDynamicDungeon(player, browser.getEmPackage().getContentPackagesConfigFields().getFilename(), difficultyName, browser.selectedLevel);
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            inventories.remove(event.getInventory());
        }
    }
}

